/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.api;

import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.IndexedProperties;
import java.lang.reflect.Constructor;

public class SocketFactoryUtils {
    public static final String kReuseSocketAddrPropertyName = "introscope.enterprisemanager.serversockets.reuseaddr";
    public static final String kSocketReceiveBufferSizePropertyName = "introscope.enterprisemanager.sockets.receivebuffersize";
    public static final String kSocketAbortiveClosePropertyName = "introscope.enterprisemanager.sockets.abortiveclose";

    private SocketFactoryUtils() {
    }

    public static <T> T createSocketFactory(Class<T> factoryClass, IndexedProperties properties, IModuleFeedbackChannel feedback) throws Exception {
        Constructor<?>[] constructors = factoryClass.getConstructors();
        T factory = null;
        int i = 0;
        while (factory == null && i < constructors.length) {
            Constructor<?> constructor = constructors[i];
            if (SocketFactoryUtils.isSocketFactoryConstructorNoProperties(constructor)) {
                System.setProperty(kReuseSocketAddrPropertyName, String.valueOf(properties.getBooleanProperty(kReuseSocketAddrPropertyName)));
                System.setProperty(kSocketAbortiveClosePropertyName, String.valueOf(properties.getBooleanProperty(kSocketAbortiveClosePropertyName)));
                System.setProperty(kSocketReceiveBufferSizePropertyName, String.valueOf(properties.getIntProperty(kSocketReceiveBufferSizePropertyName)));
                factory = (T)constructor.newInstance(feedback);
            } else if (SocketFactoryUtils.isSocketFactoryConstructorWithProperties(constructor)) {
                factory = (T)constructor.newInstance(properties, feedback);
            }
            ++i;
        }
        if (factory == null) {
            throw new Exception("No appropriate constructor found for socket factory named " + factoryClass);
        }
        return factory;
    }

    private static boolean isSocketFactoryConstructorNoProperties(Constructor<?> constructor) {
        Class<?>[] paramTypes = constructor.getParameterTypes();
        return paramTypes.length == 1 && IModuleFeedbackChannel.class.isAssignableFrom(paramTypes[0]);
    }

    private static boolean isSocketFactoryConstructorWithProperties(Constructor<?> constructor) {
        Class<?>[] paramTypes = constructor.getParameterTypes();
        return paramTypes.length == 2 && IndexedProperties.class.isAssignableFrom(paramTypes[0]) && IModuleFeedbackChannel.class.isAssignableFrom(paramTypes[1]);
    }
}

