/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.postoffice;

import com.wily.isengard.data.IIsengardCachedData;
import com.wily.isengard.util.parameter.CheckParameter;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class PostOfficeSpecifier
implements Externalizable,
IIsengardCachedData {
    private static final long serialVersionUID = -363369970730854542L;
    private String fHubName;
    private String fPostOfficeName;
    private String fFullPostOfficeName;
    private int fHashCode;

    public PostOfficeSpecifier() {
    }

    public PostOfficeSpecifier(String hubName, String postOfficeName) {
        CheckParameter.notNull("Hub Name", hubName);
        CheckParameter.notNull("Post Office Name", postOfficeName);
        this.fHubName = hubName;
        this.fPostOfficeName = postOfficeName;
        this.fFullPostOfficeName = this.createFullPostOfficeName(this.fHubName, this.fPostOfficeName);
        this.fHashCode = this.calculateHashCode(this.fHubName, this.fPostOfficeName);
    }

    public String getFullPostOfficeName() {
        return this.fFullPostOfficeName;
    }

    public String getPostOfficeName() {
        return this.fPostOfficeName;
    }

    public String getHubName() {
        return this.fHubName;
    }

    public boolean postOfficeHubEquals(String hubName) {
        return this.getHubName().equals(hubName);
    }

    public String toString() {
        return this.getFullPostOfficeName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof PostOfficeSpecifier) {
            PostOfficeSpecifier compareTo = (PostOfficeSpecifier)o;
            return compareTo.getHubName().equals(this.getHubName()) && compareTo.getPostOfficeName().equals(this.getPostOfficeName());
        }
        return false;
    }

    public int hashCode() {
        return this.fHashCode;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        CheckParameter.notNull("Input Stream", in);
        this.fHubName = in.readUTF();
        this.fPostOfficeName = in.readUTF();
        this.fFullPostOfficeName = this.createFullPostOfficeName(this.fHubName, this.fPostOfficeName);
        this.fHashCode = this.calculateHashCode(this.fHubName, this.fPostOfficeName);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.getHubName());
        out.writeUTF(this.getPostOfficeName());
    }

    private String createFullPostOfficeName(String hubName, String postOfficeName) {
        return String.valueOf(hubName) + "." + postOfficeName;
    }

    private int calculateHashCode(String hubName, String postOfficeName) {
        int result = 17;
        result = 37 * result + hubName.hashCode();
        result = 37 * result + postOfficeName.hashCode();
        return result;
    }
}

