/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.postofficehub.link.v1;

import com.wily.isengard.postofficehub.link.v1.ABaseTransport;
import com.wily.isengard.util.parameter.CheckParameter;
import com.wily.isengard.util.thread.AThreadedExecutable;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.util.concurrent.CountDownLatch;

abstract class ARouteConnector
extends AThreadedExecutable {
    private ABaseTransport fTransport;
    private IModuleFeedbackChannel fFeedback;
    private CountDownLatch fLetRouteEstablish;
    private volatile boolean fErrorOccurredOnEstablish;

    public ARouteConnector(ABaseTransport transport) {
        CheckParameter.notNull("Transport", transport);
        this.fTransport = transport;
        this.fFeedback = transport.getFeedbackChannel();
        this.fLetRouteEstablish = new CountDownLatch(1);
    }

    public final boolean blockUntilRouteEstablished() {
        if (!this.isInvokingThreadSameAsExecutionThread()) {
            try {
                this.fLetRouteEstablish.await();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.fErrorOccurredOnEstablish;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void notifyThreadBlockedOnRouteEstablishment(boolean errorOccurred) {
        ARouteConnector aRouteConnector = this;
        synchronized (aRouteConnector) {
            this.fErrorOccurredOnEstablish = errorOccurred;
        }
        this.fLetRouteEstablish.countDown();
    }

    protected final ABaseTransport getTransport() {
        return this.fTransport;
    }

    protected final IModuleFeedbackChannel getFeedbackChannel() {
        return this.fFeedback;
    }
}

