/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.util.io;

import com.wily.isengard.util.io.CannotDeserializePlaceholderException;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.io.IKeyedClassLoader;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class CustomSerializationThrowableCarrier
implements Externalizable {
    private static final long serialVersionUID = 8356239793981136489L;
    private static final Class[] kThrowableParameterType = new Class[]{Throwable.class};
    private static final Class[] kStringParameterType = new Class[]{String.class};
    private static final Class[] kNoParameterTypes = new Class[0];
    private static final Object[] kNoArguments = new Object[0];
    private static final Integer kZero = 0;
    private static ThreadLocal sThrowableStackDepth = new ThreadLocal(){

        protected Object initialValue() {
            return kZero;
        }
    };
    private String fClassName;
    private String fMessage;
    private Throwable fCause;
    private String fStackTrace;
    private int fStackDepth;

    public CustomSerializationThrowableCarrier() {
    }

    public CustomSerializationThrowableCarrier(Throwable throwable) {
        this.fClassName = throwable.getClass().getName();
        this.fMessage = throwable.getMessage();
        try {
            Method method = throwable.getClass().getMethod("getCause", kNoParameterTypes);
            this.fCause = (Throwable)method.invoke((Object)throwable, kNoArguments);
        }
        catch (Exception exception) {}
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        throwable.printStackTrace(writer);
        this.fStackTrace = stringWriter.toString();
    }

    public Throwable reconstitute(IKeyedClassLoader keyedClassLoader, String classLoaderName, IModuleFeedbackChannel feedback, Module module) {
        Throwable throwable = null;
        try {
            Class clazz = keyedClassLoader.forName(classLoaderName, this.getClassName());
            if (!Throwable.class.isAssignableFrom(clazz)) {
                throw new InvalidClassException("Class " + clazz + " does not descend from Throwable");
            }
            Class throwableClass = clazz;
            if (this.getMessage() == null) {
                throwable = (Throwable)throwableClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            } else {
                Constructor constructor = throwableClass.getConstructor(kStringParameterType);
                throwable = (Throwable)constructor.newInstance(this.getMessage());
            }
        }
        catch (Throwable t) {
            throwable = new CannotDeserializePlaceholderException(this.getClassName(), this.getMessage(), t.getMessage());
        }
        this.tryInitCause(throwable, feedback, module);
        return throwable;
    }

    private void tryInitCause(Throwable throwable, IModuleFeedbackChannel feedback, Module module) {
        if (this.getCause() != null) {
            try {
                Method method = throwable.getClass().getMethod("initCause", kThrowableParameterType);
                method.invoke((Object)throwable, this.getCause());
            }
            catch (Exception e) {
                feedback.debug(module, "No initCause() for class: " + this.getClassName(), e);
            }
        }
    }

    public String getClassName() {
        return this.fClassName;
    }

    public String getMessage() {
        return this.fMessage;
    }

    public Throwable getCause() {
        return this.fCause;
    }

    public String getStackTrace() {
        return this.fStackTrace;
    }

    public boolean atTopOfChain() {
        return this.fStackDepth == 0;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fClassName = in.readUTF();
        this.fMessage = (String)in.readObject();
        this.fStackDepth = in.readInt();
        this.fCause = (Throwable)in.readObject();
        this.fStackTrace = in.readUTF();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.fClassName);
        out.writeObject(this.fMessage);
        Integer stackDepth = (Integer)sThrowableStackDepth.get();
        this.fStackDepth = stackDepth;
        out.writeInt(this.fStackDepth);
        if (this.fCause != null) {
            sThrowableStackDepth.set(this.fStackDepth + 1);
        }
        try {
            out.writeObject(this.fCause);
        }
        finally {
            if (this.fCause != null) {
                sThrowableStackDepth.set(stackDepth);
            }
        }
        out.writeUTF(this.fStackTrace);
    }
}

