/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util;

public class JavaVersion {
    private static String kVersionProperty = "java.version";
    private final int fMajor;
    private final int fMinor;
    private final int fRelease;
    private final int fBuild;
    private final boolean fFuzzy;

    private JavaVersion(int major, int minor, int release, int build, boolean fuzzy) {
        this.fMajor = major;
        this.fMinor = minor;
        this.fRelease = release;
        this.fBuild = build;
        this.fFuzzy = fuzzy;
    }

    public JavaVersion(int major, int minor, int release) {
        this(major, minor, release, -1, false);
    }

    public JavaVersion(int major, int minor, int release, int build) {
        this(major, minor, release, build, false);
    }

    private JavaVersion() {
        this(1, 0, 0, -1, true);
    }

    private static int parsePart(String wholeString) {
        String substr = wholeString;
        int num = -1;
        int index = 0;
        if (wholeString == null) {
            return 0;
        }
        int slen = wholeString.length();
        index = 0;
        while (index < slen) {
            try {
                substr = wholeString.substring(index, slen);
                num = Integer.parseInt(substr);
            }
            catch (Exception exception) {}
            if (num > 0) break;
            ++index;
        }
        if (num < 0) {
            index = 0;
            while (index < slen) {
                try {
                    substr = wholeString.substring(0, index);
                    num = Integer.parseInt(substr);
                }
                catch (Exception exception) {}
                if (num > 0) break;
                ++index;
            }
        }
        return num;
    }

    public int getMajor() {
        return this.fMajor;
    }

    public int getMinor() {
        return this.fMinor;
    }

    public int getRelease() {
        return this.fRelease;
    }

    public int getBuild() {
        return this.fBuild;
    }

    public boolean isFuzzy() {
        return this.fFuzzy;
    }

    public String toString() {
        return "JavaVersion: major=" + this.fMajor + " minor=" + this.fMinor + " release=" + this.fRelease + " build=" + this.fBuild + " fuzzy=" + this.fFuzzy;
    }

    public boolean hasMinorString() {
        return this.getMajor() >= 0 && this.getMinor() >= 0;
    }

    public String getMinorString() {
        if (this.hasMinorString()) {
            return String.valueOf(this.getMajor()) + "." + this.getMinor();
        }
        return null;
    }

    public static JavaVersion parseJavaVersion(String currentVersion) {
        if (currentVersion == null) {
            return new JavaVersion();
        }
        String partOne = null;
        String partTwo = null;
        String partThree = null;
        String partFour = null;
        String buildString = null;
        int index = 0;
        int major = 0;
        int minor = 0;
        int release = 0;
        int build = -1;
        int lastIndex = 0;
        int buildIndex = 0;
        boolean fuzzy = false;
        if ((buildIndex = currentVersion.indexOf(95, buildIndex)) >= 0) {
            buildString = currentVersion.substring(buildIndex + 1);
            try {
                build = Integer.parseInt(buildString);
            }
            catch (NumberFormatException numberFormatException) {}
            currentVersion = currentVersion.substring(0, buildIndex);
        }
        if ((index = currentVersion.indexOf(46, index)) <= 0) {
            partOne = currentVersion.substring(lastIndex, currentVersion.length());
        } else {
            partOne = currentVersion.substring(lastIndex, index);
            lastIndex = ++index;
            if ((index = currentVersion.indexOf(46, index)) <= 0) {
                partTwo = currentVersion.substring(lastIndex, currentVersion.length());
            } else {
                partTwo = currentVersion.substring(lastIndex, index);
                lastIndex = ++index;
                if ((index = currentVersion.indexOf(46, index)) <= 0) {
                    partThree = currentVersion.substring(lastIndex, currentVersion.length());
                } else {
                    partThree = currentVersion.substring(lastIndex, index);
                    lastIndex = ++index;
                    if ((index = currentVersion.indexOf(46, index)) <= 0) {
                        partFour = currentVersion.substring(lastIndex, currentVersion.length());
                    } else {
                        partFour = currentVersion.substring(lastIndex, index);
                        lastIndex = ++index;
                    }
                }
            }
        }
        major = JavaVersion.parsePart(partOne);
        if (major < 0) {
            fuzzy = true;
        }
        if ((minor = JavaVersion.parsePart(partTwo)) < 0) {
            fuzzy = true;
        }
        if ((release = JavaVersion.parsePart(partThree)) < 0) {
            fuzzy = true;
        }
        if (build < 0 && partFour != null) {
            build = JavaVersion.parsePart(partFour);
        }
        return new JavaVersion(major, minor, release, build, fuzzy);
    }

    public static JavaVersion getCurrentVersion() {
        return JavaVersion.parseJavaVersion(System.getProperty(kVersionProperty));
    }
}

