/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt.trie;

import com.wily.util.adt.primitive.PrimitiveCharObjMap;
import com.wily.util.adt.trie.Trie;
import com.wily.util.adt.trie.TrieNode;

public class PackagePrefixMatchingTrie
extends Trie {
    private String normalizePackagePrefix(String prefix) {
        if (prefix.contains(".")) {
            prefix = prefix.replace('.', '/');
        }
        if (prefix.endsWith("*")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        if (prefix.endsWith("/")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        return prefix;
    }

    @Override
    public void insert(String packagePrefix) {
        if (packagePrefix == null) {
            return;
        }
        packagePrefix = this.normalizePackagePrefix(packagePrefix);
        super.insert(packagePrefix);
    }

    @Override
    public boolean deleteEntry(String packagePrefix) {
        if (packagePrefix == null) {
            return false;
        }
        packagePrefix = this.normalizePackagePrefix(packagePrefix);
        return super.deleteEntry(packagePrefix);
    }

    @Override
    public boolean contains(String packagePrefix) {
        if (packagePrefix == null) {
            return false;
        }
        packagePrefix = this.normalizePackagePrefix(packagePrefix);
        return super.contains(packagePrefix);
    }

    @Override
    public void merge(Trie other) {
        super.merge(other);
    }

    public boolean matchesStoredPackagePrefixes(String classOrPackageName) {
        if (classOrPackageName == null) {
            return false;
        }
        classOrPackageName = this.normalizePackagePrefix(classOrPackageName);
        TrieNode current = this.getRoot();
        boolean wasPreviousEndOfWord = false;
        for (int i = 0; i < classOrPackageName.length(); ++i) {
            char temp = classOrPackageName.charAt(i);
            if (temp == '/' && wasPreviousEndOfWord) {
                return true;
            }
            PrimitiveCharObjMap<TrieNode> children = current.getChildren();
            if (children == null) {
                return false;
            }
            current = children.get(temp);
            if (current == null) {
                return false;
            }
            if (temp == '/' && current.isEndOfWord()) {
                return true;
            }
            wasPreviousEndOfWord = current.isEndOfWord();
        }
        return current.isEndOfWord();
    }
}

