/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt.trie;

import com.wily.util.adt.primitive.CharObjHashMap;
import com.wily.util.adt.primitive.CharObjMapEntry;
import com.wily.util.adt.primitive.PrimitiveCharObjMap;
import com.wily.util.adt.primitive.Synchronizer;

public class TrieNode {
    private PrimitiveCharObjMap<TrieNode> children;
    private boolean endOfWord;

    public TrieNode() {
        this.children = null;
        this.endOfWord = false;
    }

    public PrimitiveCharObjMap<TrieNode> getChildren() {
        return this.children;
    }

    public PrimitiveCharObjMap<TrieNode> getChildrenForInsert(boolean synch) {
        if (this.children == null) {
            this.children = new CharObjHashMap<TrieNode>();
            if (synch) {
                this.children = Synchronizer.synchronizedPrimitiveCharObjMap(this.children);
            }
        }
        return this.children;
    }

    public boolean isEndOfWord() {
        return this.endOfWord;
    }

    public void setEndOfWord(boolean endOfWord) {
        this.endOfWord = endOfWord;
    }

    public void setChildrenToNull() {
        this.children = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TrieNode)) {
            return false;
        }
        TrieNode trieNode = (TrieNode)o;
        if (this.endOfWord != trieNode.endOfWord) {
            return false;
        }
        return this.children != null ? this.children.equals(trieNode.children) : trieNode.children == null;
    }

    public int hashCode() {
        int result = this.children != null ? this.children.hashCode() : 0;
        result = 31 * result + (this.endOfWord ? 1 : 0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrieNode(TrieNode other, boolean synch) {
        this.endOfWord = other.isEndOfWord();
        if (other.getChildren() == null) {
            this.children = null;
            return;
        }
        this.children = new CharObjHashMap<TrieNode>();
        if (synch) {
            this.children = Synchronizer.synchronizedPrimitiveCharObjMap(this.children);
        }
        PrimitiveCharObjMap<TrieNode> primitiveCharObjMap = other.getChildren();
        synchronized (primitiveCharObjMap) {
            for (CharObjMapEntry<TrieNode> charObjMapEntry : other.getChildren()) {
                this.children.put(charObjMapEntry.getKey(), new TrieNode(charObjMapEntry.getValue(), synch));
            }
        }
    }
}

