/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.bit;

import com.wily.util.bit.AllocationSet;
import com.wily.util.bit.BitStackCollection;
import com.wily.wilyassert.Assertion;
import java.util.Arrays;

public final class SeverableBitStacks
extends BitStackCollection {
    public static final int kMetricStackID = 0;
    public static final int kBitsPerMetricShift = 12;
    public static final int kSegmentLongShift = 3;
    public static final int kBitsPerSegment = 9;
    public static final int kSegmentSizeInLongs = 8;
    private static final int kMaxPositiveIntShift = 31;
    private static final int kMaxSizeLongArrayShift = 37;
    private static final int kInitialChainsPerBlobsizeShift = 12;
    private static final int kChainAllocationHunkSize = 1024;
    private static final long kStackBottomCursorMask = -9223372036854775745L;
    public static final int kValidStackIdMask = 0x3FFFFFFF;
    private AllocationSet m_allocSet;
    public int m_blobSizeBits;
    private long m_cursorStackMask;
    public long[] m_startStacks;
    public long[] m_segments;
    private int m_numStacks;
    public int m_numSegBits;
    private int m_segBitShift;
    private SeverableBitstackOutOfMemoryHandler m_oomHandler;

    public SeverableBitStacks(int requestedSizeBitsShift, boolean retrySmallerSize) {
        this(null, requestedSizeBitsShift, retrySmallerSize);
    }

    public SeverableBitStacks(SeverableBitstackOutOfMemoryHandler handler, int requestedSizeBitsShift, boolean retrySmallerSize) {
        long[] segmentHeap;
        block11: {
            requestedSizeBitsShift = Math.min(requestedSizeBitsShift, 37);
            if (requestedSizeBitsShift > 37) {
                byte[] dummy;
                try {
                    try {
                        dummy = new byte[Integer.MAX_VALUE];
                        this.foolTheCompiler(dummy);
                    }
                    catch (OutOfMemoryError e) {
                        if (!retrySmallerSize) {
                            throw e;
                        }
                        requestedSizeBitsShift = Math.min(requestedSizeBitsShift, 37);
                        dummy = null;
                        System.gc();
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    Object dummy2 = null;
                    System.gc();
                    throw throwable;
                }
                dummy = null;
                System.gc();
            }
        }
        while (true) {
            try {
                Assertion.wilyAssert(requestedSizeBitsShift >= 20);
                this.m_startStacks = new long[Math.max(1 << requestedSizeBitsShift - 12, 1024)];
                this.m_allocSet = new AllocationSet(1 << requestedSizeBitsShift - 9 - 6);
                segmentHeap = new long[1 << requestedSizeBitsShift - 6];
            }
            catch (OutOfMemoryError e) {
                if (!retrySmallerSize) {
                    throw e;
                }
                --requestedSizeBitsShift;
                this.m_startStacks = null;
                this.m_allocSet = null;
                segmentHeap = null;
                System.gc();
                continue;
            }
            break;
        }
        this.m_segments = segmentHeap;
        this.m_blobSizeBits = requestedSizeBitsShift;
        this.m_numSegBits = requestedSizeBitsShift - 9;
        this.m_segBitShift = 64 - this.m_numSegBits;
        this.m_cursorStackMask = 0x3FFFFFFFL << this.m_blobSizeBits & Long.MAX_VALUE;
        this.m_numStacks = 0;
        this.m_oomHandler = handler;
    }

    public void foolTheCompiler(byte[] foo) {
    }

    public final int numberOfStacks() {
        return this.m_numStacks;
    }

    public final void alterStackList(int[] insertList, int insertListLen, int[] deleteList, int deleteListLen) {
        int stackID;
        long[] newStartStacks;
        int newStackLength = this.m_numStacks + insertListLen - deleteListLen;
        boolean newList = newStackLength > this.m_startStacks.length;
        long[] lArray = newStartStacks = newList ? new long[newStackLength + 1024 & 0xFFFFFC00] : this.m_startStacks;
        if (deleteListLen > 0) {
            if (insertListLen > 0) {
                int insIdx = insertListLen - 1;
                int delIdx = deleteListLen - 1;
                while (delIdx >= 0) {
                    int delStack = deleteList[delIdx];
                    while (insIdx >= 0 && delStack < (insertList[insIdx] & 0x3FFFFFFF)) {
                        --insIdx;
                    }
                    int insertIdx = insIdx + 1;
                    while (insertIdx < insertListLen) {
                        int insertValue = insertList[insertIdx];
                        insertList[insertIdx] = (insertValue & 0x3FFFFFFF) - 1 | insertValue & 0xC0000000;
                        ++insertIdx;
                    }
                    --delIdx;
                }
            }
            int index = 0;
            while (index < deleteListLen) {
                stackID = deleteList[index];
                long bits = this.m_startStacks[stackID];
                while (bits < 0L) {
                    int segmentId = (int)(bits << 1 >>> this.m_segBitShift);
                    bits = this.m_segments[(segmentId + 1 << 3) - 1];
                    this.m_allocSet.freeBit(segmentId);
                }
                int segmentCopySize = (index == deleteListLen - 1 ? this.m_numStacks : deleteList[index + 1]) - stackID - 1;
                if (segmentCopySize > 0) {
                    System.arraycopy(this.m_startStacks, stackID + 1, this.m_startStacks, stackID - index, segmentCopySize);
                }
                ++index;
            }
            Arrays.fill(this.m_startStacks, this.m_numStacks - deleteListLen, this.m_numStacks, 0L);
        }
        if (insertListLen > 0) {
            int lastEndPoint = this.m_numStacks - deleteListLen;
            stackID = 0;
            int index = insertListLen - 1;
            while (index >= 0) {
                stackID = insertList[index] & 0x3FFFFFFF;
                int segmentCopySize = lastEndPoint - stackID;
                lastEndPoint = stackID;
                stackID += index;
                if (segmentCopySize > 0) {
                    System.arraycopy(this.m_startStacks, lastEndPoint, newStartStacks, stackID + 1, segmentCopySize);
                }
                newStartStacks[stackID] = 0L;
                --index;
            }
            if (newList && stackID > 0) {
                System.arraycopy(this.m_startStacks, 0, newStartStacks, 0, stackID);
            }
        }
        this.m_startStacks = newStartStacks;
        this.m_numStacks = newStackLength;
    }

    public final void swapMetricStack(int newMetricStack) {
        long oldMetricStackStart = this.m_startStacks[0];
        this.m_startStacks[0] = this.m_startStacks[newMetricStack];
        this.m_startStacks[newMetricStack] = oldMetricStackStart;
    }

    @Override
    public final long[] getCursor() {
        return this.getStackCursor(0);
    }

    public final long[] getStackCursor(int stackID) {
        long[] cursor = new long[1];
        this.setCursorToStack(stackID, cursor);
        return cursor;
    }

    @Override
    public final int getCursorStack(long[] cursor) {
        return (int)((cursor[0] & this.m_cursorStackMask) >>> this.m_blobSizeBits);
    }

    @Override
    public final void setCursorToTop(long[] cursor) {
        int stackID = (int)((cursor[0] & this.m_cursorStackMask) >>> this.m_blobSizeBits);
        this.setCursorToStack(stackID, cursor);
    }

    @Override
    public final void setCursorToStack(int stackID, long[] cursor) {
        long topBits = this.m_startStacks[stackID];
        topBits = topBits >= 0L ? topBits << 1 >>> 58 : topBits << 1 >>> 64 - this.m_blobSizeBits | Long.MIN_VALUE;
        cursor[0] = topBits | (long)stackID << this.m_blobSizeBits;
    }

    public final long getStackBottom(int stackID) {
        return (long)stackID << this.m_blobSizeBits;
    }

    public final int capacityPercent() {
        return (int)((long)this.m_allocSet.cardinality() * 100L / (1L << this.m_numSegBits));
    }

    public final int capacityAbsolute() {
        return this.m_allocSet.cardinality();
    }

    public final int maxCapacity() {
        return 1 << this.m_numSegBits;
    }

    public final int getBitCount(long topPosition, long bottomPosition) {
        boolean cursorsAreInDifferentSegments;
        if (topPosition >= 0L) {
            return (int)(topPosition - bottomPosition);
        }
        int bitsToPack = bottomPosition < 0L ? -((int)(bottomPosition & 0x1FFL)) : 63 - this.m_blobSizeBits - (int)(bottomPosition & 0x3FL);
        bitsToPack = (int)((long)bitsToPack + (topPosition & 0x1FFL));
        int bottomSegment = bottomPosition < 0L ? (int)(bottomPosition >>> 9) & (1 << this.m_numSegBits) - 1 : -1;
        int topSeg = (int)(topPosition >>> 9) & (1 << this.m_numSegBits) - 1;
        long linkLongBits = this.m_segments[(topSeg + 1 << 3) - 1];
        boolean bl = cursorsAreInDifferentSegments = topSeg != bottomSegment && linkLongBits < 0L;
        if (cursorsAreInDifferentSegments) {
            int numberOfValidBitsInAnOrdinarySegment = 511 - this.m_numSegBits;
            do {
                bitsToPack += numberOfValidBitsInAnOrdinarySegment;
                topSeg = (int)(linkLongBits << 1 >>> this.m_segBitShift);
                linkLongBits = this.m_segments[(topSeg + 1 << 3) - 1];
            } while (topSeg != bottomSegment && linkLongBits < 0L);
            if (linkLongBits >= 0L) {
                bitsToPack += this.m_numSegBits;
            }
        }
        return bitsToPack;
    }

    public final long[] getStackSegment(long topPosition, long bottomPosition) {
        if (topPosition >= 0L) {
            long[] returnVal = new long[2];
            int stackID = (int)((topPosition & this.m_cursorStackMask) >>> this.m_blobSizeBits);
            returnVal[0] = this.m_startStacks[stackID] >>> (int)bottomPosition;
            returnVal[1] = topPosition - bottomPosition;
            return returnVal;
        }
        int bitsToPack = this.getBitCount(topPosition, bottomPosition);
        long[] bitset = topPosition < 0L ? this.m_segments : this.m_startStacks;
        int numLongs = bitsToPack + 63 >>> 6;
        long[] longVals = new long[numLongs + 1];
        longVals[numLongs] = bitsToPack;
        --bitsToPack;
        int arrayIndex = (int)((topPosition &= (1L << this.m_blobSizeBits) - 1L) >>> 6);
        while (true) {
            int longIdx;
            if ((topPosition & 0x3FL) == 0L) {
                if ((arrayIndex & 7) != 0) {
                    --arrayIndex;
                } else {
                    long bits = bitset[arrayIndex + 7];
                    if (bits >= 0L) {
                        bitset = this.m_startStacks;
                        arrayIndex = (int)(bottomPosition >>> this.m_blobSizeBits);
                        topPosition = 64 - this.m_blobSizeBits - 1;
                    } else {
                        arrayIndex = (int)((bits << 1 >>> this.m_segBitShift) + 1L << 3) - 1;
                        topPosition = ((long)arrayIndex + 1L << 6) - 1L;
                        if (bitset[arrayIndex] < 0L) {
                            topPosition -= (long)this.m_numSegBits;
                        }
                    }
                }
            }
            int srcValid = (int)(topPosition - 1L & 0x3FL) + 1;
            int dstValid = (bitsToPack & 0x3F) + 1;
            int n = longIdx = bitsToPack >>> 6;
            longVals[n] = longVals[n] | bitset[arrayIndex] << 64 - srcValid >>> 64 - dstValid;
            int bitsPacked = Math.min(srcValid, dstValid);
            if ((bitsToPack -= bitsPacked) < 0) break;
            topPosition -= (long)bitsPacked;
        }
        Assertion.wilyAssert(bitsToPack == -1);
        return longVals;
    }

    @Override
    public final void pushLong(int numBits, long value, int stackID) {
        int arrayIndex;
        long stackTop;
        long[] bitset;
        long bits = this.m_startStacks[stackID];
        if (bits >= 0L) {
            bitset = this.m_startStacks;
            stackTop = bits << 1 >>> 58;
            arrayIndex = stackID;
        } else {
            bitset = this.m_segments;
            stackTop = bits << 1 >>> 64 - this.m_blobSizeBits;
            arrayIndex = (int)(stackTop >>> 6);
        }
        while (true) {
            boolean atLinkLong = bitset != this.m_segments || (arrayIndex + 1 & 7) == 0;
            int bitID = (int)stackTop & 0x3F;
            int usableBitsInThisLong = 64 - bitID;
            if (atLinkLong) {
                usableBitsInThisLong -= 1 + (bitset != this.m_segments ? 6 : (bitset[arrayIndex] < 0L ? this.m_numSegBits : 0));
            }
            if (usableBitsInThisLong > 0) {
                int bitsToPack = numBits < usableBitsInThisLong ? numBits : usableBitsInThisLong;
                int shiftBits = 64 - bitsToPack;
                int n = arrayIndex;
                bitset[n] = bitset[n] | value << shiftBits >>> shiftBits - bitID;
                stackTop += (long)bitsToPack;
                if ((numBits -= bitsToPack) == 0) {
                    this.m_startStacks[stackID] = bitset != this.m_segments ? this.m_startStacks[stackID] & 0x1FFFFFFFFFFFFFFL | stackTop << 57 : this.m_startStacks[stackID] & (1L << 64 - this.m_blobSizeBits - 1) - 1L | stackTop << 64 - this.m_blobSizeBits - 1 | Long.MIN_VALUE;
                    return;
                }
                value >>>= bitsToPack;
            }
            if (atLinkLong) {
                int newSeg = this.m_allocSet.findFreeBitAndSet();
                if (newSeg == -1) {
                    if (this.m_oomHandler == null) {
                        throw new OutOfMemoryError("PackedBitSet: No more segments");
                    }
                    newSeg = this.m_oomHandler.handleOutOfMemoryEvent(this.m_allocSet);
                }
                int from = newSeg << 3;
                int to = from + 8;
                while (from < to) {
                    this.m_segments[from] = 0L;
                    ++from;
                }
                stackTop = (long)newSeg << 9;
                if (bitset == this.m_segments) {
                    long previousSegment = arrayIndex >>> 3;
                    this.m_segments[(newSeg + 1 << 3) - 1] = Long.MIN_VALUE | previousSegment << 63 - this.m_numSegBits;
                } else {
                    long prevValue = bitset[arrayIndex];
                    bitset = this.m_segments;
                    int bitsToShift = this.m_blobSizeBits - 6;
                    bitset[newSeg << 3] = prevValue << 7 >>> 64 - bitsToShift;
                    stackTop += (long)bitsToShift;
                }
            }
            arrayIndex = (int)(stackTop >>> 6);
        }
    }

    public final void decapitate(long cursorPos) {
        int stackID = (int)((cursorPos & this.m_cursorStackMask) >>> this.m_blobSizeBits);
        long bitIndex = cursorPos & (1L << this.m_blobSizeBits) - 1L;
        long startStackBits = this.m_startStacks[stackID];
        if (startStackBits >= 0L) {
            long bitId = bitIndex & 0x3FL;
            this.m_startStacks[stackID] = startStackBits & (1L << (int)bitId) - 1L | bitId << 57;
            return;
        }
        int segmentCursorIsIn = cursorPos < 0L ? (int)(bitIndex >>> 9) : -1;
        int segmentId = (int)(startStackBits << 1 >>> this.m_segBitShift);
        while (segmentId != segmentCursorIsIn) {
            this.m_allocSet.freeBit(segmentId);
            long nextLink = this.m_segments[(segmentId + 1 << 3) - 1];
            if (nextLink >= 0L) {
                long bitId = bitIndex & 0x3FL;
                this.m_startStacks[stackID] = startStackBits & (1L << (int)bitId) - 1L | bitId << 57;
                return;
            }
            segmentId = (int)(nextLink << 1 >>> this.m_segBitShift);
        }
        this.m_startStacks[stackID] = startStackBits & (1L << 63 - this.m_blobSizeBits) - 1L | bitIndex << 63 - this.m_blobSizeBits | Long.MIN_VALUE;
        int longId = (int)(bitIndex >>> 6);
        int linkLong = ((longId >>> 3) + 1 << 3) - 1;
        long validLinkLongMask = (1L << 64 - (this.m_segments[linkLong] < 0L ? this.m_numSegBits + 1 : 1)) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        long validCursorLongMask = (1L << (int)bitIndex) - 1L;
        if (longId < linkLong) {
            int n = longId++;
            this.m_segments[n] = this.m_segments[n] & validCursorLongMask;
            while (longId < linkLong) {
                this.m_segments[longId++] = 0L;
            }
        } else {
            validLinkLongMask |= validCursorLongMask;
        }
        int n = longId;
        this.m_segments[n] = this.m_segments[n] & validLinkLongMask;
    }

    @Override
    public final long readLong(int numBits, long[] cursor) throws ArrayIndexOutOfBoundsException {
        int arrayIndex;
        long[] bitset;
        long bits = cursor[0];
        int stackID = (int)((bits & this.m_cursorStackMask) >>> this.m_blobSizeBits);
        long bitIndex = bits & (1L << this.m_blobSizeBits) - 1L;
        if (bits >= 0L) {
            bitset = this.m_startStacks;
            arrayIndex = stackID;
        } else {
            bitset = this.m_segments;
            arrayIndex = (int)(bitIndex >>> 6);
        }
        int availableBitsInThisLong = (int)bitIndex & 0x3F;
        long value = 0L;
        while (true) {
            if (availableBitsInThisLong > 0) {
                int bitsToRead = numBits < availableBitsInThisLong ? numBits : availableBitsInThisLong;
                value <<= bitsToRead;
                value |= bitset[arrayIndex] << 64 - availableBitsInThisLong >>> 64 - bitsToRead;
                bitIndex -= (long)bitsToRead;
                if ((numBits -= bitsToRead) == 0) {
                    cursor[0] = (long)stackID << this.m_blobSizeBits | bitIndex;
                    if (bitset == this.m_segments) {
                        cursor[0] = cursor[0] | Long.MIN_VALUE;
                    }
                    return value;
                }
            }
            if (bitset != this.m_segments) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if ((arrayIndex & 7) != 0) {
                --arrayIndex;
                availableBitsInThisLong = 64;
                continue;
            }
            bits = bitset[arrayIndex + 8 - 1];
            if (bits >= 0L) {
                bitset = this.m_startStacks;
                arrayIndex = stackID;
                availableBitsInThisLong = 63 - this.m_blobSizeBits;
                bitIndex = availableBitsInThisLong;
                continue;
            }
            arrayIndex = (int)((bits << 1 >>> this.m_segBitShift) + 1L << 3) - 1;
            availableBitsInThisLong = 63;
            if (bitset[arrayIndex] < 0L) {
                availableBitsInThisLong -= this.m_numSegBits;
            }
            bitIndex = ((long)arrayIndex << 6) + (long)availableBitsInThisLong;
        }
    }

    public final long unpackEliasDelta(boolean decodeZero, long[] cursor) throws ArrayIndexOutOfBoundsException {
        int bitsInNextLong;
        int msbOfValue;
        long valueToReturn;
        int arrayIndex;
        long[] bitset;
        long bits = cursor[0];
        int stackID = (int)((bits & this.m_cursorStackMask) >>> this.m_blobSizeBits);
        long bitIndex = bits & (1L << this.m_blobSizeBits) - 1L;
        if (bits >= 0L) {
            bitset = this.m_startStacks;
            arrayIndex = stackID;
        } else {
            bitset = this.m_segments;
            arrayIndex = (int)(bitIndex >>> 6);
        }
        int availableBitsInThisLong = (int)bitIndex & 0x3F;
        if (availableBitsInThisLong == 0) {
            if (bitset != this.m_segments) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if ((arrayIndex & 7) != 0) {
                --arrayIndex;
                availableBitsInThisLong = 64;
            } else {
                bits = bitset[arrayIndex + 8 - 1];
                if (bits >= 0L) {
                    bitset = this.m_startStacks;
                    arrayIndex = stackID;
                    availableBitsInThisLong = 63 - this.m_blobSizeBits;
                } else {
                    arrayIndex = (int)((bits << 1 >>> this.m_segBitShift) + 1L << 3) - 1;
                    availableBitsInThisLong = 63;
                    if (bitset[arrayIndex] < 0L) {
                        availableBitsInThisLong -= this.m_numSegBits;
                    }
                }
            }
        }
        bits = bitset[arrayIndex] << 64 - availableBitsInThisLong;
        int msbOfMSB = availableBitsInThisLong;
        while (bits >= 0L && availableBitsInThisLong >= 0) {
            --availableBitsInThisLong;
            bits <<= 1;
        }
        if (bits >= 0L) {
            if (bitset != this.m_segments) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if ((arrayIndex & 7) != 0) {
                availableBitsInThisLong = 64;
                bits = bitset[--arrayIndex];
            } else {
                bits = bitset[arrayIndex + 8 - 1];
                if (bits >= 0L) {
                    bitset = this.m_startStacks;
                    arrayIndex = stackID;
                    availableBitsInThisLong = 64 - this.m_blobSizeBits - 1;
                    bits = bitset[arrayIndex] << this.m_blobSizeBits + 1;
                } else {
                    arrayIndex = (int)((bits << 1 >>> this.m_segBitShift) + 1L << 3) - 1;
                    availableBitsInThisLong = 63;
                    if (bitset[arrayIndex] < 0L) {
                        availableBitsInThisLong -= this.m_numSegBits;
                    }
                    bits = bitset[arrayIndex] << 64 - availableBitsInThisLong;
                }
            }
            msbOfMSB += availableBitsInThisLong;
            while (bits >= 0L && availableBitsInThisLong >= 0) {
                --availableBitsInThisLong;
                bits <<= 1;
            }
        }
        if ((msbOfMSB -= availableBitsInThisLong) == 0) {
            --availableBitsInThisLong;
            bits <<= 1;
            if (decodeZero) {
                if (availableBitsInThisLong == 0) {
                    if (bitset != this.m_segments) {
                        throw new ArrayIndexOutOfBoundsException();
                    }
                    if ((arrayIndex & 7) != 0) {
                        availableBitsInThisLong = 64;
                        bits = bitset[--arrayIndex];
                    } else {
                        bits = bitset[arrayIndex + 8 - 1];
                        if (bits >= 0L) {
                            bitset = this.m_startStacks;
                            arrayIndex = stackID;
                            availableBitsInThisLong = 63 - this.m_blobSizeBits;
                            bits = bitset[arrayIndex] << this.m_blobSizeBits + 1;
                        } else {
                            arrayIndex = (int)((bits << 1 >>> this.m_segBitShift) + 1L << 3) - 1;
                            availableBitsInThisLong = 63;
                            if (bitset[arrayIndex] < 0L) {
                                availableBitsInThisLong -= this.m_numSegBits;
                            }
                            bits = bitset[arrayIndex] << 64 - availableBitsInThisLong;
                        }
                    }
                }
                --availableBitsInThisLong;
                if (bits >= 0L) {
                    cursor[0] = (long)stackID << this.m_blobSizeBits | (long)availableBitsInThisLong;
                    if (bitset == this.m_segments) {
                        cursor[0] = cursor[0] | (Long.MIN_VALUE | (long)arrayIndex << 6);
                    }
                    return 0L;
                }
            }
            cursor[0] = (long)stackID << this.m_blobSizeBits | (long)availableBitsInThisLong;
            if (bitset == this.m_segments) {
                cursor[0] = cursor[0] | (Long.MIN_VALUE | (long)arrayIndex << 6);
            }
            return 1L;
        }
        if (msbOfMSB == 6) {
            valueToReturn = bits;
            msbOfValue = 64;
        } else {
            msbOfValue = (int)(bits >>> 64 - ++msbOfMSB);
            if (msbOfMSB < availableBitsInThisLong) {
                availableBitsInThisLong -= msbOfMSB;
                bits <<= msbOfMSB;
            } else {
                bitsInNextLong = msbOfMSB - availableBitsInThisLong;
                if (bitset != this.m_segments) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                if ((arrayIndex & 7) != 0) {
                    availableBitsInThisLong = 64;
                    bits = bitset[--arrayIndex];
                } else {
                    bits = bitset[arrayIndex + 8 - 1];
                    if (bits >= 0L) {
                        bitset = this.m_startStacks;
                        arrayIndex = stackID;
                        availableBitsInThisLong = 63 - this.m_blobSizeBits;
                        bits = bitset[arrayIndex] << this.m_blobSizeBits + 1;
                    } else {
                        arrayIndex = (int)((bits << 1 >>> this.m_segBitShift) + 1L << 3) - 1;
                        availableBitsInThisLong = 63;
                        if (bitset[arrayIndex] < 0L) {
                            availableBitsInThisLong -= this.m_numSegBits;
                        }
                        bits = bitset[arrayIndex] << 64 - availableBitsInThisLong;
                    }
                }
                if (bitsInNextLong != 0) {
                    msbOfValue |= (int)(bits >>> 64 - bitsInNextLong);
                    availableBitsInThisLong -= bitsInNextLong;
                    bits <<= bitsInNextLong;
                }
            }
            valueToReturn = 1L << --msbOfValue | bits >>> 64 - msbOfValue;
        }
        if (msbOfValue <= availableBitsInThisLong) {
            availableBitsInThisLong -= msbOfValue;
        } else {
            bitsInNextLong = msbOfValue - availableBitsInThisLong;
            if (bitset != this.m_segments) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if ((arrayIndex & 7) != 0) {
                availableBitsInThisLong = 64;
                bits = bitset[--arrayIndex];
            } else {
                bits = bitset[arrayIndex + 8 - 1];
                if (bits >= 0L) {
                    bitset = this.m_startStacks;
                    arrayIndex = stackID;
                    availableBitsInThisLong = 63 - this.m_blobSizeBits;
                    bits = bitset[arrayIndex] << this.m_blobSizeBits + 1;
                } else {
                    arrayIndex = (int)((bits << 1 >>> this.m_segBitShift) + 1L << 3) - 1;
                    availableBitsInThisLong = 63;
                    if (bitset[arrayIndex] < 0L) {
                        availableBitsInThisLong -= this.m_numSegBits;
                    }
                    bits = bitset[arrayIndex] << 64 - availableBitsInThisLong;
                }
            }
            valueToReturn |= bits >>> 64 - bitsInNextLong;
            if (bitsInNextLong <= availableBitsInThisLong) {
                availableBitsInThisLong -= bitsInNextLong;
            } else {
                int bitsInFinalLong = bitsInNextLong - availableBitsInThisLong;
                if (bitset != this.m_segments) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                if ((arrayIndex & 7) != 0) {
                    --arrayIndex;
                    availableBitsInThisLong = 64;
                } else {
                    bits = bitset[arrayIndex + 8 - 1];
                    if (bits >= 0L) {
                        bitset = this.m_startStacks;
                        arrayIndex = stackID;
                        availableBitsInThisLong = 63 - this.m_blobSizeBits;
                    } else {
                        arrayIndex = (int)((bits << 1 >>> this.m_segBitShift) + 1L << 3) - 1;
                        availableBitsInThisLong = 63;
                        if (bitset[arrayIndex] < 0L) {
                            availableBitsInThisLong -= this.m_numSegBits;
                        }
                    }
                }
                valueToReturn |= bitset[arrayIndex] >>> availableBitsInThisLong - bitsInFinalLong & (1L << bitsInFinalLong) - 1L;
                availableBitsInThisLong -= bitsInFinalLong;
            }
        }
        cursor[0] = (long)stackID << this.m_blobSizeBits | (long)availableBitsInThisLong;
        if (bitset == this.m_segments) {
            cursor[0] = cursor[0] | (Long.MIN_VALUE | (long)arrayIndex << 6);
        }
        return valueToReturn;
    }

    @Override
    public final boolean atStackBottom(long cursorValue) {
        return (cursorValue & 0x800000000000003FL) == 0L;
    }

    public final void truncate(long[] cursor) {
        int bitsUsedInTopSegment;
        long cursorBits = cursor[0];
        int stackID = (int)((cursorBits & this.m_cursorStackMask) >>> this.m_blobSizeBits);
        long bitIndex = cursorBits & (1L << this.m_blobSizeBits) - 1L;
        long segBits = this.m_startStacks[stackID];
        if (cursorBits >= 0L) {
            int bitId = (int)(bitIndex & Long.MAX_VALUE);
            if (bitId != 0) {
                if (segBits >= 0L) {
                    int currentTop = (int)(segBits << 1 >>> 58);
                    int newTop = currentTop - bitId;
                    this.m_startStacks[stackID] = segBits >>> bitId & (1L << newTop) - 1L | (long)newTop << 57;
                } else {
                    int segBitOffset;
                    long stackTop = segBits << 1 >>> 64 - this.m_blobSizeBits;
                    int segIndex = (int)(stackTop >> 9);
                    if (this.m_segments[(segIndex + 1 << 3) - 1] >= 0L && (segBitOffset = (int)(stackTop & 0x1FFL)) < bitId + this.m_numSegBits) {
                        int validBitsInLink = 63 - this.m_blobSizeBits - bitId;
                        this.m_startStacks[stackID] = segBits >>> bitId & (1L << validBitsInLink) - 1L | this.m_segments[segIndex << 3] << 64 - segBitOffset >>> 64 - segBitOffset - validBitsInLink | (long)(validBitsInLink + segBitOffset) << 57;
                        this.m_allocSet.freeBit(segIndex);
                    }
                }
            }
            return;
        }
        int cursorSegId = (int)(bitIndex >>> 9);
        long stackTop = segBits << 1 >>> 64 - this.m_blobSizeBits;
        boolean compressedBackToStartStack = false;
        if ((long)cursorSegId == stackTop >>> 9 && (compressedBackToStartStack = (bitsUsedInTopSegment = (int)(stackTop - bitIndex)) <= 57)) {
            if (bitsUsedInTopSegment == 0) {
                this.m_startStacks[stackID] = 0L;
            } else {
                int arrayIndex = (int)(stackTop >>> 6);
                bitsUsedInTopSegment = (bitsUsedInTopSegment - 1 & 0x3F) + 1;
                int bitsInLong = (int)stackTop & 0x3F;
                int bitsInPrevLong = bitsUsedInTopSegment - bitsInLong;
                long stackBits = this.m_segments[arrayIndex] << 64 - bitsInLong >>> 64 - bitsUsedInTopSegment;
                if (bitsInPrevLong > 0) {
                    stackBits |= this.m_segments[arrayIndex - 1] >>> 64 - bitsInPrevLong;
                }
                this.m_startStacks[stackID] = (stackBits | (long)bitsUsedInTopSegment << 57) & Long.MAX_VALUE;
            }
            this.m_allocSet.freeBit(cursorSegId);
        }
        int arrayIndex = (cursorSegId + 1 << 3) - 1;
        segBits = this.m_segments[arrayIndex];
        if (!compressedBackToStartStack && (segBits & Long.MIN_VALUE) != 0L) {
            if ((long)cursorSegId == stackTop >>> 9) {
                this.m_segments[arrayIndex] = segBits & Long.MAX_VALUE;
            } else {
                this.m_segments[arrayIndex] = segBits << this.m_numSegBits & Long.MAX_VALUE;
                do {
                    int n = arrayIndex;
                    this.m_segments[n] = this.m_segments[n] | this.m_segments[arrayIndex - 1] >>> this.m_segBitShift;
                    int n2 = --arrayIndex;
                    this.m_segments[n2] = this.m_segments[n2] << this.m_numSegBits;
                } while ((arrayIndex & 7) != 0);
            }
        }
        while (segBits < 0L) {
            int segmentId = (int)(segBits << 1 >>> this.m_segBitShift);
            this.m_allocSet.freeBit(segmentId);
            segBits = this.m_segments[(segmentId + 1 << 3) - 1];
        }
    }

    public final void verifyCacheIntegrety() {
        AllocationSet allocSet = new AllocationSet(1 << this.m_blobSizeBits - 9 - 6);
        int numberOfSegmentsAllocatedInCache = this.m_allocSet.cardinality();
        int lstCnt = 0;
        while (lstCnt < this.m_startStacks.length) {
            long debugbits = this.m_startStacks[lstCnt];
            while (debugbits < 0L) {
                int debugSegId = (int)(debugbits << 1 >>> this.m_segBitShift);
                allocSet.setBit(debugSegId);
                debugbits = this.m_segments[(debugSegId + 1 << 3) - 1];
            }
            ++lstCnt;
        }
        if (numberOfSegmentsAllocatedInCache != allocSet.cardinality() || !this.m_allocSet.debugBitsAreEqual(allocSet)) {
            System.out.println("Oops");
        }
    }

    public final void printCacheHeuristics() {
        int[] chainLengths = new int[10];
        int metricStack = 0;
        int lstCnt = 0;
        while (lstCnt < this.m_startStacks.length) {
            long debugbits = this.m_startStacks[lstCnt];
            int count = 0;
            while (debugbits < 0L) {
                int debugSegId = (int)(debugbits << 1 >>> this.m_segBitShift);
                debugbits = this.m_segments[(debugSegId + 1 << 3) - 1];
                ++count;
            }
            if (lstCnt == 0) {
                metricStack = count;
            } else {
                int n = count < 9 ? count : 9;
                chainLengths[n] = chainLengths[n] + 1;
            }
            ++lstCnt;
        }
        System.out.println("Heursitics: Metric stack=" + metricStack + " segments. Stacks: [" + chainLengths[0] + "/" + chainLengths[1] + "/" + chainLengths[2] + "/" + chainLengths[3] + "/" + chainLengths[4] + "/" + chainLengths[5] + "/" + chainLengths[6] + "/" + chainLengths[7] + "/" + chainLengths[8] + "/" + chainLengths[9] + "]");
    }

    public static interface SeverableBitstackOutOfMemoryHandler {
        public int handleOutOfMemoryEvent(AllocationSet var1) throws OutOfMemoryError;
    }
}

