/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.classfile;

import com.wily.util.classfile.FullyQualifiedFieldName;
import com.wily.util.classfile.FullyQualifiedMethodName;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IContainerName;
import com.wily.util.classfile.IFieldName;
import com.wily.util.classfile.IMethodName;
import com.wily.util.classfile.IMethodSignature;
import com.wily.util.classfile.ISlotSignature;

public abstract class ClassFileUtilities {
    private ClassFileUtilities() {
    }

    public static boolean looselyMatches(IContainerName pattern, IContainerName candidate) {
        return pattern.equals(candidate);
    }

    public static boolean matchPartialAssemblyName(IClassName pattern, IClassName candidate) {
        String candidateAssemblyName;
        String partialAssemblyName = pattern.getContainerName().getSimpleName();
        if (!partialAssemblyName.equals(candidateAssemblyName = candidate.getContainerName().getSimpleName())) {
            return false;
        }
        return pattern.getPackageAndNameString().equals(candidate.getPackageAndNameString());
    }

    public static boolean looselyMatches(IClassName pattern, IClassName candidate) {
        return pattern.looselyMatches(candidate);
    }

    public static boolean looselyMatches(IMethodName pattern, IMethodName candidate) {
        if (pattern.getNameString().equals(candidate.getNameString())) {
            if (!pattern.hasSignature()) {
                return true;
            }
            return ClassFileUtilities.looselyMatches(pattern.getSignature(), candidate.getSignature());
        }
        return false;
    }

    public static boolean looselyMatches(IFieldName pattern, IFieldName candidate) {
        if (pattern.getNameString().equals(candidate.getNameString())) {
            if (!pattern.hasSignature()) {
                return true;
            }
            return ClassFileUtilities.looselyMatches(pattern.getSignature(), candidate.getSignature());
        }
        return false;
    }

    public static boolean looselyMatches(FullyQualifiedFieldName pattern, FullyQualifiedFieldName candidate) {
        return ClassFileUtilities.looselyMatches(pattern.getClassName(), candidate.getClassName()) && ClassFileUtilities.looselyMatches(pattern.getFieldName(), candidate.getFieldName());
    }

    public static boolean looselyMatches(FullyQualifiedMethodName pattern, FullyQualifiedMethodName candidate) {
        return ClassFileUtilities.looselyMatches(pattern.getClassName(), candidate.getClassName()) && ClassFileUtilities.looselyMatches(pattern.getMethodName(), candidate.getMethodName());
    }

    public static boolean looselyMatches(ISlotSignature pattern, ISlotSignature candidate) {
        return pattern.looselyMatches(candidate);
    }

    public static boolean looselyMatches(IMethodSignature pattern, IMethodSignature candidate) {
        if (pattern == null || candidate == null) {
            return false;
        }
        if (pattern.getParameterCount() != candidate.getParameterCount()) {
            return false;
        }
        if (!ClassFileUtilities.looselyMatches(pattern.getReturnSlotSignature(), candidate.getReturnSlotSignature())) {
            return false;
        }
        int x = 0;
        while (x < pattern.getParameterCount()) {
            if (!ClassFileUtilities.looselyMatches(pattern.getParameterSignatureByIndex(x), candidate.getParameterSignatureByIndex(x))) {
                return false;
            }
            ++x;
        }
        return true;
    }

    public static String filterForClasses(String fullClassName) {
        int namespaceIndex1 = 0;
        int namespaceIndex2 = 0;
        String className = null;
        namespaceIndex1 = fullClassName.indexOf("[", 0);
        namespaceIndex2 = fullClassName.indexOf("]", namespaceIndex1 + 1);
        if (namespaceIndex2 > namespaceIndex1 && namespaceIndex2 < fullClassName.length()) {
            fullClassName = className = fullClassName.substring(namespaceIndex2 + 1);
        }
        return fullClassName;
    }
}

