/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.commandline;

import com.wily.util.commandline.ICommandLineParser;
import com.wily.util.commandline.ParsingException;
import com.wily.util.texthelp.IHelpProviderListSupplier;
import com.wily.util.texthelp.ISingleCommandHelpProvider;
import com.wily.util.texthelp.TextualHelpProvider;
import java.io.PrintWriter;

public class CommandLine {
    private final String[] fOriginalCommandLine;
    private int fNextIndex;
    private String fCurrentString;
    private ICommandLineParser[] fParsers;

    public CommandLine(String[] commandLineStrings) {
        this.fOriginalCommandLine = commandLineStrings;
        this.fParsers = new ICommandLineParser[0];
    }

    public final void setParsers(ICommandLineParser[] parsers) {
        this.fParsers = parsers;
    }

    public final String getCurrentCommand() {
        return this.fCurrentString;
    }

    public final String consumeNextCommand(String errorMessage) throws ParsingException {
        String fCurrentString = null;
        try {
            fCurrentString = this.fOriginalCommandLine[this.fNextIndex];
            ++this.fNextIndex;
        }
        catch (Throwable throwable) {
            this.throwParsingException(errorMessage);
        }
        return fCurrentString;
    }

    public final String consumeNextCommand() throws ParsingException {
        return this.consumeNextCommand("Command line could not be parsed.");
    }

    private final boolean unparsedCommandsRemain() {
        return this.fNextIndex < this.fOriginalCommandLine.length;
    }

    public void throwParsingException(String message) throws ParsingException {
        throw new ParsingException(message);
    }

    public void parse() throws ParsingException {
        while (this.unparsedCommandsRemain()) {
            this.parseNextCommand();
        }
    }

    private ICommandLineParser findMatchingParser(String command) throws ParsingException {
        int x = 0;
        while (x < this.fParsers.length) {
            if (this.fParsers[x].ICommandLineParser_matchesCommandString(command)) {
                return this.fParsers[x];
            }
            ++x;
        }
        throw new ParsingException("unexpected option: " + command);
    }

    private void parseNextCommand() throws ParsingException {
        String currentCommand = this.consumeNextCommand();
        ICommandLineParser parser = this.findMatchingParser(currentCommand);
        parser.ICommandLineParser_parseCommand(this, currentCommand);
    }

    public void iterateParserHelp(PrintWriter output) {
        TextualHelpProvider helpProvider = new TextualHelpProvider(new ParserHelpListSupplier());
        helpProvider.printHelp(output);
        output.flush();
    }

    private class ParserHelpListSupplier
    implements IHelpProviderListSupplier {
        private ParserHelpListSupplier() {
        }

        @Override
        public ISingleCommandHelpProvider[] ICommandListSupplier_getHelpProviders() {
            ISingleCommandHelpProvider[] result = new ISingleCommandHelpProvider[CommandLine.this.fParsers.length];
            System.arraycopy(CommandLine.this.fParsers, 0, result, 0, CommandLine.this.fParsers.length);
            return result;
        }
    }
}

