/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.properties.hot;

import com.wily.util.properties.IndexedProperties;
import com.wily.util.properties.hot.PropertyGroupChangeHelper;
import com.wily.util.properties.hot.PropertyGroupListner;
import java.util.HashSet;
import java.util.concurrent.CopyOnWriteArrayList;

public class BasicPropertyGroupChangeHelper
implements PropertyGroupChangeHelper {
    private IndexedProperties props;
    private final CopyOnWriteArrayList<PropertyGroupListner> listeners = new CopyOnWriteArrayList();

    public BasicPropertyGroupChangeHelper(IndexedProperties props) {
        this.props = props;
    }

    @Override
    public boolean registerListener(PropertyGroupListner listener) {
        return this.listeners.add(listener);
    }

    @Override
    public boolean removeListener(PropertyGroupListner listener) {
        return this.listeners.remove(listener);
    }

    private boolean hasChanged(PropertyGroupListner listener, IndexedProperties props1, IndexedProperties props2) {
        HashSet<String> allKeys = new HashSet<String>(props1.getAllKeys());
        allKeys.addAll(props2.getAllKeys());
        String keyGroupPrefix = listener.getKeyGroupPrefix();
        for (String key : allKeys) {
            if (key.indexOf(keyGroupPrefix) < 0) continue;
            String key1Value = props1.getTrimmedProperty(key);
            String key2Value = props2.getTrimmedProperty(key);
            if (!(key1Value != null ? key2Value == null || !key1Value.equals(key2Value) : key2Value != null)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onChange(IndexedProperties newProps) {
        for (PropertyGroupListner listener : this.listeners) {
            boolean hasChanged = this.hasChanged(listener, this.props, newProps);
            if (!hasChanged) continue;
            listener.onChange(newProps);
        }
        this.props = newProps;
    }
}

