/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.client.transport.http.tunneling;

import com.wily.isengard.postofficehub.link.http.client.HTTPNotRunningException;
import com.wily.isengard.postofficehub.link.http.client.IHttpTunnelingClient;
import com.wily.isengard.postofficehub.link.http.client.ProxyConfiguration;
import com.wily.util.Base64;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.io.NonSyncByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.NoOpLog;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;

public class ApacheHttpTunnelingClient
implements IHttpTunnelingClient {
    private static Module sModule = new Module("ApacheHttpTunnelingClient");
    private static final byte[] kEmptyArray = new byte[0];
    private static final String kTunnelingServiceContext = "/em/transport/services/IsengardHttpTunnelingService";
    private static final String kTunnelingIsengardServiceContext = "/em/transport/tunnel/";
    private static final String kContentType = "text/xml";
    private static final String kContentTypeIsengard = "application/isengard";
    private static final String kCharset = "UTF-8";
    private static final String kConnectSOAPRequest = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Body><ns1:connect soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:ns1=\"urn:isengard.wily.com\"/></soapenv:Body></soapenv:Envelope>";
    private static final String kDisconnectSOAPRequest = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Body><ns1:disconnect soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:ns1=\"urn:isengard.wily.com\"/></soapenv:Body></soapenv:Envelope>";
    private static final String kTransferSOAPRequestStart = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Body><ns1:transfer soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:ns1=\"urn:isengard.wily.com\"><in0 xsi:type=\"soapenc:base64Binary\" xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\">";
    private static final String kTransferSOAPRequestEnd = "</in0></ns1:transfer></soapenv:Body></soapenv:Envelope>";
    private static final String kEmptyTransferSOAPRequest = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Body><ns1:transfer soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:ns1=\"urn:isengard.wily.com\"><in0 xsi:type=\"soapenc:base64Binary\" xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\"></in0></ns1:transfer></soapenv:Body></soapenv:Envelope>";
    private static final String kTransferSOAPResponseStart = "<?xml version=\"1.0\" encoding=\"utf-8\"?><soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Body><ns1:transferResponse soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:ns1=\"urn:isengard.wily.com\"><transferReturn xsi:type=\"soapenc:base64Binary\" xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\">";
    private static final String kTransferSOAPResponseEnd = "</transferReturn></ns1:transferResponse></soapenv:Body></soapenv:Envelope>";
    private static final String kErrorSOAPResponseStart = "<?xml version=\"1.0\" encoding=\"utf-8\"?><soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Body><soapenv:Fault>";
    private static final String kErrorSOAPResponseEnd = "</soapenv:Fault></soapenv:Body></soapenv:Envelope>";
    private static byte[] sTransferSOAPRequestStartBytes;
    private static byte[] sTransferSOAPRequestEndBytes;
    private static byte[] sEmptyTransferSOAPRequestBytes;
    private static int sTransferSOAPResponseStartNumBytes;
    private static int sTransferSOAPResponseEndNumBytes;
    private HttpClient fHttpClient;
    private HttpClientConnectionManager fConnManager;
    private ProxyConfiguration fProxyConfig;
    private String fTunnelingServiceAddress;
    private HttpPost fMethod;
    private NonSyncByteArrayOutputStream fOutStream;
    private final String fHostName;
    private final int fPort;
    private final SSLContext fSSLContext;
    private final boolean fValidateHostname;
    private String[] fCipherSuites;
    private String[] fProtocols;
    private boolean fTryIPAddress;
    private IModuleFeedbackChannel fFeedback;
    private String fTunnelingIsengardServiceAddress;
    private HttpPost fMethodIsengard;
    private final int fSocketSendBufferSize;
    private final int fSocketRecieveBufferSize;

    public ApacheHttpTunnelingClient(String hostName, int port, int socketSendBufferSize, int socketRecieveBufferSize, SSLContext context, boolean validateHostname, String[] cipherSuites, String[] protocols, boolean tryIPAddress, IModuleFeedbackChannel feedback) {
        this.fHostName = hostName;
        this.fPort = port;
        this.fSSLContext = context;
        this.fValidateHostname = validateHostname;
        this.fCipherSuites = cipherSuites != null && cipherSuites.length > 0 ? cipherSuites : null;
        this.fProtocols = protocols != null && protocols.length > 0 ? protocols : null;
        this.fFeedback = feedback;
        this.fTryIPAddress = tryIPAddress;
        this.fSocketSendBufferSize = socketSendBufferSize;
        this.fSocketRecieveBufferSize = socketRecieveBufferSize;
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        String logFactoryPropStr = System.getProperty("org.apache.commons.logging.LogFactory");
        if (logFactoryPropStr != null) {
            System.clearProperty("org.apache.commons.logging.LogFactory");
        }
        Log log = LogFactory.getLog(this.getClass());
        if (logFactoryPropStr != null) {
            System.setProperty("org.apache.commons.logging.LogFactory", logFactoryPropStr);
        }
        if (!(log instanceof NoOpLog)) {
            this.fFeedback.warn(sModule, "Failed to initialize commons logger to NoOpLog");
        }
    }

    public void connect() throws HTTPNotRunningException {
        HTTPNotRunningException thrownException = null;
        try {
            this.connect2(this.fHostName);
            return;
        }
        catch (HTTPNotRunningException e) {
            thrownException = e;
            if (!this.fTryIPAddress) {
                throw thrownException;
            }
            InetAddress[] addresses = new InetAddress[]{};
            try {
                addresses = InetAddress.getAllByName(this.fHostName);
            }
            catch (UnknownHostException e2) {
                throw thrownException;
            }
            if (addresses.length > 0) {
                for (int i = 0; i < addresses.length; ++i) {
                    InetAddress address = addresses[i];
                    String ipAddress = address.getHostAddress();
                    try {
                        this.connect2(ipAddress);
                        return;
                    }
                    catch (HTTPNotRunningException e3) {
                        thrownException = e3;
                        continue;
                    }
                }
            }
            throw thrownException;
        }
    }

    private void connect2(String host) throws HTTPNotRunningException {
        block15: {
            host = this.determineAndFormatIPv6HostAddress(host);
            SSLConnectionSocketFactory socketFactory = null;
            if (this.fSSLContext == null) {
                this.fTunnelingServiceAddress = "http://" + host + ":" + this.fPort + kTunnelingServiceContext;
                this.fTunnelingIsengardServiceAddress = "http://" + host + ":" + this.fPort + kTunnelingIsengardServiceContext;
            } else {
                HostnameVerifier verifier = this.fValidateHostname ? SSLConnectionSocketFactory.getDefaultHostnameVerifier() : new NoopHostnameVerifier();
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                socketFactory = new SSLConnectionSocketFactory(this.fSSLContext, this.fProtocols, this.fCipherSuites, verifier);
                this.fTunnelingServiceAddress = "https://" + host + ":" + this.fPort + kTunnelingServiceContext;
                this.fTunnelingIsengardServiceAddress = "https://" + host + ":" + this.fPort + kTunnelingIsengardServiceContext;
            }
            boolean connected = false;
            this.fOutStream = new NonSyncByteArrayOutputStream();
            this.fConnManager = new BasicHttpClientConnectionManager();
            ArrayList<String> authPrefs = new ArrayList<String>(3);
            authPrefs.add("Basic");
            authPrefs.add("NTLM");
            authPrefs.add("Digest");
            try {
                SocketConfig socketConfig = SocketConfig.custom().setRcvBufSize(this.fSocketRecieveBufferSize).setSndBufSize(this.fSocketSendBufferSize).build();
                ConnectionConfig connConfig = ConnectionConfig.custom().setBufferSize(this.fSocketRecieveBufferSize).build();
                RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(30000).setSocketTimeout(30000).setTargetPreferredAuthSchemes(authPrefs).build();
                HttpHost proxyHost = null;
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                if (this.fProxyConfig != null) {
                    proxyHost = new HttpHost(this.fProxyConfig.getHostName(), this.fProxyConfig.getPort());
                    if (this.fProxyConfig.requiresAuthentication()) {
                        String realm = this.fProxyConfig.getRealm();
                        if (realm == null) {
                            realm = AuthScope.ANY_REALM;
                        }
                        Credentials creds = this.getProxyCredentials();
                        AuthScope scope = new AuthScope(proxyHost, realm, AuthScope.ANY_SCHEME);
                        credsProvider.setCredentials(scope, creds);
                    }
                }
                CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setDefaultSocketConfig(socketConfig).setSSLSocketFactory(socketFactory).setProxy(proxyHost).setDefaultCredentialsProvider(credsProvider).build();
                this.fHttpClient = httpClient;
                int statusBinary = this.connectBinary(httpClient);
                if (statusBinary == 200) {
                    connected = true;
                    this.fMethodIsengard = new HttpPost(this.fTunnelingIsengardServiceAddress + "transfer");
                    break block15;
                }
                if (statusBinary == 404) {
                    this.fMethod = new HttpPost(this.fTunnelingServiceAddress);
                    this.fMethod.setHeader("SOAPAction", "\"\"");
                    StringEntity entity = new StringEntity(kConnectSOAPRequest, kContentType, kCharset);
                    entity.setChunked(true);
                    this.fMethod.setEntity(entity);
                    HttpResponse response = httpClient.execute(this.fMethod);
                    if (response.getStatusLine().getStatusCode() != 200) {
                        String faultMsg = this.getFaultMessageAsString(response, kCharset);
                        throw new RemoteException("Error when connecting to tunneling server: " + faultMsg);
                    }
                    connected = true;
                    break block15;
                }
                throw new RemoteException("Error when connecting to tunneling server: status=" + statusBinary);
            }
            catch (Exception e) {
                throw new HTTPNotRunningException("The HTTP Tunneling server cannot be reached at: " + this.fTunnelingServiceAddress + ": " + e.getMessage(), (Throwable)e);
            }
            finally {
                if (this.fMethod != null) {
                    this.fMethod.releaseConnection();
                }
                if (!connected) {
                    this.closeHttpConnection();
                    this.fHttpClient = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int connectBinary(HttpClient httpClient) {
        int status = -1;
        for (int i = 0; i < 10; ++i) {
            HttpPost method = new HttpPost(this.fTunnelingIsengardServiceAddress + "connect");
            try {
                StringEntity entity = new StringEntity("", kContentTypeIsengard, kCharset);
                entity.setChunked(true);
                method.setEntity(entity);
                HttpResponse response = httpClient.execute(method);
                status = response.getStatusLine().getStatusCode();
                if (status == 404) {
                    int n = status;
                    return n;
                }
                if (status == 200) {
                    int n = status;
                    return n;
                }
                if (status != 503) {
                    int n = status;
                    return n;
                }
                Thread.sleep(5000L);
                continue;
            }
            catch (SSLHandshakeException handshake) {
                this.fFeedback.warn(sModule, "connectBinary failed to perform SSL handshake: " + handshake.getMessage());
                continue;
            }
            catch (Throwable t) {
                this.fFeedback.debug(sModule, "connectBinary caught exception: ", t);
                continue;
            }
            finally {
                method.releaseConnection();
            }
        }
        return status;
    }

    private String determineAndFormatIPv6HostAddress(String host) {
        try {
            InetAddress address = InetAddress.getByName(host);
            ClassLoader classLoader = address.getClass().getClassLoader();
            Class<?> inet6AddressCls = Class.forName("java.net.Inet6Address", true, classLoader);
            if (inet6AddressCls.isInstance(address) && (host = address.getHostName()).equals(address.getHostAddress())) {
                host = new StringBuffer("[").append(URLEncoder.encode(host, kCharset)).append("]").toString();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return host;
    }

    public void connect(ProxyConfiguration config) throws HTTPNotRunningException {
        this.fProxyConfig = config;
        this.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() throws IOException {
        if (this.fHttpClient != null) {
            if (this.fMethodIsengard != null) {
                try {
                    this.disconnectBinary();
                }
                catch (HttpException e) {
                    e.printStackTrace();
                }
                finally {
                    this.safeReleaseConnection(this.fMethodIsengard);
                    this.closeHttpConnection();
                }
            } else {
                try {
                    StringEntity requestEntity = new StringEntity(kDisconnectSOAPRequest, kContentType, kCharset);
                    requestEntity.setChunked(true);
                    this.fMethod.setEntity(requestEntity);
                    HttpResponse response = this.fHttpClient.execute(this.fMethod);
                    if (response.getStatusLine().getStatusCode() != 200) {
                        String faultMsg = this.getFaultMessageAsString(response, kCharset);
                        throw new RemoteException("Error when disconnecting from tunneling server: " + faultMsg);
                    }
                }
                finally {
                    this.safeReleaseConnection(this.fMethod);
                    this.closeHttpConnection();
                }
            }
        }
    }

    private void safeReleaseConnection(HttpPost postMethod) {
        if (postMethod == null) {
            return;
        }
        try {
            postMethod.releaseConnection();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectBinary() throws UnsupportedEncodingException, IOException, HttpException, RemoteException {
        HttpPost method = new HttpPost(this.fTunnelingIsengardServiceAddress + "disconnect");
        try {
            StringEntity entity = new StringEntity("", kContentTypeIsengard, kCharset);
            entity.setChunked(true);
            method.setEntity(entity);
            HttpResponse response = this.fHttpClient.execute(method);
            if (response.getStatusLine().getStatusCode() != 200) {
                String faultMsg = this.getResponseAsString(response, kCharset);
                throw new RemoteException("Error when disconnecting from tunneling server: " + faultMsg);
            }
            return;
        }
        finally {
            method.releaseConnection();
        }
    }

    public byte[] transfer(byte[] serverData) throws IOException {
        if (this.fMethodIsengard != null) {
            return this.transferUsingBinary(serverData);
        }
        return this.transferUsingWS(serverData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] transferUsingWS(byte[] serverData) throws IOException {
        byte[] result = kEmptyArray;
        if (this.fHttpClient != null) {
            try {
                byte[] requestBytes = this.getTransferRequest(serverData);
                ByteArrayEntity requestEntity = new ByteArrayEntity(requestBytes);
                requestEntity.setChunked(true);
                requestEntity.setContentType(kContentType);
                this.fMethod.setEntity(requestEntity);
                HttpResponse response = this.fHttpClient.execute(this.fMethod);
                if (response.getStatusLine().getStatusCode() != 200) {
                    String faultMsg = this.getFaultMessageAsString(response, kCharset);
                    throw new RemoteException("Error when transfering data to/from tunneling server: " + faultMsg);
                }
                byte[] responseBytes = this.getResponse(response);
                int transferedDataLength = responseBytes.length - sTransferSOAPResponseStartNumBytes - sTransferSOAPResponseEndNumBytes;
                if (transferedDataLength == 0) {
                    result = kEmptyArray;
                } else {
                    byte[] transferedData = new byte[transferedDataLength];
                    System.arraycopy(responseBytes, sTransferSOAPResponseStartNumBytes, transferedData, 0, transferedDataLength);
                    result = Base64.decode((byte[])transferedData);
                }
            }
            finally {
                this.fMethod.releaseConnection();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] transferUsingBinary(byte[] serverData) throws IOException {
        byte[] result = kEmptyArray;
        if (this.fHttpClient != null) {
            try {
                ByteArrayEntity requestEntity = new ByteArrayEntity(serverData);
                requestEntity.setContentType(kContentTypeIsengard);
                requestEntity.setChunked(true);
                this.fMethodIsengard.setEntity(requestEntity);
                HttpResponse response = this.fHttpClient.execute(this.fMethodIsengard);
                if (response.getStatusLine().getStatusCode() != 200) {
                    String faultMsg = this.getFaultMessageAsString(response, kCharset);
                    throw new RemoteException("Error when transfering data to/from tunneling server: " + faultMsg);
                }
                byte[] byArray = this.getResponse(response);
                return byArray;
            }
            finally {
                this.fMethodIsengard.releaseConnection();
            }
        }
        return result;
    }

    private Credentials getProxyCredentials() {
        Credentials creds;
        String username = this.fProxyConfig.getUserName();
        if (username.indexOf("\\") == -1) {
            creds = new UsernamePasswordCredentials(username, this.fProxyConfig.getPassword());
        } else {
            String[] domainUsername = username.split("\\\\");
            String hostname = "";
            try {
                InetAddress addr = InetAddress.getLocalHost();
                hostname = addr.getHostName();
                if (hostname != null) {
                    if (hostname.indexOf(".") != -1) {
                        int hostIndex = hostname.lastIndexOf(".");
                        hostname = hostname.substring(hostIndex);
                    }
                } else {
                    hostname = addr.getHostAddress();
                }
            }
            catch (UnknownHostException e) {
                hostname = "";
            }
            creds = new NTCredentials(domainUsername[1], this.fProxyConfig.getPassword(), hostname, domainUsername[0]);
            this.fFeedback.verbose(sModule, "NTLM Proxy Credentials: Domain: " + domainUsername[0] + ", Host:" + hostname + ", User Name: " + domainUsername[1]);
        }
        return creds;
    }

    private byte[] getTransferRequest(byte[] serverData) throws IOException {
        byte[] requestBytes = null;
        if (serverData.length > 0) {
            byte[] encodedData = Base64.encodeBytesToBytes((byte[])serverData);
            requestBytes = new byte[sTransferSOAPRequestStartBytes.length + encodedData.length + sTransferSOAPRequestEndBytes.length];
            System.arraycopy(sTransferSOAPRequestStartBytes, 0, requestBytes, 0, sTransferSOAPRequestStartBytes.length);
            System.arraycopy(encodedData, 0, requestBytes, sTransferSOAPRequestStartBytes.length, encodedData.length);
            System.arraycopy(sTransferSOAPRequestEndBytes, 0, requestBytes, sTransferSOAPRequestStartBytes.length + encodedData.length, sTransferSOAPRequestEndBytes.length);
        } else {
            requestBytes = sEmptyTransferSOAPRequestBytes;
        }
        return requestBytes;
    }

    private String getFaultMessageAsString(HttpResponse httpResponse, String charset) throws UnsupportedEncodingException, IOException, StringIndexOutOfBoundsException {
        String response = this.getResponseAsString(httpResponse, charset);
        try {
            return response.substring(kErrorSOAPResponseStart.length(), response.length() - kErrorSOAPResponseEnd.length());
        }
        catch (StringIndexOutOfBoundsException ex) {
            if (this.fFeedback.isDebugEnabled()) {
                this.fFeedback.debug(sModule, ex.getMessage() + ": " + response);
            }
            throw ex;
        }
    }

    private String getResponseAsString(HttpResponse httpResponse, String charset) throws IOException, UnsupportedEncodingException {
        return new String(this.getResponse(httpResponse), charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getResponse(HttpResponse httpResponse) throws IOException {
        InputStream inStream = httpResponse.getEntity().getContent();
        NonSyncByteArrayOutputStream outStream = this.fOutStream;
        byte[] responseBytes = null;
        try {
            byte[] buffer = new byte[4096];
            int len = 0;
            while ((len = inStream.read(buffer)) > 0) {
                outStream.write(buffer, 0, len);
            }
            responseBytes = outStream.toByteArray();
        }
        finally {
            outStream.reset();
        }
        return responseBytes;
    }

    private void closeHttpConnection() {
        this.fConnManager.closeIdleConnections(0L, TimeUnit.SECONDS);
    }

    static {
        try {
            sTransferSOAPRequestStartBytes = kTransferSOAPRequestStart.getBytes(kCharset);
            sTransferSOAPRequestEndBytes = kTransferSOAPRequestEnd.getBytes(kCharset);
            sEmptyTransferSOAPRequestBytes = kEmptyTransferSOAPRequest.getBytes(kCharset);
            sTransferSOAPResponseStartNumBytes = kTransferSOAPResponseStart.getBytes(kCharset).length;
            sTransferSOAPResponseEndNumBytes = kTransferSOAPResponseEnd.getBytes(kCharset).length;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Charset UTF-8 is not supported.");
        }
    }
}

