/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.frontend.jms;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ProbeInformation;
import com.wily.introscope.agent.trace.backend.jms.helper.JMSHelper;
import com.wily.introscope.agent.trace.backendprotocols.BackendProtocolsConstants;
import com.wily.introscope.agent.trace.cas.IBlameTransactionElement;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.frontend.jms.JMSReceiveFrontendTransactionElement;
import com.wily.introscope.agent.trace.frontend.jms.JMSReceiveSharedTracerHelper;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.trace.hc2.WilyTransactionElement;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;

public class JMSReceiveFrontendAggregator
extends BlamePointTracer
implements BackendProtocolsConstants {
    private static final Module ModuleName = new Module("JMSReceiveFrontendAggregator");
    private final JMSReceiveSharedTracerHelper helper;
    private final String START_TRACE_QUALIFIED = "frontend.jms.JMSReceiveFrontendAggregator";

    public JMSReceiveFrontendAggregator(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.helper = new JMSReceiveSharedTracerHelper(agent, parameters, probe, sampleTracedObject);
    }

    protected WilyTransactionElement constructTransactionElement(Object key, String componentName, int blameStatus, boolean isStartTrace, ITransactionElement parent, IBlameTransactionElement previous, IBlameTransactionElement start, ProbeInformation probeInformation) {
        return this.helper.constructTransactionElement(key, componentName, blameStatus, isStartTrace, parent, previous, start, probeInformation);
    }

    public void doOnEndTrace(int tracerIndex, IStackElement elementData, ITransactionElement element) {
        InvocationData invocationData = (InvocationData)elementData;
        if (invocationData.getInvocationReturnValueAsObject() == null) {
            JMSHelper.debug(ModuleName, "failed to call doOnEndTrace because the message received was seen as NULL");
            return;
        }
        WilyTransactionElement wte = (WilyTransactionElement)((WilyTransactionElement)element).getStartTraceBlamePoint();
        JMSReceiveSharedTracerHelper.JMSReceiveTxnCache cache = JMSReceiveSharedTracerHelper.getJMSReceiveTxnCache(invocationData);
        cache.aggregatedEstimatedTimeRepo = ((JMSReceiveFrontendTransactionElement)wte).getEstimatedTimeRepository();
        super.doOnEndTrace(tracerIndex, elementData, element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        if (JMSReceiveSharedTracerHelper.isParentAlreadyInstrumented(data) && JMSHelper.getConsumerDestinationInfoFromSession(data.getInvocationObject()) != null && JMSHelper.isStackEmpty(data)) {
            data.put("frontend.jms.JMSReceiveFrontendAggregator", (Object)Boolean.TRUE);
            try {
                super.ITracer_startTrace(tracerIndex, data);
            }
            finally {
                JMSReceiveSharedTracerHelper.JMSReceiveTxnCache jMSReceiveTxnCache = JMSReceiveSharedTracerHelper.getJMSReceiveTxnCache(data);
            }
        }
    }

    public void doOnStartTrace(int tracerIndex, IStackElement elementData, ITransactionElement element) {
        super.doOnStartTrace(tracerIndex, elementData, element);
        this.helper.updateTheCustomMetricInStartTrace(tracerIndex, elementData, element);
        JMSReceiveSharedTracerHelper.JMSReceiveTxnCache cache = JMSReceiveSharedTracerHelper.getJMSReceiveTxnCache((InvocationData)elementData);
        cache.lastReceiveTimeInThisThread = -1L;
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        Boolean wasStartTraceQualified = (Boolean)data.get("frontend.jms.JMSReceiveFrontendAggregator");
        if (wasStartTraceQualified != null && wasStartTraceQualified.booleanValue()) {
            super.ITracer_finishTrace(tracerIndex, data);
        }
    }

    public void offerNewTransactionInstanceElementOnStartTrace(int tracerIndex, IStackElement data, ITransactionElement newElement) {
    }

    public void offerNewTransactionInstanceElementOnEndTrace(int tracerIndex, IStackElement data, ITransactionElement newElement) {
    }
}

