/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.jmxclient.metrics;

import com.ca.apm.agent.jmxclient.metrics.ListenerFactoriesRepo;
import com.ca.apm.agent.jmxclient.metrics.MetricType;
import com.ca.apm.agent.jmxclient.metrics.MetricValueListener;
import com.ca.apm.agent.jmxclient.metrics.MetricValueTransformer;
import java.util.HashMap;
import java.util.Map;

public class MultiValueAdaptor<R, T>
implements MetricValueListener<R> {
    private Map<String, MetricValueListener<T>> metricListeners;
    private final MetricValueTransformer<R, T> transformer;
    private final String rootMetricName;

    public MultiValueAdaptor(MetricValueTransformer<R, T> transformer, String rootMetricName) {
        this.transformer = transformer;
        this.rootMetricName = rootMetricName;
        this.metricListeners = new HashMap<String, MetricValueListener<T>>();
    }

    @Override
    public void update(R value) {
        HashMap info = new HashMap();
        HashMap valueArray = (HashMap)this.transformer.transform(value, info);
        for (String key : valueArray.keySet()) {
            MetricValueListener<Object> delagate = this.metricListeners.get(key);
            if (delagate == null) {
                String[] parts = key.split(":");
                MetricType metricType = MetricType.valueOf(parts[0].toUpperCase());
                if (metricType == null) continue;
                String metricName = this.rootMetricName + "|" + parts[1] + ":" + parts[2];
                Object listener = null;
                if (MetricType.COUNTER == metricType) {
                    delagate = ListenerFactoriesRepo.FLUCTUATING_COUNTER_FACTORY.createMetricListener(metricName);
                } else if (MetricType.INTERVAL_COUNTER == metricType) {
                    delagate = ListenerFactoriesRepo.PER_INTERVAL_COUNTER_FACTORY.createMetricListener(metricName);
                } else if (MetricType.RATE == metricType) {
                    delagate = ListenerFactoriesRepo.RATE_FACTORY.createMetricListener(metricName);
                } else if (MetricType.STRING == metricType || MetricType.STRING_EVENT == metricType) {
                    delagate = ListenerFactoriesRepo.STRING_FACTORY.createMetricListener(metricName);
                }
                this.metricListeners.put(key, delagate);
            }
            delagate.update(valueArray.get(key));
        }
    }

    @Override
    public boolean validate(Object value) {
        return this.transformer.validate(value);
    }

    @Override
    public void close() {
        for (MetricValueListener<T> delagate : this.metricListeners.values()) {
            delagate.close();
        }
    }
}

