/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.urlgrouper;

import com.wily.util.urlgrouper.UrlGroup;
import com.wily.util.urlgrouper.UrlGrouper;
import com.wily.util.urlgrouper.UrlSucker;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Locale;

public class Main {
    public static void main(String[] args) throws Exception {
        if (args.length == 1 && args[0].toLowerCase(Locale.US).startsWith("-h")) {
            System.out.println("Usage: provide a log file name or no arguments to pipe log to stdin");
            return;
        }
        String fileName = "<stdin>";
        InputStreamReader r = new InputStreamReader(System.in);
        if (args.length > 0) {
            File file = new File(args[0]);
            fileName = file.getPath();
            if (!file.exists() || !file.canRead()) {
                System.out.println("Can't read file: " + args[0]);
                return;
            }
            r = new FileReader(file);
        }
        UrlSucker suck = new UrlSucker(r);
        ((Reader)r).close();
        UrlGrouper grouper = new UrlGrouper(suck.getAllUrlPaths());
        UrlGroup[] groups = grouper.getGroups();
        System.out.println("");
        System.out.println("# auto-configured URL groups from " + fileName);
        System.out.println("# put this in your IntroscopeAgent.profile to ");
        System.out.println("# configure URL groups for your applications");
        System.out.println("");
        System.out.println(Main.makeKeysProperty(groups));
        System.out.println("");
        int i = 0;
        while (i < groups.length) {
            System.out.println(groups[i].toString());
            ++i;
        }
    }

    private static String makeKeysProperty(UrlGroup[] groups) {
        String s = "introscope.agent.urlgroup.keys=";
        int i = 0;
        while (i < groups.length) {
            s = String.valueOf(s) + groups[i].getKey() + (i != groups.length - 1 ? "," : "");
            ++i;
        }
        return s;
    }
}

