/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.autoprobe.dynamic;

import com.wily.diagnos.cmp.methodmatcher.IMethodMatcher;
import java.lang.reflect.Method;

public class EqualsProxy {
    private Object delegate;
    private static final String kGetter = "get";
    private static final Object[] kEmptyObjArray = new Object[0];

    public EqualsProxy(Object delegate) {
        this.delegate = delegate;
    }

    public Object getDelegate() {
        return this.delegate;
    }

    public boolean equals(Object obj) {
        Object other = ((EqualsProxy)obj).getDelegate();
        if (!this.delegate.getClass().getName().equals(other.getClass().getName())) {
            return false;
        }
        Method[] myMethods = this.delegate.getClass().getMethods();
        for (int i = 0; i < myMethods.length; ++i) {
            Method myMethod = myMethods[i];
            if (!myMethod.getName().startsWith(kGetter)) continue;
            try {
                Method otherMethod = other.getClass().getMethod(myMethod.getName(), myMethod.getParameterTypes());
                Object myResult = myMethod.invoke(this.delegate, kEmptyObjArray);
                Object otherResult = otherMethod.invoke(other, kEmptyObjArray);
                if (!(myResult instanceof IMethodMatcher ? !this.isMethodMatcherEqual((IMethodMatcher)myResult, (IMethodMatcher)otherResult) : !myResult.equals(otherResult))) continue;
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private boolean isMethodMatcherEqual(IMethodMatcher myMethodMatcher, IMethodMatcher otherMethodMatcher) {
        return myMethodMatcher.getClass().getName().equals(otherMethodMatcher.getClass().getName());
    }
}

