/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.autoprobe.dynamic;

import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IMethodName;
import com.wily.util.classfile.IMethodSignature;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.IModeledMethod;
import com.wily.util.classfile.InvalidMethodDescriptorException;
import com.wily.util.classfile.InvalidMethodNameException;
import com.wily.util.classfile.java.MethodName;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class RuntimeMethod
implements IModeledMethod {
    private Method fMethodDelegate;
    private IModuleFeedbackChannel fFeedback;
    private IMethodName fMethodName;
    private IModeledClass fModeledClass;

    public RuntimeMethod(Method method, IModeledClass modeledClass, boolean initMethodName, IModuleFeedbackChannel feedback) throws InvalidMethodDescriptorException, InvalidMethodNameException {
        this.fMethodDelegate = method;
        this.fFeedback = feedback;
        this.fModeledClass = modeledClass;
        if (initMethodName) {
            this.fMethodName = MethodName.getMethodName((Method)this.fMethodDelegate, (boolean)true);
        }
    }

    public boolean containsAnnotation(IClassName annotationName) {
        Annotation[] annotations = this.fMethodDelegate.getAnnotations();
        for (int i = 0; i < annotations.length; ++i) {
            if (!annotations[i].annotationType().getName().equals(annotationName.getReflectionFriendlyQualifiedNameString())) continue;
            return true;
        }
        return false;
    }

    public IMethodName getMethodName() {
        return this.fMethodName;
    }

    public IModeledClass getModeledClass() {
        return this.fModeledClass;
    }

    public IMethodSignature getSignature() {
        throw new UnsupportedOperationException();
    }

    public boolean hasBytecode() {
        throw new UnsupportedOperationException();
    }

    public boolean isClassConstructor() {
        return false;
    }

    public boolean isComplex() {
        return true;
    }

    public boolean isComplex(boolean includeRestricted) {
        return true;
    }

    public boolean isEntryPoint() {
        throw new UnsupportedOperationException();
    }

    public boolean isInstanceConstructor() {
        return false;
    }

    public boolean isRemote() {
        return false;
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.fMethodDelegate.getModifiers());
    }
}

