/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.autoprobe.dynamic;

import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.InvalidClassNameException;
import com.wily.util.classfile.java.ClassName;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.List;

public class RuntimeModeledClass
implements IModeledClass {
    private final Class fRuntimeClass;
    private IModuleFeedbackChannel fFeedback;
    private IClassName fClassName;

    public RuntimeModeledClass(Class cls, boolean initClassName, IModuleFeedbackChannel feedback) throws InvalidClassNameException {
        this.fRuntimeClass = cls;
        this.fFeedback = feedback;
        if (initClassName) {
            this.fClassName = ClassName.getClassName((String)this.fRuntimeClass.getName());
        }
    }

    public Iterator getAllDeclaredMethods() {
        throw new UnsupportedOperationException();
    }

    public List<String> getAllImplementedInterfaceNames() {
        throw new UnsupportedOperationException();
    }

    public List<String> getAllDeclaredAnnotationNames() {
        throw new UnsupportedOperationException();
    }

    public boolean inheritsDirectlyFromInterface(IClassName interfaceName) {
        Class<?>[] intfs = this.fRuntimeClass.getInterfaces();
        for (int i = 0; i < intfs.length; ++i) {
            Class<?> intf = intfs[i];
            if (!intf.getName().equals(interfaceName.getReflectionFriendlyQualifiedNameString())) continue;
            return true;
        }
        return false;
    }

    public Iterator getAllMethods() {
        throw new UnsupportedOperationException();
    }

    public IClassName getClassName() {
        return this.fClassName;
    }

    public ClassLoader getClassLoader() {
        return this.fRuntimeClass.getClassLoader();
    }

    public IClassName getSuperClassName() {
        if (!this.hasSuperClass()) {
            return null;
        }
        try {
            return ClassName.getClassName((String)this.fRuntimeClass.getSuperclass().getName());
        }
        catch (InvalidClassNameException e) {
            this.fFeedback.debug((Throwable)e);
            return null;
        }
    }

    public boolean hasSuperClass() {
        return !this.fRuntimeClass.getSuperclass().equals(Object.class.getName());
    }

    public boolean isInterface() {
        return this.fRuntimeClass.isInterface();
    }

    public boolean isValueType() {
        return false;
    }

    public boolean containsAnnotation(IClassName annotationName) {
        try {
            Annotation[] annotations = this.fRuntimeClass.getDeclaredAnnotations();
            for (int i = 0; i < annotations.length; ++i) {
                if (!annotations[i].annotationType().getName().equals(annotationName.getReflectionFriendlyQualifiedNameString())) continue;
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public boolean referencesClass(IClassName referencedName) {
        throw new UnsupportedOperationException();
    }

    public boolean isInstanceOf(IClassName interfaceName) {
        try {
            Class<?> interfaceClass = Class.forName(interfaceName.getReflectionFriendlyQualifiedNameString(), false, this.fRuntimeClass.getClassLoader());
            return interfaceClass.isAssignableFrom(this.fRuntimeClass);
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (IllegalStateException e) {
            return false;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public void debugDump(PrintWriter log) {
    }
}

