/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.client.transport.websocket;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.service.IAgentService;
import com.wily.isengard.client.transport.websocket.TimedPipedInputStream;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import java.util.Map;

public class WebSocketTransportService
implements IAgentService {
    private IAgent fAgent;
    private static final Module kModule = new Module("WebSocketTransportService");
    private IModuleFeedbackChannel fFeedback;
    private static volatile TimedPipedInputStream timedPipedInputStream = null;
    private static IRegisteredBehavior readTimeoutBehavior = null;
    private ITimestampedRunnable readTimeoutChecker = new ITimestampedRunnable(){

        public void ITimestampedRunnable_execute(long nowInMillis) {
            if (timedPipedInputStream != null) {
                timedPipedInputStream.checkForTimout(nowInMillis);
            }
        }
    };

    public int IAgentService_getServiceVersion() {
        return 2;
    }

    public void IAgentService_startService(IAgent agent, Map params) throws Exception {
        this.fAgent = agent;
        this.fFeedback = agent.IAgent_getModuleFeedback();
        this.fFeedback.info(kModule, "WebSocket Transport Service starting");
        readTimeoutBehavior = agent.IAgent_getCommonHeartbeat().addBehavior(this.readTimeoutChecker, "Websocket Read Timout Check", timedPipedInputStream != null, 1000L, true);
    }

    public static void registerTimedPipedInputStream(TimedPipedInputStream stream) {
        if (stream != null) {
            timedPipedInputStream = stream;
            if (readTimeoutBehavior != null) {
                readTimeoutBehavior.IRegisteredBehavior_setEnableState(true);
            }
        } else {
            timedPipedInputStream = null;
            if (readTimeoutBehavior != null) {
                readTimeoutBehavior.IRegisteredBehavior_setEnableState(false);
            }
        }
    }
}

