/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.jmx;

import com.google.gson.JsonPrimitive;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.jmx.AJMXDataView;
import com.wily.introscope.agent.stat.AccumulatorAlreadyExistsException;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.ConflictingTypesException;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class IntJMXDataView
extends AJMXDataView {
    private IIntegerFluctuatingCounterDataAccumulator fAccumulator;
    private String fFullIntroscopeMetricName;
    private int fLastValue = 0;
    private int fCurrentValue = 0;
    private boolean fWasSame = false;

    public IntJMXDataView(IAgent agent, ObjectName on, MBeanServer server, String attributeName, String fullIntroscopeMetricName, Object attKey) {
        super(agent, on, server, attributeName, attKey);
        this.fFullIntroscopeMetricName = fullIntroscopeMetricName;
    }

    @Override
    protected void doUpdate(Object currentValue) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        int intValue;
        Number numberValue;
        if (currentValue instanceof Attribute) {
            Attribute att = (Attribute)currentValue;
            numberValue = (Number)att.getValue();
            int n = numberValue.intValue();
        }
        if (currentValue instanceof JsonPrimitive) {
            intValue = ((JsonPrimitive)currentValue).getAsInt();
        } else {
            numberValue = (Number)currentValue;
            intValue = numberValue.intValue();
        }
        IIntegerFluctuatingCounterDataAccumulator accumulator = this.getTypedAccumulator();
        if (accumulator != null) {
            this.fLastValue = this.fCurrentValue;
            this.fCurrentValue = intValue;
            boolean bl = this.fWasSame = this.fCurrentValue == this.fLastValue;
            if (this.fWasSame) {
                this.setSawSameValue();
            } else {
                this.resetSawSameValue();
            }
            accumulator.IIntegerCounterDataAccumulator_setValue(intValue);
        }
    }

    @Override
    protected IDataAccumulator getAccumulator(boolean forceCreate) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        if (forceCreate && this.fAccumulator == null) {
            this.fAccumulator = this.getAgent().IAgent_getDataAccumulatorFactory().createIntegerFluctuatingCounterDataAccumulator(this.fFullIntroscopeMetricName);
        }
        return this.fAccumulator;
    }

    private IIntegerFluctuatingCounterDataAccumulator getTypedAccumulator() throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        return (IIntegerFluctuatingCounterDataAccumulator)this.getAccumulator(true);
    }

    @Override
    protected void doDestroy() {
        try {
            if (this.fAccumulator != null) {
                this.getAgent().IAgent_getDataAccumulatorFactory().removeDataAccumulator((IDataAccumulator)this.fAccumulator);
            }
        }
        finally {
            this.fAccumulator = null;
            this.decrementJMXClampMetricCounter();
        }
    }

    @Override
    public String getFullMetricName() {
        return this.fFullIntroscopeMetricName;
    }
}

