/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.jmx;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.clamp.GenericClamp;
import com.wily.introscope.agent.jmx.IntroscopeProtocolAdaptor;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.properties.hot.PositiveIntegerConfigurationProperty;
import java.util.concurrent.atomic.AtomicInteger;

public class JMXClamp
extends GenericClamp {
    private Integer clampDefaultValue;
    private AtomicInteger jmxClamp = new AtomicInteger();
    private volatile PositiveIntegerConfigurationProperty jmxClampProperty;
    private static JMXClamp instance;
    private boolean isClampHit = false;
    private final String clampStatusMetric = "Agent Stats|Sustainability|JMX Clamp:Clamp Status";
    private IIntegerFluctuatingCounterDataAccumulator clampAccumulator;

    private JMXClamp(IAgent agent) {
        super(agent);
        this.clampDefaultValue = new Integer(500);
        this.clampAccumulator = agent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|JMX Clamp:Clamp Status");
        this.initializeClamp();
    }

    protected void initializeClamp() {
        try {
            this.jmxClamp.set(Integer.parseInt(this.agent.IAgent_getConfigurationManager().getProperty("introscope.agent.jmx.clamp")));
        }
        catch (NumberFormatException nfe) {
            this.jmxClamp.set(this.clampDefaultValue);
        }
        this.jmxClampProperty = new PositiveIntegerConfigurationProperty("introscope.agent.jmx.clamp", this.clampDefaultValue, "", this.agent.IAgent_getModuleFeedback(), this.module, this.agent.IAgent_getStringLocalizer()){

            public void set(Object value) {
                Integer temp = (Integer)value;
                JMXClamp.this.setClamp(temp);
            }
        };
        if (this.isClampValueValid(this.jmxClamp.get())) {
            this.jmxClamp.set(this.jmxClamp.get());
        } else {
            this.log("JMX clamp is set to an invalid value of 0 or less, retaining default value of " + this.clampDefaultValue, 'd');
            this.jmxClamp.set(this.clampDefaultValue);
        }
        this.agent.IAgent_getConfigurationManager().add((ConfigurationProperty)this.jmxClampProperty, true);
    }

    protected boolean isClampValueValid(int clamp) {
        return clamp > 0;
    }

    public boolean isClampHit() {
        boolean bl = this.isClampHit = this.metricCounter.get() >= this.jmxClamp.get();
        if (this.isClampHit) {
            this.updateSustainabilityMetric();
        }
        return this.isClampHit;
    }

    private void setClamp(int newClampValue) {
        this.jmxClamp.set(newClampValue);
        this.isClampHit = false;
        if (IntroscopeProtocolAdaptor.getInstance() != null) {
            IntroscopeProtocolAdaptor.getInstance().clearViewsMaps();
        }
        this.metricCounter.set(0);
        this.hasWarned = false;
        this.updateSustainabilityMetric();
        this.log("JMX clamp is set to a new value of " + newClampValue, 'd');
        this.log("JMX metrics are now unclamped", 'i');
    }

    public static JMXClamp getInstance(IAgent agent) {
        if (instance == null) {
            instance = new JMXClamp(agent);
        }
        return instance;
    }

    private void updateSustainabilityMetric() {
        if (this.isClampHit) {
            this.clampAccumulator.IIntegerCounterDataAccumulator_setValue(1);
        } else {
            this.clampAccumulator.IIntegerCounterDataAccumulator_setValue(0);
        }
    }

    public void printClampWarning() {
        if (!this.hasWarned) {
            this.log("JMX metric clamp has been hit, no additional JMX metrics will be reported", 'w');
            this.hasWarned = true;
        }
    }
}

