/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.jmx;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.jmx.AJMXDataView;
import com.wily.introscope.agent.jmx.DataViewFactory;
import com.wily.introscope.agent.jmx.MBeanInterpreter;
import com.wily.introscope.agent.stat.AccumulatorAlreadyExistsException;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.ConflictingTypesException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

final class MBeanInterpreterJMXDataView
extends AJMXDataView {
    private AJMXDataView[] values;
    private String introscopeMetricNameRoot;
    private MBeanInterpreter interpreter;
    private boolean fExcludeStringMetrics;
    private boolean fIncludeRateCounterMetrics;
    private static final String kExcludeStringMetricsPropKey = "introscope.agent.jmx.excludeStringMetrics";

    public MBeanInterpreterJMXDataView(IAgent agent, ObjectName objectName, MBeanServer server, String attributeName, String introscopeMetricNameRoot, MBeanInterpreter interpreter, boolean includeRateCounterMetrics, Object value) {
        super(agent, objectName, server, attributeName, value);
        this.introscopeMetricNameRoot = introscopeMetricNameRoot;
        this.interpreter = interpreter;
        this.fExcludeStringMetrics = agent.IAgent_getIndexedProperties().getBooleanProperty(kExcludeStringMetricsPropKey, true);
        this.fIncludeRateCounterMetrics = includeRateCounterMetrics;
    }

    @Override
    protected void doUpdate(Object currentValue) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        int valueII;
        boolean firstTime = this.values == null;
        MBeanInterpreter.MetricGroupDefinition[] rawValues = this.interpreter.retrieveValues(currentValue, firstTime);
        int totalMetricCount = 0;
        if (rawValues != null) {
            for (int II = 0; II < rawValues.length; ++II) {
                totalMetricCount += rawValues[II].values.length;
            }
        }
        if (firstTime && rawValues != null) {
            this.values = new AJMXDataView[totalMetricCount];
            valueII = -1;
            block5: for (int valueGroupII = 0; valueGroupII < rawValues.length; ++valueGroupII) {
                MBeanInterpreter.MetricGroupDefinition group = rawValues[valueGroupII];
                String groupMetricName = this.introscopeMetricNameRoot;
                for (int parentNameII = 0; parentNameII < group.metricPath.length; ++parentNameII) {
                    if (group.metricPath[parentNameII] == null) continue;
                    groupMetricName = groupMetricName + "|" + group.metricPath[parentNameII];
                }
                for (int leafII = 0; leafII < group.values.length; ++leafII) {
                    ++valueII;
                    String finalMetricName = groupMetricName + ":" + group.keys[leafII];
                    try {
                        AJMXDataView view = DataViewFactory.createView(this.getAgent(), this.getSourceObjectName(), group.values[leafII].getClass().getName(), group.keys[leafII], this.getSourceServer(), finalMetricName, this.fExcludeStringMetrics, this.fIncludeRateCounterMetrics);
                        this.getAgent().IAgent_getModuleFeedback().debug("Creating view with Final Metric Name ->" + finalMetricName);
                        this.values[valueII] = view;
                        this.getAgent().IAgent_getModuleFeedback().debug("Created view with Final Metric Name ->" + finalMetricName);
                        continue;
                    }
                    catch (BadlyFormedNameException except) {
                        this.getAgent().IAgent_getModuleFeedback().debug("Error registering view", (Throwable)except);
                        continue block5;
                    }
                    catch (ConflictingTypesException except) {
                        this.getAgent().IAgent_getModuleFeedback().debug("Error registering view", (Throwable)except);
                        continue block5;
                    }
                    catch (AccumulatorAlreadyExistsException except) {
                        this.getAgent().IAgent_getModuleFeedback().debug("Error registering view", (Throwable)except);
                        continue block5;
                    }
                }
            }
        }
        if (this.values != null) {
            valueII = -1;
            for (int groupII = 0; groupII < rawValues.length; ++groupII) {
                for (int leafII = 0; leafII < rawValues[groupII].values.length; ++leafII) {
                    if (this.values[++valueII] == null) continue;
                    this.values[valueII].doUpdate(rawValues[groupII].values[leafII]);
                }
            }
        }
    }

    @Override
    protected IDataAccumulator getAccumulator() {
        return null;
    }

    @Override
    protected IDataAccumulator getAccumulator(boolean forceCreate) {
        return null;
    }

    @Override
    protected void doDestroy() {
        if (this.values != null) {
            try {
                for (int valueII = 0; valueII < this.values.length; ++valueII) {
                    this.values[valueII].doDestroy();
                }
            }
            finally {
                this.values = null;
            }
        }
    }

    @Override
    protected boolean isVirtual() {
        return true;
    }

    @Override
    public String getFullMetricName() {
        return "Group " + this.introscopeMetricNameRoot;
    }
}

