/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.jmx;

import com.wily.introscope.agent.jmx.MBeanInterpreter;
import javax.management.j2ee.statistics.BoundaryStatistic;
import javax.management.j2ee.statistics.BoundedRangeStatistic;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.RangeStatistic;
import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.Stats;
import javax.management.j2ee.statistics.TimeStatistic;

class MBeanInterpreterJSR77
implements MBeanInterpreter {
    private static boolean jsr77Enabled = true;
    private static Boolean jsr77Available = null;
    private static final String[] keys_BoundaryStatistic = new String[]{"LowerBound", "UpperBound"};
    private static final String[] keys_BoundedRangeStatistic = new String[]{"LowerBound", "UpperBound", "Current", "HighWaterMark", "LowWaterMark"};
    private static final String[] keys_CountStatistic = new String[]{"Count"};
    private static final String[] keys_RangeStatistic = new String[]{"Current", "HighWaterMark", "LowWaterMark"};
    private static final String[] keys_TimeStatistic = new String[]{"Count", "MaxTime", "MinTime", "TotalTime"};

    MBeanInterpreterJSR77() {
    }

    @Override
    public boolean isQualified(String type) {
        return "javax.management.j2ee.statistics.Stats".equals(type);
    }

    @Override
    public MBeanInterpreter.MetricGroupDefinition[] retrieveValues(Object parentValue, boolean includeKeys) {
        if (parentValue != null && parentValue instanceof Stats) {
            String[] statisticNames = ((Stats)parentValue).getStatisticNames();
            MBeanInterpreter.MetricGroupDefinition[] groupList = new MBeanInterpreter.MetricGroupDefinition[statisticNames.length];
            String statsName = null;
            if (includeKeys) {
                statsName = parentValue.getClass().getName();
                if ((statsName = statsName.substring(statsName.lastIndexOf(".") + 1)).endsWith("Stats")) {
                    statsName = statsName.substring(0, statsName.length() - "Stats".length());
                }
            }
            for (int groupII = 0; groupII < groupList.length; ++groupII) {
                groupList[groupII] = new MBeanInterpreter.MetricGroupDefinition();
                Statistic statisticValue = ((Stats)parentValue).getStatistic(statisticNames[groupII]);
                if (includeKeys) {
                    groupList[groupII].metricPath = new String[]{statsName, statisticNames[groupII]};
                    groupList[groupII].keys = MBeanInterpreterJSR77.processStatisticKey(statisticValue);
                }
                groupList[groupII].values = MBeanInterpreterJSR77.processStatisticValue(statisticValue);
            }
            return groupList;
        }
        return null;
    }

    private static String[] processStatisticKey(Statistic S) {
        if (S instanceof BoundaryStatistic) {
            return keys_BoundaryStatistic;
        }
        if (S instanceof BoundedRangeStatistic) {
            return keys_BoundedRangeStatistic;
        }
        if (S instanceof CountStatistic) {
            return keys_CountStatistic;
        }
        if (S instanceof RangeStatistic) {
            return keys_RangeStatistic;
        }
        if (S instanceof TimeStatistic) {
            return keys_TimeStatistic;
        }
        return null;
    }

    private static Object[] processStatisticValue(Statistic S) {
        if (S instanceof BoundaryStatistic) {
            BoundaryStatistic statistic = (BoundaryStatistic)S;
            return new Long[]{statistic.getLowerBound(), statistic.getUpperBound()};
        }
        if (S instanceof BoundedRangeStatistic) {
            BoundedRangeStatistic statistic = (BoundedRangeStatistic)S;
            return new Long[]{statistic.getLowerBound(), statistic.getUpperBound(), statistic.getCurrent(), statistic.getHighWaterMark(), statistic.getLowWaterMark()};
        }
        if (S instanceof CountStatistic) {
            CountStatistic statistic = (CountStatistic)S;
            return new Long[]{statistic.getCount()};
        }
        if (S instanceof RangeStatistic) {
            RangeStatistic statistic = (RangeStatistic)S;
            return new Long[]{statistic.getCurrent(), statistic.getHighWaterMark(), statistic.getLowWaterMark()};
        }
        if (S instanceof TimeStatistic) {
            TimeStatistic statistic = (TimeStatistic)S;
            return new Long[]{statistic.getCount(), statistic.getMaxTime(), statistic.getMinTime(), statistic.getTotalTime()};
        }
        return null;
    }

    public static void setEnabled(boolean enabled) {
        jsr77Enabled = enabled;
    }

    @Override
    public boolean isAvailable() {
        return jsr77Enabled && MBeanInterpreterJSR77.isJsr77Available();
    }

    private static boolean isJsr77Available() {
        if (jsr77Available == null) {
            try {
                Class.forName("javax.management.j2ee.statistics.Statistic");
                jsr77Available = Boolean.TRUE;
            }
            catch (Exception except) {
                jsr77Available = Boolean.FALSE;
            }
        }
        return jsr77Available;
    }
}

