/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.etc;

import com.wily.introscope.etc.BannerPrinter;
import com.wily.introscope.install.IntroscopeVersion;
import com.wily.util.ArrayUtilities;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.SystemOutFeedbackChannel;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.text.MultipleResourceBundleStringLocalizer;
import com.wily.util.version.IVersion;
import java.io.PrintWriter;

public abstract class AIntroscopeVersionPrinter {
    private final String fLocalizedFullName;
    private final IVersion fVersion;
    private final BannerPrinter fBannerPrinter;

    protected AIntroscopeVersionPrinter(String[] extraResourceKeys, ClassLoader loader, String fullNameLocalizationKey, String shortNameLocalizationKey) {
        SystemOutFeedbackChannel feedback = AIntroscopeVersionPrinter.createApplicationFeedback();
        IStringLocalizer localizer = AIntroscopeVersionPrinter.createDefaultLocalizer((IModuleFeedbackChannel)feedback, extraResourceKeys, loader);
        this.fLocalizedFullName = localizer.IStringLocalizer_getLocalizedString(fullNameLocalizationKey);
        feedback.setModuleName(localizer.IStringLocalizer_getLocalizedString(shortNameLocalizationKey));
        this.fVersion = new IntroscopeVersion(localizer);
        this.fBannerPrinter = new BannerPrinter((IModuleFeedbackChannel)feedback, localizer);
    }

    public final void printBanner() {
        this.fBannerPrinter.printVersionBanner(this.fVersion, this.fLocalizedFullName);
        this.fBannerPrinter.printLegaleseBanner();
    }

    private static SystemOutFeedbackChannel createApplicationFeedback() {
        PrintWriter outputWrapper = new PrintWriter(System.out, true);
        PrintWriter errorWrapper = new PrintWriter(System.err, true);
        SystemOutFeedbackChannel feedback = new SystemOutFeedbackChannel("Version Printer");
        return feedback;
    }

    protected static IStringLocalizer createDefaultLocalizer(IModuleFeedbackChannel feedback, String[] extraResources, ClassLoader loader) {
        String[] allResourceBundleNames = (String[])ArrayUtilities.append((Object[])new String[]{"com.wily.properties.CoreCommonStrings", "com.wily.properties.CoreErrorMessages", "com.wily.introscope.properties.IntroscopeCommonStrings", "com.wily.introscope.properties.IntroscopeVersionStrings", "com.wily.introscope.properties.IntroscopeErrorMessages"}, (Object[])extraResources, String.class);
        return new MultipleResourceBundleStringLocalizer(feedback, loader, allResourceBundleNames);
    }
}

