/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.properties.hot;

import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.text.IStringLocalizer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class StringSetConfigurationProperty
extends ConfigurationProperty {
    public StringSetConfigurationProperty(String name, String descriptionKey, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer) {
        super(name, new HashSet(), descriptionKey, feedback, module, localizer);
    }

    public StringSetConfigurationProperty(String name, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer) {
        super(name, new HashSet(), feedback, module, localizer);
    }

    public StringSetConfigurationProperty(String name, Set defaultValue, String descriptionKey, String unitsKey, boolean isHot, boolean isNullValid, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer) {
        super(name, defaultValue, descriptionKey, unitsKey, isHot, isNullValid, feedback, module, localizer);
    }

    @Override
    public Set<String> convert(String s) {
        HashSet<String> convertedValue = new HashSet<String>();
        Set<String> rawValues = StringUtils.parseAndTrimListToSet(s, ",");
        for (String rawValue : rawValues) {
            String rv = rawValue.trim();
            convertedValue.add(rv);
        }
        return convertedValue;
    }

    @Override
    public String toString(Object v) {
        StringBuilder result = new StringBuilder();
        result.append('\"');
        if (v != null) {
            Iterator i = ((Set)v).iterator();
            String sep = "";
            while (i.hasNext()) {
                result.append(sep);
                sep = ",";
                result.append(i.next());
            }
        }
        result.append('\"');
        return result.toString();
    }
}

