/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agentmgr.agent;

import com.wily.introscope.agent.transactiontrace.ITransactionTraceListener;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.util.clock.MasterClock;
import com.wily.util.properties.lockable.IPropertyChangeEventNotifier;
import com.wily.util.text.IStringLocalizer;
import java.util.HashMap;

public class PropertyChangeEventSender
implements IPropertyChangeEventNotifier {
    private ITransactionTraceListener fListener;
    private IStringLocalizer fLocalizer;
    private String fAgentName;

    public PropertyChangeEventSender(String agentName, ITransactionTraceListener listener, IStringLocalizer localizer) {
        this.fAgentName = agentName;
        this.fListener = listener;
        this.fLocalizer = localizer;
    }

    public void sendPropertyChangeEvent(String propertyName, boolean success, long modificationTime, String newValue, String description) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Trace Type", "Property Change");
        params.put("AgentPropertyChangeEventAgentName", this.fAgentName);
        params.put("AgentPropertyChangeEventPropertyName", propertyName);
        params.put("AgentPropertyChangeEventSuccess", String.valueOf(success));
        params.put("AgentPropertyChangeEventNewValue", newValue);
        params.put("AgentPropertyChangeEventDescription", description);
        params.put("AgentPropertyChangeEventModificationTime", String.valueOf(modificationTime));
        TransactionComponentData event = TransactionComponentData.createMilliSecTransactionComponentData((String)propertyName, (long)modificationTime, (long)2000L, params);
        this.fListener.ITransactionTraceListener_reportTransaction(event);
    }

    public void sendSuccessfulPropertyChangeEvent(String propertyName, String newValue) {
        this.sendPropertyChangeEvent(propertyName, true, MasterClock.currentTimeMillis(), newValue, this.fLocalizer.IStringLocalizer_getLocalizedString("Property_Change_Event_Successful"));
    }

    public void sendFailedPropertyChangeEvent(String propertyName, String newValue) {
        this.sendPropertyChangeEvent(propertyName, false, MasterClock.currentTimeMillis(), newValue, this.fLocalizer.IStringLocalizer_getLocalizedString("Property_Change_event_Failed"));
    }

    public void sendFailedPropertyChangeEvent(String propertyName, String newValue, String description) {
        this.sendPropertyChangeEvent(propertyName, false, MasterClock.currentTimeMillis(), newValue, description);
    }
}

