/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.sqlparamagent;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.sqlparamagent.SQLAgentConfiguration;
import com.wily.util.adt.ConcurrentMapFactory;
import com.wily.util.adt.ConcurrentWeakIdentityHighPerformanceLRUHashMap;
import com.wily.util.adt.ICappedMap;
import com.wily.util.adt.IIdentityKey;
import com.wily.util.heartbeat.IntervalHeartbeat;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class BucketHolder {
    private static BucketHolder instance = null;
    private final SQLAgentConfiguration configuration;
    private final ConcurrentWeakIdentityHighPerformanceLRUHashMap<Object, Map<String, String>> paramBucket;
    private final ConcurrentWeakIdentityHighPerformanceLRUHashMap<Object, AtomicInteger> resultSetBucket;
    private volatile boolean preparedStatementCacheWarningLogged = false;
    private volatile boolean resultSetCacheWarningLogged = false;

    private ConcurrentWeakIdentityHighPerformanceLRUHashMap<Object, Map<String, String>> createParamBucket(SQLAgentConfiguration conf) {
        IAgent agent = conf.fAgent;
        String kMapName = "SQLParamBucket";
        ConcurrentMapFactory factory = (ConcurrentMapFactory)agent.IAgent_getConcurrentMapFactory();
        ConcurrentMapFactory.ConcurrentMapPolicy p = new ConcurrentMapFactory.ConcurrentMapPolicy("SQLParamBucket", ConcurrentMapFactory.ConcurrentMapType.CappedWeakIdentity, true, ConcurrentMapFactory.ThreadLocalOption.NoThreadLocal, 16, conf.getMaxPreparedStatements(), 0, 0.75f, 1000, 0);
        IntervalHeartbeat beat = agent.IAgent_getCommonHeartbeat();
        factory.addMapPolicy("SQLParamBucket", p, agent.IAgent_getModuleFeedback(), beat);
        ConcurrentWeakIdentityHighPerformanceLRUHashMap map = factory.getConcurrentCappedWeakIdentityHashMap("SQLParamBucket");
        map.setCallback((ICappedMap.IOnEntryRemovedListener)new ICappedMap.IOnEntryRemovedListener<IIdentityKey<Object>, Map<String, String>>(){

            public void onEntryRemoved(Map.Entry<IIdentityKey<Object>, Map<String, String>> entry) {
                if (!BucketHolder.this.preparedStatementCacheWarningLogged) {
                    ((BucketHolder)BucketHolder.this).configuration.fFeedback.warn(SQLAgentConfiguration.kModule, "Prepared statement cache max limit exceeded.");
                    BucketHolder.this.preparedStatementCacheWarningLogged = true;
                }
            }
        });
        return map;
    }

    private ConcurrentWeakIdentityHighPerformanceLRUHashMap<Object, AtomicInteger> createResultSetBucket(SQLAgentConfiguration conf) {
        IAgent agent = conf.fAgent;
        String kMapName = "SQLResultSetBucket";
        ConcurrentMapFactory factory = (ConcurrentMapFactory)agent.IAgent_getConcurrentMapFactory();
        ConcurrentMapFactory.ConcurrentMapPolicy p = new ConcurrentMapFactory.ConcurrentMapPolicy("SQLResultSetBucket", ConcurrentMapFactory.ConcurrentMapType.CappedWeakIdentity, true, ConcurrentMapFactory.ThreadLocalOption.NoThreadLocal, 16, conf.getMaxResultSets(), 0, 0.75f, 1000, 0);
        IntervalHeartbeat beat = agent.IAgent_getCommonHeartbeat();
        factory.addMapPolicy("SQLResultSetBucket", p, agent.IAgent_getModuleFeedback(), beat);
        ConcurrentWeakIdentityHighPerformanceLRUHashMap map = factory.getConcurrentCappedWeakIdentityHashMap("SQLResultSetBucket");
        map.setCallback((ICappedMap.IOnEntryRemovedListener)new ICappedMap.IOnEntryRemovedListener<IIdentityKey<Object>, AtomicInteger>(){

            public void onEntryRemoved(Map.Entry<IIdentityKey<Object>, AtomicInteger> entry) {
                if (!BucketHolder.this.resultSetCacheWarningLogged) {
                    ((BucketHolder)BucketHolder.this).configuration.fFeedback.warn(SQLAgentConfiguration.kModule, "Result set cache max limit exceeded.");
                    BucketHolder.this.resultSetCacheWarningLogged = true;
                }
            }
        });
        return map;
    }

    private BucketHolder(SQLAgentConfiguration conf) {
        this.configuration = conf;
        this.paramBucket = this.createParamBucket(conf);
        this.resultSetBucket = this.createResultSetBucket(conf);
    }

    public static final synchronized BucketHolder getInstance(SQLAgentConfiguration configuration) {
        if (instance == null) {
            instance = new BucketHolder(configuration);
        }
        return instance;
    }

    public void putParamListInBucket(Object key, Map<String, String> value) {
        this.paramBucket.putWeak(key, value);
    }

    public Map<String, String> getParamListFromBucket(Object key) {
        return (Map)this.paramBucket.getWeak(key);
    }

    public Map<String, String> getAndRemoveParamListFromBucket(Object key) {
        return (Map)this.paramBucket.removeWeak(key);
    }

    public void removeParamListFromBucket(Object key) {
        this.paramBucket.removeWeak(key);
    }

    public void removeFromResultSetBucket(Object tracedObject) {
        this.resultSetBucket.removeWeak(tracedObject);
    }

    public AtomicInteger getAndRemoveFromResultSetBucket(Object tracedObject) {
        return (AtomicInteger)this.resultSetBucket.removeWeak(tracedObject);
    }

    public AtomicInteger getFromResultSetBucket(Object invocationObject) {
        return (AtomicInteger)this.resultSetBucket.getWeak(invocationObject);
    }

    public void putInResultSetBucket(Object invocationObject, AtomicInteger rowCount) {
        this.resultSetBucket.putWeak(invocationObject, (Object)rowCount);
    }

    public int getSQLBucketCount() {
        return this.paramBucket.size();
    }

    public int getResultSetBucketCount() {
        return this.resultSetBucket.size();
    }
}

