/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.autoprobe.bootstrap;

import com.wily.diagnos.cmp.batch.IClassCompiler;
import com.wily.diagnos.cmp.classfile.DGClassException;
import com.wily.diagnos.personality.java.compiler.DGStreamSingleBootstrapClassCompiler;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.connection.IsengardServerConnectionManager;
import com.wily.introscope.agent.transformer.ClassFileTransformer;
import com.wily.introscope.agent.transformer.IllegalClassFormatException;
import com.wily.introscope.agent.transformer.dynamic.IBootstrapTransformer;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationTransformer;
import com.wily.introscope.autoprobe.ClassCompilerTransformerWrapper;
import com.wily.introscope.autoprobe.IAutoProbeConfig;
import com.wily.introscope.autoprobe.ICompilerLogger;
import com.wily.introscope.autoprobe.bootstrap.IBootstrapAutoProbeStringKeys;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.InvalidClassNameException;
import com.wily.util.classfile.java.ClassName;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.text.IStringLocalizer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;

public class BootstrapInstrumentationManager
implements IBootstrapAutoProbeStringKeys,
IBootstrapTransformer {
    private static final int kBootstrapTransformerOrder = 101;
    private static final String kBootstrapTransformer = "Bootstrap transformer";
    private static boolean fHasInitialized;
    private static Module fModule;
    private IModuleFeedbackChannel fLog;
    private IStringLocalizer fLocalizer;
    private final ClassFileTransformer fTransformer;
    private static final String kWaitStStartupKey = "introscope.bootstrapClassesManager.waitAtStartup";
    private static final String kEnabledKey = "introscope.bootstrapClassesManager.enabled";

    public BootstrapInstrumentationManager(final IAgent agent, final IDynamicInstrumentationTransformer transformer, final ICompilerLogger logger, final IAutoProbeConfig configRepository, Instrumentation instrumentation) {
        IRegisteredBehavior behavior;
        this.fLog = agent.IAgent_getModuleFeedback();
        this.fLocalizer = agent.IAgent_getStringLocalizer();
        boolean isEnabled = agent.IAgent_getIndexedProperties().safeGetBooleanProperty(kEnabledKey, false, agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer());
        if (!isEnabled) {
            this.fLog.info(fModule, this.fLocalizer.IStringLocalizer_getLocalizedString("Bootstrap_is_disabled"));
            this.fTransformer = null;
            return;
        }
        if (!(transformer instanceof ClassCompilerTransformerWrapper)) {
            this.fLog.warn(fModule, "Invalid_Transformer_Type");
            this.fTransformer = null;
            return;
        }
        ClassCompilerTransformerWrapper transformerBootstrap = (ClassCompilerTransformerWrapper)transformer;
        this.fTransformer = this.createTransformer(logger, configRepository, transformerBootstrap);
        this.fLog.info(fModule, this.fLocalizer.IStringLocalizer_getLocalizedString("Initializing_Bootstrap_Dynamic_Instrumentation"));
        WaitForConnectionRunnable target = new WaitForConnectionRunnable(){

            public void ITimestampedRunnable_execute(long nowInMillis) {
                IsengardServerConnectionManager manager = agent.IAgent_getIsengardServerConnection();
                if (manager != null && manager.getConnectedServer() != null && manager.getConnectedServer().isConnected() && transformer.getClassRedefinitionDelegate() != null) {
                    if (!fHasInitialized) {
                        BootstrapInstrumentationManager.this.executePostmainTransform(agent, transformer, logger, configRepository);
                        fHasInitialized = true;
                    }
                    if (fHasInitialized && this.behaviorHandle != null) {
                        this.behaviorHandle.close();
                    }
                }
            }
        };
        int waitInSeconds = agent.IAgent_getIndexedProperties().safeGetPositiveIntProperty(kWaitStStartupKey, 5, agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer());
        this.fLog.info(fModule, this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Bootstrap_Class_Instrumentation_Wait", "" + waitInSeconds));
        target.behaviorHandle = behavior = agent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)target, "Waiting for Bootstrap", true, 1000L, System.currentTimeMillis() + (long)(waitInSeconds * 1000));
    }

    private void registerClassFileTransformer(IAgent agent) {
        agent.IAgent_getTransformerAdministrator().registerTransformer(kBootstrapTransformer, 101, this.fTransformer);
    }

    private void unregisterClassFileTransformer(IAgent agent) {
        agent.IAgent_getTransformerAdministrator().unregisterTransformer(kBootstrapTransformer, 101, this.fTransformer);
    }

    private ClassFileTransformer createTransformer(final ICompilerLogger logger, final IAutoProbeConfig configRepository, final ClassCompilerTransformerWrapper transformerBootstrap) {
        return new ClassFileTransformer(){

            public byte[] transform(boolean classLoaderIsAvailable, ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
                return BootstrapInstrumentationManager.this.doTransform(className, loader, classBeingRedefined, protectionDomain, classfileBuffer, logger, configRepository, transformerBootstrap);
            }
        };
    }

    private List<IClassName> loadPostmainClasses(IAutoProbeConfig configRepository) {
        List classesToRedefine = configRepository.getCompilerSettings().getFilter().getInstrumentableBootstrapClassesPostmain();
        return this.loadClasses(classesToRedefine);
    }

    private List<IClassName> loadPremainClasses(IAutoProbeConfig configRepository) {
        List classesToRedefine = configRepository.getCompilerSettings().getFilter().getInstrumentableBootstrapClassesPremain();
        return this.loadClasses(classesToRedefine);
    }

    private List<IClassName> loadClasses(List<String> classesToRedefine) {
        ArrayList<IClassName> result = new ArrayList<IClassName>();
        if (classesToRedefine != null) {
            for (String fullyQualifiedName : classesToRedefine) {
                try {
                    ClassName className = ClassName.getClassName((String)fullyQualifiedName);
                    Class.forName(className.getReflectionFriendlyQualifiedNameString());
                    result.add((IClassName)className);
                }
                catch (ClassNotFoundException e) {
                    this.fLog.debug(fModule, this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Bootstrap_Class_Instrumentation_Name_Not_Valid", fullyQualifiedName));
                }
                catch (InvalidClassNameException e) {
                    this.fLog.debug(fModule, this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Bootstrap_Class_Instrumentation_Name_Not_Valid", fullyQualifiedName));
                }
                catch (UnsatisfiedLinkError e) {
                    this.fLog.debug(fModule, this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Bootstrap_Class_Not_Found", fullyQualifiedName));
                }
                catch (NoClassDefFoundError e) {
                    this.fLog.debug(fModule, this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Bootstrap_Class_Not_Found", fullyQualifiedName));
                }
                catch (Throwable e) {
                    this.fLog.debug(fModule, "Unspecified Error", e);
                }
            }
        }
        return result;
    }

    private byte[] doTransform(String className, ClassLoader loader, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer, final ICompilerLogger logger, final IAutoProbeConfig configurerer, ClassCompilerTransformerWrapper compilerWrapper) throws IllegalClassFormatException {
        byte[] result = null;
        if (className != null && configurerer.getCompilerSettings().getFilter().shouldInstrument(className)) {
            logger.getCompilerLog().ICompilerLog_logClassTraced(className);
            IClassCompiler compiler = new IClassCompiler(){

                public byte[] compileOneClass(String className, ClassLoader loader, byte[] classBytes, boolean isRedefine, Class<?> classRedefined) throws DGClassException, IOException {
                    ByteArrayInputStream input = new ByteArrayInputStream(classBytes);
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    DGStreamSingleBootstrapClassCompiler compiler = new DGStreamSingleBootstrapClassCompiler(configurerer.getCompilerSettings(), logger.getCompilerLog(), input, output, loader, classRedefined);
                    compiler.compileOneClass();
                    return output.toByteArray();
                }
            };
            result = compilerWrapper.transform(className, loader, classfileBuffer, compiler, true, classBeingRedefined);
        }
        return result;
    }

    private void reinstrumentLoadedClasses(List<IClassName> toBeInstrumented, IDynamicInstrumentationTransformer transformer, IAutoProbeConfig configRepository, ICompilerLogger logger) {
        this.fLog.info(fModule, this.fLocalizer.IStringLocalizer_getLocalizedString("Executing_Bootstrap_Classes_Dynamic_Instrumentation"));
        for (IClassName className : toBeInstrumented) {
            if (transformer.getClassRedefinitionDelegate().IClassRedefinitionDelegate_redefineTree(className)) continue;
            logger.getCompilerLog().ICompilerLog_logLastMutatedClass();
            this.fLog.warn(fModule, this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Class_Redefine_Failed", className.getReflectionFriendlyQualifiedNameString()));
        }
        this.fLog.info(fModule, this.fLocalizer.IStringLocalizer_getLocalizedString("Bootstrap_Classes_Instrumented"));
    }

    protected void executePostmainTransform(IAgent agent, IDynamicInstrumentationTransformer transformer, ICompilerLogger logger, IAutoProbeConfig configRepository) {
        List<IClassName> toBeInstrumented = this.loadPostmainClasses(configRepository);
        for (IClassName name : toBeInstrumented) {
            String reflectionFriendlyClassName = name.getReflectionFriendlyQualifiedNameString();
            try {
                Class.forName(reflectionFriendlyClassName);
            }
            catch (ClassNotFoundException e) {
                this.fLog.warn(fModule, this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Class_Redefine_Failed", name.getReflectionFriendlyQualifiedNameString()));
            }
        }
        this.reinstrumentLoadedClasses(toBeInstrumented, transformer, configRepository, logger);
        agent.IAgent_getModuleFeedback().info(fModule, this.fLocalizer.IStringLocalizer_getLocalizedString("Initialized_Bootstrap_Dynamic_Instrumentation"));
    }

    public void executePremainTransform(IAgent agent, IDynamicInstrumentationTransformer transformer) {
        boolean isEnabled = agent.IAgent_getIndexedProperties().safeGetBooleanProperty(kEnabledKey, false, agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer());
        if (!isEnabled) {
            this.fLog.info(fModule, this.fLocalizer.IStringLocalizer_getLocalizedString("Bootstrap_is_disabled"));
            return;
        }
        if (this.fTransformer == null) {
            this.fLog.warn(fModule, "Invalid_Transformer_Type");
            return;
        }
        IAutoProbeConfig configRepository = (IAutoProbeConfig)transformer;
        ICompilerLogger logger = (ICompilerLogger)transformer;
        List<IClassName> toBeInstrumented = this.loadPremainClasses(configRepository);
        this.registerClassFileTransformer(agent);
        this.reinstrumentLoadedClasses(toBeInstrumented, transformer, configRepository, logger);
        agent.IAgent_getModuleFeedback().info(fModule, this.fLocalizer.IStringLocalizer_getLocalizedString("Initialized_Bootstrap_Dynamic_Instrumentation_Premain"));
    }

    public void registerBootstrapTransformer(IAgent agent) {
        boolean isEnabled = agent.IAgent_getIndexedProperties().safeGetBooleanProperty(kEnabledKey, false, agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer());
        if (!isEnabled) {
            this.fLog.info(fModule, this.fLocalizer.IStringLocalizer_getLocalizedString("Bootstrap_is_disabled"));
            return;
        }
        if (this.fTransformer == null) {
            this.fLog.warn(fModule, "Invalid_Transformer_Type");
            return;
        }
        this.registerClassFileTransformer(agent);
    }

    static {
        fModule = new Module("BootstrapInstrumentationManager");
    }

    static abstract class WaitForConnectionRunnable
    implements ITimestampedRunnable {
        IRegisteredBehavior behaviorHandle;

        WaitForConnectionRunnable() {
        }
    }
}

