/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.upgrade.merge;

import com.wily.introscope.agent.upgrade.merge.IMergeable;
import com.wily.introscope.agent.upgrade.merge.IRulesEngine;
import com.wily.introscope.agent.upgrade.merge.MergeCustomMessageFormatter;
import com.wily.introscope.agent.upgrade.merge.diff.model.ConfigDiff;
import com.wily.introscope.agent.upgrade.merge.exceptions.MergeException;
import com.wily.introscope.agent.upgrade.merge.pbd.PBD;
import com.wily.introscope.agent.upgrade.merge.pbl.PBL;
import com.wily.introscope.agent.upgrade.merge.profile.Profile;
import com.wily.introscope.agent.upgrade.merge.profile.ProfileV2;
import com.wily.introscope.agent.upgrade.merge.util.KMergeConstants;
import com.wily.introscope.agent.upgrade.merge.util.UpgradeUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AMergeBase {
    private static Logger sLogger;
    private Path fWorkingDirectory;
    private ConfigDiff fMergeDiff;
    private String fTargetRelease;
    private List<File> fRollbackArtifacts;
    private HashMap<String, File> fBackedUpArtifacts;

    public AMergeBase(String className) {
        this.setupLogger(className);
    }

    private void setupLogger(String className) {
        sLogger = Logger.getLogger(className);
        MergeCustomMessageFormatter formatter = new MergeCustomMessageFormatter();
        FileHandler fileHandler = null;
        ConsoleHandler consoleHandler = null;
        try {
            fileHandler = new FileHandler("mergeutility.log");
            fileHandler.setFormatter(formatter);
            fileHandler.setLevel(Level.ALL);
            sLogger.addHandler(fileHandler);
            consoleHandler = new ConsoleHandler();
            consoleHandler.setFormatter(formatter);
            consoleHandler.setLevel(Level.ALL);
            sLogger.addHandler(consoleHandler);
            sLogger.setUseParentHandlers(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Logger getLogger() {
        return sLogger;
    }

    protected void setTargetRelease(String targetRelease) {
        this.fTargetRelease = targetRelease;
    }

    protected String getTargetRelease() {
        return this.fTargetRelease;
    }

    protected IMergeable readConfig(BufferedReader reader, String ext) throws IOException {
        IMergeable<Profile> config = null;
        if ("profile".equalsIgnoreCase(ext)) {
            config = Profile.read(reader);
        } else if ("pbl".equalsIgnoreCase(ext)) {
            config = PBL.read(reader);
        } else if ("pbd".equalsIgnoreCase(ext)) {
            config = PBD.read(reader);
        }
        return config;
    }

    protected boolean shouldMerge(String updateFile, String ext, IRulesEngine engine) {
        return "profile".equalsIgnoreCase(ext) && engine.isMerge(IRulesEngine.MergeableType.PROFILE, updateFile) || "pbl".equalsIgnoreCase(ext) && engine.isMerge(IRulesEngine.MergeableType.PBL, updateFile) || "pbd".equalsIgnoreCase(ext) && engine.isMerge(IRulesEngine.MergeableType.PBL, updateFile);
    }

    protected boolean shouldOverwrite(String updateFile, String ext, IRulesEngine engine) {
        return "profile".equalsIgnoreCase(ext) && engine.isOverwrite(IRulesEngine.MergeableType.PROFILE, updateFile) || "pbl".equalsIgnoreCase(ext) && engine.isOverwrite(IRulesEngine.MergeableType.PBL, updateFile) || "pbd".equalsIgnoreCase(ext) && engine.isOverwrite(IRulesEngine.MergeableType.PBD, updateFile);
    }

    protected Map<String, String> getConfigFiles(String dirPath) throws MergeException {
        HashMap<String, String> result = new HashMap<String, String>();
        File dir = new File(dirPath);
        if (!dir.exists()) {
            throw new MergeException(KMergeConstants.kNewline + "ERROR: The directory \"" + dirPath + "\" given as input doesn't exist.Please check the input.");
        }
        if (dir.isDirectory()) {
            File[] children;
            for (File child : children = this.searchConfig(dir, false)) {
                result.put(child.getName().toLowerCase(), child.getPath());
            }
        }
        return result;
    }

    protected Map<String, String> getConfigFiles(String dirPath, boolean takeBakup) throws MergeException {
        HashMap<String, String> result = new HashMap<String, String>();
        File dir = new File(dirPath);
        if (!dir.exists()) {
            throw new MergeException(KMergeConstants.kNewline + "ERROR: The directory \"" + dirPath + "\" given as input doesn't exist.Please check the input.");
        }
        if (dir.isDirectory()) {
            File[] children = this.searchProfiles(dir, false);
            try {
                for (File config : children) {
                    if (takeBakup) {
                        Path target = this.getWorkingDirectory().resolve("config");
                        Files.createDirectories(target, new FileAttribute[0]);
                        target = target.resolve(config.getName());
                        Files.deleteIfExists(target);
                        Files.copy(config.toPath(), target, new CopyOption[0]);
                        result.put(dir.getName() + "/" + config.getName().toLowerCase(), target.toString());
                        this.takeBackup("config", config);
                        this.getLogger().info("Loaded " + config.getName() + " from :" + target);
                        continue;
                    }
                    result.put(dir.getName() + "/" + config.getName().toLowerCase(), config.getPath());
                }
            }
            catch (IOException ex) {
                this.getLogger().log(Level.WARNING, "Error while reading configuration files: " + ex.getMessage());
                throw new MergeException("Error while reading configuration files: " + ex.getMessage());
            }
        }
        return result;
    }

    protected File[] searchConfig(File dir, final boolean lookProperties) {
        File[] children = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String ext;
                boolean retValue = false;
                if (pathname.isFile() && ("profile".equalsIgnoreCase(ext = UpgradeUtil.getFileExtension(pathname.getName())) || "pbl".equalsIgnoreCase(ext) || "pbd".equalsIgnoreCase(ext) || lookProperties && "properties".equalsIgnoreCase(ext))) {
                    retValue = true;
                }
                return retValue;
            }
        });
        return children;
    }

    protected File[] searchProfiles(File dir, final boolean lookProperties) {
        File[] children = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String ext;
                boolean retValue = false;
                if (pathname.isFile() && ("profile".equalsIgnoreCase(ext = UpgradeUtil.getFileExtension(pathname.getName())) || lookProperties && "properties".equalsIgnoreCase(ext))) {
                    retValue = true;
                }
                return retValue;
            }
        });
        return children;
    }

    protected File[] searchPBDs(File dir) {
        File[] children = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String ext;
                boolean retValue = false;
                if (pathname.isFile() && ("pbl".equalsIgnoreCase(ext = UpgradeUtil.getFileExtension(pathname.getName())) || "pbd".equalsIgnoreCase(ext))) {
                    retValue = true;
                }
                return retValue;
            }
        });
        return children;
    }

    protected int mergeInMemory(IRulesEngine engine, Map<String, String> updateFiles, Map<String, String> existingFiles, Map<String, String> trulyUpdated) throws MergeException {
        int mergeFileCount = 0;
        for (String updateFile : updateFiles.keySet()) {
            String msg;
            if (!existingFiles.containsKey(updateFile)) continue;
            String ext = UpgradeUtil.getFileExtension(updateFile);
            try {
                if (this.shouldOverwrite(updateFile, ext, engine)) {
                    BufferedReader overWriteReader = new BufferedReader(new FileReader(updateFiles.get(updateFile)));
                    IMergeable ovreWrittenConfig = this.readConfig(overWriteReader, ext);
                    this.write(ovreWrittenConfig, existingFiles.get(updateFile));
                    overWriteReader.close();
                    this.getLogger().info("Overwritten " + updateFile + " successfully.");
                    continue;
                }
                if (!this.shouldMerge(updateFile, ext, engine)) continue;
                this.getLogger().log(Level.ALL, "Attempting to merge " + existingFiles.get(updateFile) + " with " + updateFiles.get(updateFile));
                Profile profile = this.mergeProfileNoWrite(existingFiles.get(updateFile), updateFiles.get(updateFile), engine);
                profile.getProfileDiffObject().setFileKey(updateFile);
                if (!profile.getProfileDiffObject().getProfileMergeDiff().propertiesMerged.isEmpty()) {
                    trulyUpdated.put(updateFile, updateFiles.get(updateFile));
                    this.getMergeDiff().mergedFiles.add(profile.getProfileDiffObject().getProfileMergeDiff());
                    this.write(profile, updateFiles.get(updateFile));
                    this.getLogger().log(Level.ALL, "Merged file written in working directory at " + updateFiles.get(updateFile));
                    ++mergeFileCount;
                } else {
                    this.getLogger().log(Level.ALL, "No property differences found");
                }
                profile.clear();
            }
            catch (IOException e) {
                this.getLogger().log(Level.WARNING, "Could not merge: " + updateFile);
                msg = MessageFormat.format("Failed to merge {0} because {1}.", updateFile, "\n" + e.getMessage());
                throw new MergeException(msg);
            }
            catch (Exception ex) {
                this.getLogger().log(Level.WARNING, "Could not merge: " + updateFile);
                msg = MessageFormat.format("Failed to merge {0} because {1}.", updateFile, "\n" + ex.getMessage());
                throw new MergeException(msg);
            }
        }
        return mergeFileCount;
    }

    protected void copyFiles(Map<String, String> originalFiles, Map<String, String> trulyUpdated) throws IOException {
        for (String file : trulyUpdated.keySet()) {
            if (!originalFiles.containsKey(file)) continue;
            File toCopy = new File(trulyUpdated.get(file));
            File targetFile = new File(originalFiles.get(file));
            Files.move(toCopy.toPath(), targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            this.addRollbackArtifact(targetFile);
            this.getLogger().info("Copied file: " + toCopy.getName() + " , to path: " + targetFile);
        }
    }

    protected void write(IMergeable<?> config, String destination) throws IOException {
        try (FileWriter writer = new FileWriter(destination);
             BufferedWriter bufferedWriter = new BufferedWriter(writer);){
            config.write(bufferedWriter);
        }
    }

    protected Profile mergeProfileNoWrite(String oldInstallPath, String fUpdateFilePath, IRulesEngine engine) throws IOException {
        try (BufferedReader rightReader = new BufferedReader(new FileReader(fUpdateFilePath));){
            Profile profile;
            try (BufferedReader leftReader = new BufferedReader(new FileReader(oldInstallPath));){
                Profile updateConfig = Profile.read(rightReader);
                Profile customerConfig = Profile.read(leftReader);
                profile = customerConfig.merge(updateConfig, engine);
            }
            return profile;
        }
    }

    protected ProfileV2 mergeProfileV3(String oldInstallPath, String newInstallPath, IRulesEngine engine) throws IOException {
        try (BufferedReader newFileReader = new BufferedReader(new FileReader(newInstallPath));){
            ProfileV2 profileV2;
            try (BufferedReader oldFileReader = new BufferedReader(new FileReader(oldInstallPath));){
                ProfileV2 newFile = ProfileV2.read(newFileReader, true);
                ProfileV2 oldFile = ProfileV2.read(oldFileReader, false);
                profileV2 = newFile.merge(oldFile, engine);
            }
            return profileV2;
        }
    }

    @Deprecated
    public void mergePbd(String customerFilePath, String updateFilePath, IRulesEngine engine) throws IOException {
        PBD mergedConfig = null;
        BufferedReader rightReader = new BufferedReader(new FileReader(updateFilePath));
        PBD updateConfig = PBD.read(rightReader);
        rightReader.close();
        BufferedReader leftReader = new BufferedReader(new FileReader(customerFilePath));
        PBD customerConfig = PBD.read(leftReader);
        leftReader.close();
        mergedConfig = customerConfig.merge(updateConfig, engine);
        this.write(mergedConfig, customerFilePath);
    }

    @Deprecated
    private void mergePbl(String customerFilePath, String updateFilePath, IRulesEngine engine) throws IOException {
        PBL mergedConfig = null;
        BufferedReader rightReader = new BufferedReader(new FileReader(updateFilePath));
        PBL updateConfig = PBL.read(rightReader);
        rightReader.close();
        BufferedReader leftReader = new BufferedReader(new FileReader(customerFilePath));
        PBL customerConfig = PBL.read(leftReader);
        leftReader.close();
        mergedConfig = customerConfig.merge(updateConfig, engine);
        this.write(mergedConfig, customerFilePath);
    }

    protected ConfigDiff initializeMergeDiff(String fromRelease, String toRelease) {
        this.fMergeDiff = new ConfigDiff();
        this.fMergeDiff.id = UUID.randomUUID();
        this.fMergeDiff.timeStamp = System.currentTimeMillis();
        this.fMergeDiff.fromRelease = fromRelease;
        this.fMergeDiff.toRelease = toRelease;
        this.fMergeDiff.mergedFiles = new LinkedList();
        return this.fMergeDiff;
    }

    protected ConfigDiff getMergeDiff() {
        return this.fMergeDiff;
    }

    protected void resolveWorkingDirectory(String baseDir) throws IOException {
        if (baseDir.isEmpty()) {
            this.fWorkingDirectory = new File(System.getProperty("user.dir")).toPath();
        } else {
            File outputDir = new File(baseDir);
            this.fWorkingDirectory = outputDir.toPath().resolve(".acc");
            if (!Files.exists(this.fWorkingDirectory, new LinkOption[0])) {
                Files.createDirectory(this.fWorkingDirectory, new FileAttribute[0]);
            }
        }
    }

    protected Path getWorkingDirectory() {
        if (this.getTargetRelease().isEmpty()) {
            return this.fWorkingDirectory;
        }
        return this.fWorkingDirectory.resolve(this.getTargetRelease());
    }

    protected Path getLogLocation(Path workingDirectory) throws IOException {
        if (!Files.exists(workingDirectory.resolve("mergedoutput"), new LinkOption[0]) || !Files.isDirectory(workingDirectory.resolve("mergedoutput"), new LinkOption[0])) {
            return Files.createDirectory(workingDirectory.resolve("mergedoutput"), new FileAttribute[0]);
        }
        return workingDirectory.resolve("mergedoutput");
    }

    protected File takeBackup(String folderToPatch, File fileToBackup) throws IOException {
        File bkpFile = new File(this.getWorkingDirectory().resolve(folderToPatch).resolve(fileToBackup.getName()) + ".bkp");
        Files.deleteIfExists(bkpFile.toPath());
        Files.copy(fileToBackup.toPath(), bkpFile.toPath(), new CopyOption[0]);
        if (this.fBackedUpArtifacts == null) {
            this.fBackedUpArtifacts = new HashMap();
        }
        this.fBackedUpArtifacts.put(fileToBackup.toString(), bkpFile);
        return bkpFile;
    }

    protected void rollback() {
        this.getLogger().warning("Merge was unsuccessful.Rollback requested.");
        if (this.fRollbackArtifacts == null) {
            this.getLogger().warning("No artifacts found for rollback");
            return;
        }
        if (this.fBackedUpArtifacts == null) {
            this.getLogger().warning("Back up artifacts not found");
            return;
        }
        for (File artifact : this.fRollbackArtifacts) {
            if (!this.fBackedUpArtifacts.containsKey(artifact.toString())) continue;
            File originalFile = this.fBackedUpArtifacts.get(artifact.toString());
            try {
                Files.move(originalFile.toPath(), artifact.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.getLogger().warning("Reverted merge operation on file " + artifact);
            }
            catch (IOException e) {
                this.getLogger().warning("Error during rollback :" + e);
            }
        }
    }

    protected void addRollbackArtifact(File artifact) {
        if (this.fRollbackArtifacts == null) {
            this.fRollbackArtifacts = new ArrayList<File>();
        }
        this.fRollbackArtifacts.add(artifact);
    }

    protected List<File> getRollbackArtifacts() {
        return this.fRollbackArtifacts;
    }

    protected void cleanup() {
        try {
            final Path wd = this.getWorkingDirectory();
            Files.walkFileTree(this.getWorkingDirectory(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (!file.toString().contains("mergedoutput")) {
                        Files.delete(file);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (!"mergedoutput".equals(dir.toFile().getName()) && wd.compareTo(dir) != 0) {
                        Files.delete(dir);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            this.getLogger().severe("Error during cleanup. Error- " + e);
        }
    }
}

