/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.upgrade.merge.profile;

import com.wily.introscope.agent.upgrade.merge.IMergeable;
import com.wily.introscope.agent.upgrade.merge.IMetadataEntry;
import com.wily.introscope.agent.upgrade.merge.IRulesEngine;
import com.wily.introscope.agent.upgrade.merge.Line;
import com.wily.introscope.agent.upgrade.merge.diff.ProfileFileMergeDiff;
import com.wily.introscope.agent.upgrade.merge.profile.Key;
import com.wily.introscope.agent.upgrade.merge.profile.Value;
import com.wily.introscope.agent.upgrade.merge.util.KMergeConstants;
import com.wily.introscope.agent.upgrade.merge.util.UpgradeUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class Profile
implements IMergeable<Profile> {
    private List<Line> fHeader = new ArrayList<Line>();
    private Map<String, Key> fGroupMap = new HashMap<String, Key>();
    private Map<Key, List<Value>> fEntryMap = new LinkedHashMap<Key, List<Value>>();
    private Map<Key, List<Value>> fFinalMergedMap;
    private List<Key> fKeyOrderList = new LinkedList<Key>();
    private ProfileFileMergeDiff fProfileFileMergeDiff;

    public Profile() {
        this.fFinalMergedMap = new LinkedHashMap<Key, List<Value>>();
        this.fProfileFileMergeDiff = new ProfileFileMergeDiff();
    }

    public ProfileFileMergeDiff getProfileDiffObject() {
        return this.fProfileFileMergeDiff;
    }

    public List<Line> getHeader() {
        return Collections.unmodifiableList(this.fHeader);
    }

    public void setHeader(List<Line> header) {
        this.fHeader.clear();
        for (Line line : header) {
            this.fHeader.add(line);
        }
    }

    public void add(Key key, Value value) {
        this.fGroupMap.put(key.getGroup(), key);
        List<Object> values = null;
        if (!this.fEntryMap.containsKey(key)) {
            values = new ArrayList();
            this.fEntryMap.put(key, values);
        } else {
            values = this.fEntryMap.get(key);
        }
        values.add(value);
    }

    public Set<Key> getKeys() {
        return Collections.unmodifiableSet(this.fEntryMap.keySet());
    }

    public static Profile read(BufferedReader reader) throws IOException {
        Profile profile = new Profile();
        boolean header = false;
        ArrayList<Line> comments = new ArrayList<Line>();
        String line = null;
        int count = 0;
        while ((line = reader.readLine()) != null) {
            ++count;
            if (UpgradeUtil.isCompleteHashedLine(line)) {
                comments.add(new Line(line, count));
                continue;
            }
            if (UpgradeUtil.isBlank(line)) {
                comments.add(new Line("", count));
                continue;
            }
            if (line.trim().startsWith("#oldProperty: ")) continue;
            if (line.trim().startsWith("#")) {
                boolean success = Profile.isCommentedKey(profile, line, comments, count);
                if (success) {
                    comments.clear();
                    continue;
                }
                comments.add(new Line(line, count));
                continue;
            }
            Profile.handleKey(profile, line, comments, false, count);
            comments.clear();
        }
        return profile;
    }

    @Override
    public void write(Writer writer) throws IOException {
        writer.write(this.getProfile());
        writer.flush();
    }

    @Override
    public Profile merge(Profile otherProfile) {
        UUID keyId;
        Profile profile = new Profile();
        profile.setHeader(otherProfile.fHeader);
        HashSet<Key> commonKeys = new HashSet<Key>();
        this.fProfileFileMergeDiff.setFileKey("fileKey");
        for (Key key : this.fEntryMap.keySet()) {
            keyId = this.fProfileFileMergeDiff.generatePropertyId();
            if (otherProfile.fEntryMap.containsKey(key)) {
                commonKeys.add(key);
                List<Value> lvalues = this.fEntryMap.get(key);
                boolean uncommentedKeyFlag = false;
                for (Value value : lvalues) {
                    profile.add(key, value);
                    this.fProfileFileMergeDiff.setOldProperty(keyId, key.getKey(), value);
                    if (value.isCommented()) continue;
                    uncommentedKeyFlag = true;
                }
                List<Value> rvalues = otherProfile.fEntryMap.get(key);
                for (Value value3 : rvalues) {
                    if (lvalues.contains(value3)) continue;
                    if (!value3.isCommented() && uncommentedKeyFlag) {
                        profile.add(key, new Value(value3.getValue(), true, new ArrayList<Line>(), value3.getLineNumber()));
                        this.fProfileFileMergeDiff.setNewProperty(keyId, key.getKey(), value3);
                        continue;
                    }
                    profile.add(key, value3);
                    this.fProfileFileMergeDiff.setNewProperty(keyId, key.getKey(), value3);
                }
                continue;
            }
            List<Value> values = this.fEntryMap.get(key);
            for (Value value : values) {
                profile.add(key, value);
                this.fProfileFileMergeDiff.setOldProperty(keyId, key.getKey(), value);
            }
        }
        for (Key key : otherProfile.fEntryMap.keySet()) {
            keyId = this.fProfileFileMergeDiff.generatePropertyId();
            if (commonKeys.contains(key)) continue;
            int index = this.fKeyOrderList.indexOf(this.fGroupMap.get(key.getGroup()));
            if (index != -1) {
                this.fKeyOrderList.add(index + 1, key);
            } else {
                this.fKeyOrderList.add(key);
            }
            this.fGroupMap.put(key.getGroup(), key);
            List<Value> values = otherProfile.fEntryMap.get(key);
            for (Value value : values) {
                profile.add(key, value);
                this.fProfileFileMergeDiff.setNewProperty(keyId, key.getKey(), value);
            }
        }
        commonKeys.clear();
        for (Key key : this.fKeyOrderList) {
            this.fFinalMergedMap.put(key, profile.fEntryMap.get(key));
        }
        profile.fEntryMap = this.fFinalMergedMap;
        return profile;
    }

    @Override
    public Profile merge(Profile otherProfile, IRulesEngine engine) {
        Profile profile = new Profile();
        this.handleRenamedKeys(otherProfile, engine);
        LinkedHashMap<Key, List<Value>> finalMergedMap = new LinkedHashMap<Key, List<Value>>();
        LinkedList<Key> keyOrderList = new LinkedList<Key>();
        for (Key key : this.fEntryMap.keySet()) {
            keyOrderList.add(key);
        }
        HashSet<Key> commonKeys = new HashSet<Key>();
        for (Key key : this.fEntryMap.keySet()) {
            if (engine.isEntryDelete(IRulesEngine.MergeableType.PROFILE, key)) {
                keyOrderList.remove(key);
                continue;
            }
            if (otherProfile.fEntryMap.containsKey(key)) {
                commonKeys.add(key);
                IRulesEngine.PreferenceType type = engine.getPreferredType(IRulesEngine.MergeableType.PROFILE, key);
                if (type == IRulesEngine.PreferenceType.CURRENT) {
                    this.handleCommonKey(key, profile, this, otherProfile, true);
                    continue;
                }
                if (type != IRulesEngine.PreferenceType.UPGRADE) continue;
                this.handleCommonKey(key, profile, otherProfile, this, false);
                continue;
            }
            UUID keyId = profile.getProfileDiffObject().generatePropertyId();
            List<Value> values = this.fEntryMap.get(key);
            for (Value value : values) {
                profile.add(key, value);
                profile.getProfileDiffObject().setOldProperty(keyId, key.getKey(), value);
            }
        }
        this.handleNonCollidingKeys(commonKeys, profile, otherProfile, keyOrderList, engine);
        commonKeys.clear();
        for (Key key : keyOrderList) {
            finalMergedMap.put(key, profile.fEntryMap.get(key));
        }
        profile.fEntryMap = finalMergedMap;
        return profile;
    }

    private Value getMatchedValue(List<Value> values, Value value) {
        for (Value v : values) {
            if (!v.equals(value)) continue;
            return v;
        }
        return value;
    }

    /*
     * WARNING - void declaration
     */
    private void handleCommonKey(Key key, Profile profile, Profile preferredProfile, Profile otherProfile, boolean overwriteNewFileComments) {
        List<Value> lvalues = preferredProfile.fEntryMap.get(key);
        List<Value> rvalues = otherProfile.fEntryMap.get(key);
        boolean uncommentedKeyFlag = false;
        for (Value value : lvalues) {
            if (value != null && overwriteNewFileComments) {
                value = new Value(value.getValue(), value.isCommented(), this.getMatchedValue(rvalues, value).getComments(), value.getLineNumber());
            }
            profile.add(key, value);
            if (value.isCommented()) continue;
            uncommentedKeyFlag = true;
        }
        Key[] tempkeys = new Key[rvalues.size()];
        Value[] tempValues = new Value[rvalues.size()];
        boolean shouldPropertyAddToMergeDiff = false;
        int counter = 0;
        for (Value value : rvalues) {
            if (lvalues.contains(value)) continue;
            if (!value.isCommented() && uncommentedKeyFlag) {
                Value v = new Value(value.getValue(), true, new ArrayList<Line>(), value.getLineNumber(), true);
                profile.add(key, v);
                tempkeys[counter] = key;
                tempValues[counter] = v;
                shouldPropertyAddToMergeDiff = true;
            } else {
                profile.add(key, value);
                tempkeys[counter] = key;
                tempValues[counter] = value;
                shouldPropertyAddToMergeDiff = true;
            }
            ++counter;
        }
        if (shouldPropertyAddToMergeDiff) {
            void var14_17;
            UUID keyId = profile.getProfileDiffObject().generatePropertyId();
            for (Value val : lvalues) {
                profile.getProfileDiffObject().setOldProperty(keyId, key.getKey(), val);
            }
            boolean bl = false;
            while (var14_17 < tempkeys.length) {
                if (tempkeys[var14_17] != null) {
                    profile.getProfileDiffObject().setNewProperty(keyId, tempkeys[var14_17].getKey(), tempValues[var14_17]);
                }
                ++var14_17;
            }
        }
    }

    private void handleNonCollidingKeys(Set<Key> commonKeys, Profile profile, Profile otherProfile, List<Key> keyOrderList, IRulesEngine engine) {
        for (Key key : otherProfile.fEntryMap.keySet()) {
            if (commonKeys.contains(key)) continue;
            int index = keyOrderList.indexOf(this.fGroupMap.get(key.getGroup()));
            if (index != -1) {
                keyOrderList.add(index + 1, key);
            } else {
                keyOrderList.add(key);
            }
            this.fGroupMap.put(key.getGroup(), key);
            List<Value> values = otherProfile.fEntryMap.get(key);
            for (Value value : values) {
                profile.add(key, value);
                if (engine.isEntryDelete(IRulesEngine.MergeableType.PROFILE, key)) continue;
                UUID keyId = profile.getProfileDiffObject().generatePropertyId();
                profile.getProfileDiffObject().setNewProperty(keyId, key.getKey(), value);
            }
        }
        commonKeys.clear();
    }

    public void clear() {
        this.fGroupMap.clear();
        for (List<Value> values : this.fEntryMap.values()) {
            values.clear();
        }
        this.fEntryMap.clear();
        this.fFinalMergedMap.clear();
        this.fKeyOrderList.clear();
        this.fHeader.clear();
    }

    private static boolean isCommentedKey(Profile profile, String line, List<Line> comments, int lineNumber) {
        boolean success = false;
        if (line.trim().startsWith("#")) {
            String[] tokens;
            line = line.trim();
            String modLine = "";
            for (int i = 0; i < line.length(); ++i) {
                if (line.charAt(i) == '#') continue;
                modLine = line.substring(i);
                break;
            }
            if (((tokens = (modLine = modLine.trim()).trim().split("=", 2)).length == 2 || modLine.endsWith("=")) && Profile.isValidKey(tokens[0])) {
                success = Profile.handleKey(profile, modLine, comments, true, lineNumber);
            }
        }
        return success;
    }

    private static boolean isValidKey(String key) {
        return key != null && !key.isEmpty();
    }

    private static boolean handleKey(Profile profile, String line, List<Line> comments, boolean commented, int lineNumber) {
        boolean success = false;
        String[] tokens = line.trim().split("=", 2);
        if (line.trim().endsWith("=") && tokens.length == 1) {
            Key key = new Key(tokens[0]);
            Value value = new Value("", commented, comments, lineNumber);
            profile.add(key, value);
            success = true;
        } else if (tokens.length == 2) {
            Key key = new Key(tokens[0]);
            Value value = new Value(tokens[1], commented, comments, lineNumber);
            profile.add(key, value);
            success = true;
        }
        return success;
    }

    public String toString() {
        StringBuilder strBldr = new StringBuilder("Class: Profile\n");
        strBldr.append(this.getProfile());
        return strBldr.toString();
    }

    private String getProfile() {
        StringBuilder strBldr = new StringBuilder();
        String newLine = KMergeConstants.kNewline;
        for (Line line : this.fHeader) {
            strBldr.append(line).append(newLine);
        }
        for (Key key : this.fEntryMap.keySet()) {
            List<Value> values = this.fEntryMap.get(key);
            if (values.isEmpty()) continue;
            for (Value value : values) {
                List<Line> lines = value.getComments();
                for (Line line : lines) {
                    strBldr.append(line.getContent()).append(newLine);
                }
                if (value.isCommented()) {
                    strBldr.append("#");
                }
                if (value.isOldValue()) {
                    strBldr.append("oldProperty: ");
                    strBldr.append(key.getKey() + "=" + value.getValue()).append(newLine);
                    continue;
                }
                strBldr.append(key.getKey() + "=" + value.getValue()).append(newLine);
            }
        }
        return strBldr.toString();
    }

    private void handleRenamedKeys(Profile otherProfile, IRulesEngine engine) {
        Set<IMetadataEntry> renamedKeys = engine.getAllRenamedEntries(IRulesEngine.MergeableType.PROFILE);
        if (renamedKeys != null && !renamedKeys.isEmpty()) {
            for (IMetadataEntry key : renamedKeys) {
                List<Value> toPushAgain;
                Key renamedKey;
                if (this.fEntryMap.containsKey(key)) {
                    renamedKey = engine.getRenamedEntry(IRulesEngine.MergeableType.PROFILE, key);
                    toPushAgain = this.fEntryMap.get(key);
                    this.fEntryMap.remove(key);
                    this.fEntryMap.put(renamedKey, toPushAgain);
                }
                if (!otherProfile.fEntryMap.containsKey(key)) continue;
                renamedKey = engine.getRenamedEntry(IRulesEngine.MergeableType.PROFILE, key);
                toPushAgain = otherProfile.fEntryMap.get(key);
                otherProfile.fEntryMap.remove(key);
                otherProfile.fEntryMap.put(renamedKey, toPushAgain);
            }
        }
    }
}

