/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.apmservices.client.sustainability;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.stat.ICumulativeCounterDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerAverageDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.stat.ILongAverageDataAccumulator;
import com.wily.introscope.agent.stat.ILongFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.stat.IStringEveryEventDataAccumulator;

public class SustainabilityMetricReporter {
    private static DataAccumulatorFactory dataAccumulatorFactory = null;

    private SustainabilityMetricReporter() {
    }

    private static synchronized void initDataAccumulatorFactory() {
        if (dataAccumulatorFactory == null) {
            try {
                IAgent agent = AgentShim.getAgent();
                dataAccumulatorFactory = agent.IAgent_getDataAccumulatorFactory();
            }
            catch (AgentNotAvailableException agentNotAvailableException) {
                // empty catch block
            }
        }
    }

    public static void reportCumulativeCounter(String metric, int value) {
        if (null == dataAccumulatorFactory) {
            SustainabilityMetricReporter.initDataAccumulatorFactory();
        }
        ICumulativeCounterDataAccumulator dataAcc = dataAccumulatorFactory.safeGetCumulativeCounterDataAccumulator(metric);
        dataAcc.ILongCounterDataAccumulator_addOnlyDelta((long)value);
    }

    public static void reportIntAverage(String metric, int value) {
        if (null == dataAccumulatorFactory) {
            SustainabilityMetricReporter.initDataAccumulatorFactory();
        }
        IIntegerAverageDataAccumulator dataAcc = dataAccumulatorFactory.safeGetIntegerAverageDataAccumulator(metric);
        dataAcc.IIntegerAggregatingDataAccumulator_recordDataPoint(value);
    }

    public static final void reportIntCounter(String metric, int value) {
        if (null == dataAccumulatorFactory) {
            SustainabilityMetricReporter.initDataAccumulatorFactory();
        }
        IIntegerFluctuatingCounterDataAccumulator dataAcc = dataAccumulatorFactory.safeGetIntegerFluctuatingCounterDataAccumulator(metric);
        dataAcc.IIntegerCounterDataAccumulator_setValue(value);
    }

    public static void reportLongAverage(String metric, long value) {
        if (null == dataAccumulatorFactory) {
            SustainabilityMetricReporter.initDataAccumulatorFactory();
        }
        ILongAverageDataAccumulator dataAcc = dataAccumulatorFactory.safeGetLongAverageDataAccumulator(metric);
        dataAcc.ILongAggregatingDataAccumulator_recordDataPoint(value);
    }

    public static final void reportLongCounter(String metric, long value) {
        if (null == dataAccumulatorFactory) {
            SustainabilityMetricReporter.initDataAccumulatorFactory();
        }
        ILongFluctuatingCounterDataAccumulator dataAcc = dataAccumulatorFactory.safeGetLongFluctuatingCounterDataAccumulator(metric);
        dataAcc.ILongCounterDataAccumulator_setValue(value);
    }

    public static final void reportPerIntervalCounter(String metric, long value) {
        if (null == dataAccumulatorFactory) {
            SustainabilityMetricReporter.initDataAccumulatorFactory();
        }
        ILongIntervalCounterDataAccumulator dataAcc = dataAccumulatorFactory.safeGetLongIntervalCounterDataAccumulator(metric);
        dataAcc.ILongIntervalCounterDataAccumulator_addBatchIncidents(value);
    }

    public static final void reportStringEvent(String metric, String value) {
        if (null == dataAccumulatorFactory) {
            SustainabilityMetricReporter.initDataAccumulatorFactory();
        }
        IStringEveryEventDataAccumulator dataAcc = dataAccumulatorFactory.safeGetStringEveryEventDataAccumulator(metric);
        dataAcc.IStringEveryEventDataAccumulator_addString(value);
    }
}

