/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.feedback.backend.logback;

import ch.qos.logback.core.PropertyDefinerBase;
import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.connection.IsengardServerConnectionManager;
import com.wily.introscope.agent.feedback.backend.logback.LogbackBackend;
import com.wily.util.INameChangeListener;
import com.wily.util.StringUtils;
import com.wily.util.heartbeat.WaitAndExecuteBehavior;
import com.wily.util.properties.IndexedProperties;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Properties;

public class AgentNamePropertyDefiner
extends PropertyDefinerBase {
    private static final int kSendEnvironmentCycleTime = 30000;
    private static IAgent agent;
    private static String agentName;
    private static WaitAndExecuteBehavior nameChangeBehavior;
    private final boolean isLogAutonamingEnabled;
    private static final String kTimestampFormatString = "yyyyMMdd-HHmmss";
    private static final SimpleDateFormat kTimestampFormat;
    static final INameChangeListener listener;

    public AgentNamePropertyDefiner() {
        agent = this.getAgent();
        if (agent != null) {
            this.isLogAutonamingEnabled = agent.IAgent_isLogFileAutoNamingEnabled();
            if (this.isLogAutonamingEnabled) {
                IsengardServerConnectionManager serverConnection = agent.IAgent_getIsengardServerConnection();
                if (serverConnection != null) {
                    agentName = serverConnection.getActualAgentName();
                }
                if (nameChangeBehavior == null) {
                    nameChangeBehavior = new WaitAndExecuteBehavior(agent.IAgent_getCommonHeartbeat(), 30000L, "Check Connection for setup Agent log negotiated name listener"){

                        protected boolean execute() {
                            IsengardServerConnectionManager m = agent.IAgent_getIsengardServerConnection();
                            if (m != null && m.getConnectedServer() != null && m.getConnectedServer().isConnected()) {
                                agent.IAgent_addNameChangeListener(listener);
                                agent.IAgent_addNegotiatedNameChangeListener(listener);
                                return true;
                            }
                            return false;
                        }
                    };
                }
                if (agentName == null) {
                    String timestamp;
                    Calendar rightNow = Calendar.getInstance();
                    agentName = timestamp = kTimestampFormat.format(rightNow.getTime());
                }
            }
        } else {
            this.isLogAutonamingEnabled = false;
        }
    }

    private IAgent getAgent() {
        try {
            return AgentShim.getAgent();
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
            return null;
        }
    }

    @Override
    public String getPropertyValue() {
        if (!this.isLogAutonamingEnabled) {
            return "";
        }
        if (!StringUtils.isEmpty((String)agentName)) {
            String safeAgentName = StringUtils.replaceNonAlphaNumericCharacters((String)agentName, (char)'_');
            return "." + safeAgentName;
        }
        return "";
    }

    static {
        agentName = null;
        nameChangeBehavior = null;
        kTimestampFormat = new SimpleDateFormat(kTimestampFormatString);
        listener = new INameChangeListener(){

            public void INameChangeListener_nameChanged(String newName) {
                if (!newName.equals(agentName)) {
                    agentName = newName;
                    IndexedProperties props = agent.IAgent_getIndexedProperties();
                    LogbackBackend.getInstance().reloadLoggerConfiguration((Properties)props);
                }
            }
        };
    }
}

