/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.feedback.backend.logback;

import ch.qos.logback.classic.Level;
import com.wily.util.feedback.SeverityLevel;
import com.wily.wilyassert.Assertion;
import java.util.Locale;

public class LogbackSeverityLevel {
    public static final int OFF_INT = Level.OFF_INTEGER;
    public static final int FATAL_INT = Level.ERROR_INTEGER + 10000;
    public static final int ERROR_INT = Level.ERROR_INTEGER;
    public static final int WARN_INT = Level.WARN_INTEGER;
    public static final int INFO_INT = Level.INFO_INTEGER;
    public static final int VERBOSE_INT = Level.INFO_INTEGER - 5000;
    public static final int DEBUG_INT = Level.DEBUG_INTEGER;
    public static final int TRACE_INT = Level.TRACE_INTEGER;
    public static final int ALL_INT = Level.ALL_INTEGER;
    public static final Level OFF = Level.OFF;
    public static final Level FATAL = Level.ERROR;
    public static final Level ERROR = Level.ERROR;
    public static final Level WARN = Level.WARN;
    public static final Level INFO = Level.INFO;
    public static final Level VERBOSE = Level.DEBUG;
    public static final Level DEBUG = Level.DEBUG;
    public static final Level TRACE = Level.TRACE;
    public static final Level ALL = Level.ALL;

    public static Level toLevel(int val, Level defaultLevel) {
        Level sl = val == ALL_INT ? ALL : (val == TRACE_INT ? TRACE : (val == DEBUG_INT ? DEBUG : (val == VERBOSE_INT ? VERBOSE : (val == INFO_INT ? INFO : (val == WARN_INT ? WARN : (val == ERROR_INT ? ERROR : (val == FATAL_INT ? FATAL : (val == OFF_INT ? OFF : defaultLevel))))))));
        return sl;
    }

    public static Level toLevel(int val) {
        return LogbackSeverityLevel.toLevel(val, Level.INFO);
    }

    public static Level toLevel(String sArg, Level defaultLevel) {
        Level sl;
        if (sArg == null) {
            return defaultLevel;
        }
        String s = sArg.toUpperCase(Locale.US);
        if (s.equals("ALL")) {
            sl = ALL;
        } else if (s.equals("TRACE")) {
            sl = TRACE;
        } else if (s.equals("DEBUG")) {
            sl = DEBUG;
        } else if (s.equals("VERBOSE")) {
            sl = VERBOSE;
        } else if (s.equals("INFO")) {
            sl = INFO;
        } else if (s.equals("WARN")) {
            sl = WARN;
        } else if (s.equals("ERROR")) {
            sl = ERROR;
        } else if (s.equals("FATAL")) {
            sl = FATAL;
        } else if (s.equals("OFF")) {
            sl = OFF;
        } else {
            return defaultLevel;
        }
        return sl;
    }

    public static Level getLogbackSeverityLevel(SeverityLevel severityLevel) {
        Level result = INFO;
        if (severityLevel == SeverityLevel.OFF) {
            result = OFF;
        } else if (severityLevel == SeverityLevel.ERROR) {
            result = ERROR;
        } else if (severityLevel == SeverityLevel.WARN) {
            result = WARN;
        } else if (severityLevel == SeverityLevel.INFO) {
            result = INFO;
        } else if (severityLevel == SeverityLevel.VERBOSE) {
            result = VERBOSE;
        } else if (severityLevel == SeverityLevel.DEBUG) {
            result = DEBUG;
        } else if (severityLevel == SeverityLevel.TRACE) {
            result = TRACE;
        } else if (severityLevel == SeverityLevel.ALL) {
            result = ALL;
        } else {
            Assertion.wilyFail((String)("Unknown SeverityLevel: " + severityLevel));
        }
        return result;
    }

    public static SeverityLevel getSeverityLevelFromLogback(Level level) {
        SeverityLevel result = null;
        if (level == ERROR) {
            result = SeverityLevel.ERROR;
        } else if (level == WARN) {
            result = SeverityLevel.WARN;
        } else if (level == INFO) {
            result = SeverityLevel.INFO;
        } else if (level == VERBOSE) {
            result = SeverityLevel.VERBOSE;
        } else if (level == DEBUG) {
            result = SeverityLevel.DEBUG;
        } else if (level == TRACE) {
            result = SeverityLevel.TRACE;
        } else if (level == ALL) {
            result = SeverityLevel.ALL;
        } else if (level == OFF) {
            result = SeverityLevel.OFF;
        } else {
            if (level == null) {
                return null;
            }
            Assertion.wilyFail((String)("Unknown SeverityLevel: " + level));
        }
        return result;
    }
}

