/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.feedback.backend.logback;

import ch.qos.logback.core.FileAppender;
import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.enterprise.EnterpriseAgent;
import com.wily.util.io.ExtendedFile;
import com.wily.util.properties.IndexedProperties;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;

public class ModuleFileAppender<E>
extends FileAppender<E> {
    public static final String extensionLogDirKeyPrefix = "introscope.agent.log.extension.dir.";

    private String getExtensionLogDir(String module) {
        try {
            IAgent agent = AgentShim.getAgent();
            IndexedProperties props = agent.IAgent_getIndexedProperties();
            String dir = props.getProperty(extensionLogDirKeyPrefix + module);
            if (dir == null) {
                ExtendedFile agentHomeDir = ((EnterpriseAgent)agent).IAgent_getAgentHome();
                dir = agentHomeDir.safeGetCanonicalPath(".") + "/logs";
            }
            return dir;
        }
        catch (AgentNotAvailableException e) {
            return null;
        }
    }

    @Override
    public void setFile(String file) {
        File f = new File(file);
        if (!f.isAbsolute()) {
            String module = this.getName().substring(5);
            String logDir = this.getExtensionLogDir(module);
            Path p = Paths.get(logDir, file);
            file = p.toString();
        }
        super.setFile(file);
    }
}

