/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.autoprobe.dynamic;

import com.wily.diagnos.cmp.directives.DGCompilerSettings;
import com.wily.diagnos.cmp.tracer.MethodTracer;
import com.wily.diagnos.cmp.transform.ITransformation;
import com.wily.introscope.autoprobe.dynamic.EqualsProxy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CompilerSettingsDiff {
    private DGCompilerSettings fPreviousSettings;
    private DGCompilerSettings fCurrentSettings;
    private boolean fTransformsAreEqual;
    private boolean fTracersAreEqual;

    public CompilerSettingsDiff(DGCompilerSettings previousSettings, DGCompilerSettings currentSettings) {
        this.fPreviousSettings = previousSettings;
        this.fCurrentSettings = currentSettings;
        this.createDiff();
    }

    private void createDiff() {
        ArrayList<MethodTracer> prevTracers = new ArrayList<MethodTracer>();
        ArrayList<MethodTracer> currentTracers = new ArrayList<MethodTracer>();
        Iterator tracerItrPrev = this.fPreviousSettings.getTracersIterator();
        while (tracerItrPrev.hasNext()) {
            MethodTracer methodTracer = (MethodTracer)tracerItrPrev.next();
            prevTracers.add(methodTracer);
        }
        Iterator tracerItr = this.fCurrentSettings.getTracersIterator();
        while (tracerItr.hasNext()) {
            MethodTracer methodTracer = (MethodTracer)tracerItr.next();
            currentTracers.add(methodTracer);
        }
        this.checkTracerEquality(prevTracers, currentTracers);
        ArrayList<ITransformation> prevTransforms = new ArrayList<ITransformation>();
        ArrayList<ITransformation> currentTransforms = new ArrayList<ITransformation>();
        Iterator itrPrev = this.fPreviousSettings.getTransformationsIterator();
        while (itrPrev.hasNext()) {
            ITransformation transformation = (ITransformation)itrPrev.next();
            prevTransforms.add(transformation);
        }
        Iterator itr = this.fCurrentSettings.getTransformationsIterator();
        while (itr.hasNext()) {
            ITransformation transformationOther = (ITransformation)itr.next();
            currentTransforms.add(transformationOther);
        }
        this.checkTransformationEquality(prevTransforms, currentTransforms);
    }

    private void checkTransformationEquality(List prevTransforms, List currentTransforms) {
        Iterator itrPrev = prevTransforms.iterator();
        while (itrPrev.hasNext()) {
            ITransformation transformation = (ITransformation)itrPrev.next();
            Iterator itr = currentTransforms.iterator();
            while (itr.hasNext()) {
                ITransformation transformationOther = (ITransformation)itr.next();
                if (!this.isTransformationEqual(transformation, transformationOther)) continue;
                itrPrev.remove();
                itr.remove();
            }
        }
        if (prevTransforms.size() == 0 && currentTransforms.size() == 0) {
            this.fTransformsAreEqual = true;
        }
    }

    private void checkTracerEquality(List prevTracers, List currentTracers) {
        Iterator tracerItrPrev = prevTracers.iterator();
        while (tracerItrPrev.hasNext()) {
            MethodTracer methodTracer = (MethodTracer)tracerItrPrev.next();
            Iterator tracerItr = currentTracers.iterator();
            while (tracerItr.hasNext()) {
                MethodTracer methodTracerOther = (MethodTracer)tracerItr.next();
                if (!this.isMethodTracerEqual(methodTracer, methodTracerOther)) continue;
                tracerItr.remove();
                tracerItrPrev.remove();
            }
        }
        if (prevTracers.size() == 0 && currentTracers.size() == 0) {
            this.fTracersAreEqual = true;
        }
    }

    public boolean areTracersEqual() {
        return this.fTracersAreEqual;
    }

    public boolean areTransformationsEqual() {
        return this.fTransformsAreEqual;
    }

    public boolean matchClass() {
        throw new RuntimeException();
    }

    public boolean isMethodTracerEqual(MethodTracer myMethodTracer, MethodTracer otherMethodTracer) {
        return this.checkEqualsByProxy(myMethodTracer, otherMethodTracer);
    }

    public boolean isTransformationEqual(ITransformation myTransformation, ITransformation otherTransformation) {
        return this.checkEqualsByProxy(myTransformation, otherTransformation);
    }

    private boolean checkEqualsByProxy(Object me, Object other) {
        EqualsProxy myProxy = new EqualsProxy(me);
        EqualsProxy otherProxy = new EqualsProxy(other);
        return myProxy.equals(otherProxy);
    }
}

