/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.upgrade.merge;

import com.wily.introscope.agent.upgrade.merge.AMergeBase;
import com.wily.introscope.agent.upgrade.merge.IMergeable;
import com.wily.introscope.agent.upgrade.merge.IRulesEngine;
import com.wily.introscope.agent.upgrade.merge.diff.model.MergedFileDiff;
import com.wily.introscope.agent.upgrade.merge.exceptions.MergeException;
import com.wily.introscope.agent.upgrade.merge.exceptions.NoMergeCandidatesException;
import com.wily.introscope.agent.upgrade.merge.pbd.MergePBDs;
import com.wily.introscope.agent.upgrade.merge.pbd.Undo;
import com.wily.introscope.agent.upgrade.merge.profile.Profile;
import com.wily.introscope.agent.upgrade.merge.profile.ProfileV2;
import com.wily.introscope.agent.upgrade.merge.util.KMergeConstants;
import com.wily.introscope.agent.upgrade.merge.util.UpgradeUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;

public class MergeConfigExtensions
extends AMergeBase {
    public MergeConfigExtensions() {
        super(MergeConfigExtensions.class.getName());
    }

    private String getArchiveFolderName(Path dirname) {
        String fileName = dirname.getFileName().toString();
        if (!fileName.contains("tar.gz")) {
            this.getLogger().log(Level.WARNING, dirname.getFileName() + " is not tar archive");
            return "";
        }
        return this.getExtensionFolderName(fileName);
    }

    private String getExtensionFolderName(String fileName) {
        int count = 0;
        int i = fileName.length() - 1;
        while (true) {
            if ('-' == fileName.charAt(i)) {
                ++count;
            }
            if (count == 2) {
                return fileName.subSequence(0, i).toString();
            }
            --i;
        }
    }

    public String mergeConfig(String oldConfigDir, String newConfigDir, IRulesEngine engine) throws MergeException {
        StringBuilder response = new StringBuilder();
        this.getLogger().info("Reading configurations from " + newConfigDir);
        Map<String, String> originalFiles = this.getConfigFiles(newConfigDir, false);
        Map<String, String> updateFiles = this.getConfigFiles(newConfigDir, true);
        this.getLogger().info("Reading configurations from existing install" + oldConfigDir);
        Map<String, String> customerFiles = this.getConfigFiles(oldConfigDir, false);
        if (updateFiles.isEmpty()) {
            this.getLogger().warning("No files found for merge. Path:" + newConfigDir);
            throw new NoMergeCandidatesException("No files found for merge. Path:" + newConfigDir);
        }
        if (customerFiles.isEmpty()) {
            this.getLogger().warning("No files found for merge. Path:" + oldConfigDir);
            throw new NoMergeCandidatesException("No files found for merge. Path:" + oldConfigDir);
        }
        HashMap<String, String> customerFilesAfterDelete = new HashMap<String, String>();
        customerFilesAfterDelete.putAll(customerFiles);
        for (String string : customerFiles.keySet()) {
            String ext = UpgradeUtil.getFileExtension(string);
            if (!("profile".equalsIgnoreCase(ext) && engine.isDelete(IRulesEngine.MergeableType.PROFILE, string) || "pbl".equalsIgnoreCase(ext) && engine.isDelete(IRulesEngine.MergeableType.PBL, string)) && (!"pbd".equalsIgnoreCase(ext) || !engine.isDelete(IRulesEngine.MergeableType.PBD, string))) continue;
            File custFile = new File(customerFiles.get(string));
            custFile.delete();
            customerFilesAfterDelete.remove(string);
            this.getLogger().info("Deleted " + string + " successfully.");
        }
        customerFiles = customerFilesAfterDelete;
        HashMap<String, String> trulyUpdated = new HashMap<String, String>();
        this.mergeInMemory(engine, updateFiles, customerFiles, trulyUpdated);
        response.append("Merged ");
        for (String s : trulyUpdated.keySet()) {
            response.append(s).append(" ");
        }
        response.append("in working directory").append("\n");
        try {
            this.copyFiles(originalFiles, trulyUpdated);
            response.append("Files written to /core/config.").append("\n");
        }
        catch (IOException iOException) {
            this.getLogger().log(Level.WARNING, "Exception while copying files:" + trulyUpdated.keySet());
            this.rollback();
            String msg = MessageFormat.format("Failed to merge {0} because {1}.", "\n" + iOException.getMessage());
            throw new MergeException(msg);
        }
        customerFiles.clear();
        updateFiles.clear();
        originalFiles.clear();
        customerFilesAfterDelete.clear();
        return response.toString();
    }

    public String mergeExtensions(String oldExtensionsDir, String newExtensionsDir, IRulesEngine engine) throws MergeException {
        StringBuilder response = new StringBuilder();
        this.getLogger().info("Reading configurations from " + newExtensionsDir);
        Map<String, String> newInstallationFiles = this.getConfigFilesFromNewInstall(newExtensionsDir);
        if (newInstallationFiles.isEmpty()) {
            this.getLogger().warning("No files found for merge. Path:" + newExtensionsDir);
            throw new NoMergeCandidatesException("No files found for merge. Path:" + newExtensionsDir);
        }
        this.getLogger().info("Reading configurations from " + oldExtensionsDir);
        Map<String, String> existingInstallationFiles = this.getConfigFilesFromExistingInstall(oldExtensionsDir);
        if (existingInstallationFiles.isEmpty()) {
            this.getLogger().warning("No files found for merge. Path:" + oldExtensionsDir);
            throw new NoMergeCandidatesException("No files found for merge. Path:" + oldExtensionsDir);
        }
        HashMap<String, String> trulyUpdated = new HashMap<String, String>();
        this.getLogger().info("Initiating extensions merge..");
        int mergeFileCount = this.mergeInMemory(engine, newInstallationFiles, existingInstallationFiles, trulyUpdated);
        response.append("Merged ").append(mergeFileCount).append(" extensions profile in working directory").append("\n");
        this.getLogger().info(response.toString());
        try {
            this.patchConfFilesInWD(trulyUpdated);
            this.copyFilesToOriginalInstallation(newExtensionsDir);
            response.append("Files written to ").append(newExtensionsDir).append("\n");
        }
        catch (IOException e) {
            this.getLogger().warning("Error while patching tar or copying updated profiles. Error-" + e.getMessage());
            this.rollback();
            String msg = MessageFormat.format("Error while patching tar or copying updated profiles. Error-{0}", "\n" + e.getMessage());
            throw new MergeException(msg);
        }
        return response.toString();
    }

    public String mergePBDInCoreConfig(String oldInstallPath, String newInstallPath) {
        this.mergePBDs(oldInstallPath, newInstallPath);
        return "PBDs in core config directory are merged";
    }

    private void mergePBDs(String oldInstallPath, String newInstallPath) {
        try {
            MergePBDs mergePBDs = new MergePBDs(oldInstallPath, newInstallPath);
            mergePBDs.merge();
        }
        catch (IOException e) {
            Undo.revert();
        }
    }

    public String mergeExtensionsPBD(String oldExtensionsDir, String newExtensionsDir, IRulesEngine engine) throws MergeException {
        StringBuilder response = new StringBuilder();
        this.getLogger().info("Reading configurations from " + newExtensionsDir);
        Map<String, String> newInstallationFiles = this.getPBDFilesFromNewInstall(newExtensionsDir);
        if (newInstallationFiles.isEmpty()) {
            this.getLogger().warning("No files found for merge. Path:" + newExtensionsDir);
            throw new NoMergeCandidatesException("No files found for merge. Path:" + newExtensionsDir);
        }
        this.getLogger().info("Reading configurations from " + oldExtensionsDir);
        Map<String, String> existingInstallationFiles = this.getPBDFromExistingInstall(oldExtensionsDir);
        if (existingInstallationFiles.isEmpty()) {
            this.getLogger().warning("No files found for merge. Path:" + oldExtensionsDir);
            throw new NoMergeCandidatesException("No files found for merge. Path:" + oldExtensionsDir);
        }
        for (String updateFile : newInstallationFiles.keySet()) {
            if (!existingInstallationFiles.containsKey(updateFile)) continue;
            this.mergePBDs(existingInstallationFiles.get(updateFile), newInstallationFiles.get(updateFile));
        }
        try {
            this.patchPBDFilesInWD(newInstallationFiles);
            this.copyFilesToOriginalInstallation(newExtensionsDir);
            response.append("Files written to ").append(newExtensionsDir).append("\n");
        }
        catch (IOException e) {
            this.getLogger().warning("Error while patching tar or copying updated profiles. Error-" + e.getMessage());
            this.rollback();
            String msg = MessageFormat.format("Error while patching tar or copying updated profiles. Error-{0}", "\n" + e.getMessage());
            throw new MergeException(msg);
        }
        return response.toString();
    }

    public String createDiffReport() {
        try {
            UpgradeUtil.WriteObjectToFileAsJson(this.getMergeDiff(), "merge-config.diff", this.getLogLocation(this.getWorkingDirectory()).toString());
            return "merge-config.diff created.";
        }
        catch (IOException e) {
            this.getLogger().log(Level.WARNING, "Cannot create extensions-config.diff");
            String msg = MessageFormat.format("Failed to create extensions-config.diff. Error - {0}", "\n" + e.getMessage());
            return msg;
        }
    }

    @Override
    protected int mergeInMemory(IRulesEngine engine, Map<String, String> updateFiles, Map<String, String> existingFiles, Map<String, String> trulyUpdated) throws MergeException {
        int mergeFileCount = 0;
        for (String updateFile : updateFiles.keySet()) {
            String msg;
            if (!existingFiles.containsKey(updateFile)) continue;
            try {
                MergedFileDiff mergeDiff;
                IMergeable<Profile> p1;
                IMergeable<Profile> profile;
                this.getLogger().info("Checking property difference between " + existingFiles.get(updateFile) + " with " + updateFiles.get(updateFile));
                if (KMergeConstants.kMergeDisabledProperties) {
                    profile = this.mergeProfileNoWrite(existingFiles.get(updateFile), updateFiles.get(updateFile), engine);
                    p1 = profile;
                    ((Profile)p1).getProfileDiffObject().setFileKey(updateFile);
                    mergeDiff = ((Profile)p1).getProfileDiffObject().getProfileMergeDiff();
                } else {
                    profile = this.mergeProfileV3(existingFiles.get(updateFile), updateFiles.get(updateFile), engine);
                    p1 = (ProfileV2)profile;
                    ((ProfileV2)p1).getProfileDiffObject().setFileKey(updateFile);
                    mergeDiff = ((ProfileV2)p1).getProfileDiffObject().getProfileMergeDiff();
                }
                if (!mergeDiff.propertiesMerged.isEmpty()) {
                    trulyUpdated.put(updateFile, updateFiles.get(updateFile));
                    this.getMergeDiff().mergedFiles.add(mergeDiff);
                    this.write(profile, updateFiles.get(updateFile));
                    this.getLogger().info("Merged at " + updateFiles.get(updateFile));
                    ++mergeFileCount;
                    continue;
                }
                this.getLogger().log(Level.ALL, "No property differences found");
            }
            catch (IOException e) {
                this.getLogger().log(Level.WARNING, "Could not merge: " + updateFile);
                msg = MessageFormat.format("Failed to merge {0} because {1}.", updateFile, "\n" + e.getMessage());
                throw new MergeException(msg);
            }
            catch (Exception ex) {
                this.getLogger().log(Level.WARNING, "Could not merge: " + updateFile);
                msg = MessageFormat.format("Failed to merge {0} because {1}.", updateFile, "\n" + ex.getMessage());
                throw new MergeException(msg);
            }
        }
        return mergeFileCount;
    }

    private void copyFilesToOriginalInstallation(String newExtensionsDir) throws IOException {
        final File extnsDir = new File(newExtensionsDir);
        final File[] extnsCollection = extnsDir.listFiles();
        Files.walkFileTree(this.getWorkingDirectory(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String fullPath = file.toString();
                if ("gz".equals(UpgradeUtil.getFileExtension(fullPath))) {
                    Path targetPath = extnsDir.toPath().resolve("deploy").resolve(file.getFileName());
                    Files.move(file, targetPath, StandardCopyOption.REPLACE_EXISTING);
                    MergeConfigExtensions.this.addRollbackArtifact(targetPath.toFile());
                    MergeConfigExtensions.this.getLogger().info("Copied file: " + file.getFileName() + " to :" + targetPath);
                    return FileVisitResult.SKIP_SUBTREE;
                }
                if (fullPath.endsWith(".properties")) {
                    Path parentFolder = file.getParent().getFileName();
                    for (File extractedExtension : extnsCollection) {
                        if (!extractedExtension.getName().toString().contains(parentFolder.toString())) continue;
                        Path targetPath = extractedExtension.toPath().resolve("bundle.properties");
                        Files.move(file, targetPath, StandardCopyOption.REPLACE_EXISTING);
                        MergeConfigExtensions.this.addRollbackArtifact(targetPath.toFile());
                        MergeConfigExtensions.this.getLogger().info("Copied file: " + extractedExtension.getName() + " to :" + targetPath);
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void patchConfFilesInWD(Map<String, String> trulyUpdated) throws IOException {
        for (String fileKey : trulyUpdated.keySet()) {
            String targetFolderName = fileKey.substring(0, fileKey.indexOf("/"));
            String filePath = trulyUpdated.get(fileKey);
            this.patchFilesInWD(filePath, targetFolderName);
        }
    }

    private void patchPBDFilesInWD(Map<String, String> trulyUpdated) throws IOException {
        for (String targetFolderName : trulyUpdated.keySet()) {
            String filePath = trulyUpdated.get(targetFolderName);
            this.patchFilesInWD(filePath, targetFolderName);
        }
    }

    private void patchFilesInWD(final String filePath, final String targetFolderName) throws IOException {
        try {
            Files.walkFileTree(this.getWorkingDirectory(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    String fullPath = file.toString();
                    if (fullPath.endsWith(".tar.gz.bkp") && file.getFileName().toString().contains(targetFolderName)) {
                        try {
                            if (!file.toFile().exists()) {
                                throw new MergeException(KMergeConstants.kNewline + "ERROR: The archive \"" + file.toFile() + "\" given as input doesn't exist.Please check the input.");
                            }
                            File directiveFile = new File(filePath);
                            if (!directiveFile.exists()) {
                                throw new MergeException(KMergeConstants.kNewline + "ERROR: The file \"" + file + "\" given as input doesn't exist.Please check the input.");
                            }
                            HashMap<String, File> fileEntries = new HashMap<String, File>();
                            if (directiveFile.isDirectory()) {
                                File[] files;
                                for (File fileEntry : files = directiveFile.listFiles()) {
                                    if (fileEntry.getName().endsWith(".bkp")) continue;
                                    String fileName = "directives/" + fileEntry.getName();
                                    fileEntries.put(fileName, fileEntry);
                                }
                            } else {
                                String fileName = directiveFile.getName();
                                fileEntries.put(fileName, directiveFile);
                            }
                            MergeConfigExtensions.this.updateInTar(fileEntries, file.toFile());
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                        catch (MergeException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Map<String, String> getConfigFilesFromNewInstall(String newDir) throws MergeException {
        HashMap<String, String> result = new HashMap<String, String>();
        File extnsDir = new File(newDir);
        this.getConfigFromExtensions(extnsDir, result, true);
        File deployDir = new File(newDir + "/deploy");
        if (deployDir.isDirectory()) {
            File[] extensionsCollection;
            for (File file : extensionsCollection = deployDir.listFiles()) {
                String[] fileDetails;
                String folderName = this.getArchiveFolderName(file.toPath());
                if (folderName.isEmpty() || result.containsKey(folderName + "/bundle.properties") || (fileDetails = this.getConfigFileFromTar(file.toString()))[0] == null) continue;
                result.put(fileDetails[0], fileDetails[1]);
                this.getLogger().info("Loaded " + fileDetails[0] + " from :" + fileDetails[1]);
            }
        }
        return result;
    }

    private Map<String, String> getPBDFilesFromNewInstall(String newDir) throws MergeException {
        HashMap<String, String> result = new HashMap<String, String>();
        File extnsDir = new File(newDir);
        this.getPBDFromExtensions(extnsDir, result, true);
        File deployDir = new File(newDir + "/deploy");
        if (deployDir.isDirectory()) {
            File[] extensionsCollection;
            for (File file : extensionsCollection = deployDir.listFiles()) {
                String folderName = this.getArchiveFolderName(file.toPath());
                if (folderName.isEmpty() || result.containsKey(folderName)) continue;
                this.getPBDFileFromTar(result, file.toString());
            }
        }
        return result;
    }

    private Map<String, String> getConfigFilesFromExistingInstall(String oldDir) throws MergeException {
        HashMap<String, String> result = new HashMap<String, String>();
        File extnsDir = new File(oldDir);
        if (!extnsDir.isDirectory()) {
            throw new MergeException("Not a directory of extensions-" + oldDir);
        }
        this.getConfigFromExtensions(extnsDir, result, false);
        return result;
    }

    private Map<String, String> getPBDFromExistingInstall(String oldDir) throws MergeException {
        HashMap<String, String> result = new HashMap<String, String>();
        File extnsDir = new File(oldDir);
        if (!extnsDir.isDirectory()) {
            throw new MergeException("Not a directory of extensions-" + oldDir);
        }
        this.getPBDFromExtensions(extnsDir, result, false);
        return result;
    }

    private void getPBDFromExtensions(File extnsDir, Map<String, String> result, boolean copyToWorkingDirectory) throws MergeException {
        File[] extensionsCollection = extnsDir.listFiles();
        assert (extensionsCollection != null);
        try {
            for (File file : extensionsCollection) {
                File[] fileDetails;
                File directivesFile;
                if (!file.isDirectory() || !(directivesFile = new File(file.getPath() + "/directives")).exists() || !directivesFile.isDirectory()) continue;
                for (File config : fileDetails = this.searchPBDs(directivesFile)) {
                    String folderName = this.getExtensionFolderName(file.getName());
                    if (folderName.isEmpty()) continue;
                    if (copyToWorkingDirectory) {
                        Path directivesTarget = extnsDir.toPath().resolve(file.getName()).resolve("directives");
                        Files.createDirectories(directivesTarget, new FileAttribute[0]);
                        result.put(folderName, directivesTarget.toString());
                        continue;
                    }
                    result.put(folderName, directivesFile.getPath());
                    this.getLogger().info("Loaded " + config.getName() + " from :" + directivesFile.getPath());
                }
            }
        }
        catch (Exception e) {
            throw new MergeException("Unable to fetch config from extensions.");
        }
    }

    private void getConfigFromExtensions(File extnsDir, Map<String, String> result, boolean copyToWorkingDirectory) throws MergeException {
        File[] extensionsCollection = extnsDir.listFiles();
        assert (extensionsCollection != null);
        try {
            for (File file : extensionsCollection) {
                File[] fileDetails;
                if (!file.isDirectory()) continue;
                for (File config : fileDetails = this.searchProfiles(file, true)) {
                    String folderName = this.getExtensionFolderName(file.getName());
                    if (folderName.isEmpty()) continue;
                    if (copyToWorkingDirectory) {
                        Path target = this.getWorkingDirectory().resolve(folderName);
                        Files.createDirectories(target, new FileAttribute[0]);
                        target = target.resolve(config.getName());
                        Files.deleteIfExists(target);
                        Files.copy(config.toPath(), target, new CopyOption[0]);
                        result.put(folderName + "/" + config.getName(), target.toString());
                        this.takeBackup(folderName, config);
                        this.getLogger().info("Loaded " + config.getName() + " from :" + target);
                        continue;
                    }
                    result.put(folderName + "/" + config.getName(), config.getPath());
                    this.getLogger().info("Loaded " + config.getName() + " from :" + config.getPath());
                }
            }
        }
        catch (IOException e) {
            throw new MergeException("Unable to fetch config from extensions.");
        }
    }

    private String[] getConfigFileFromTar(String dirPath) throws MergeException {
        String[] result = new String[2];
        File dir = new File(dirPath);
        if (!dir.exists()) {
            throw new MergeException(KMergeConstants.kNewline + "ERROR: The archive \"" + dirPath + "\" given as input doesn't exist.Please check the input.");
        }
        try {
            ArchiveEntry entry;
            String folderName = this.getArchiveFolderName(dir.toPath());
            Path target = this.getWorkingDirectory().resolve(folderName);
            Files.createDirectories(target, new FileAttribute[0]);
            File backupFile = this.takeBackup(folderName, dir);
            TarArchiveInputStream tar = new TarArchiveInputStream(new GZIPInputStream(new FileInputStream(backupFile)));
            while ((entry = tar.getNextEntry()) != null) {
                if (!"bundle.properties".equals(entry.getName())) continue;
                target = target.resolve(entry.getName());
                Files.deleteIfExists(target);
                Files.copy(tar, target, new CopyOption[0]);
                result[0] = folderName + "/" + entry.getName();
                result[1] = target.toString();
                break;
            }
            tar.close();
        }
        catch (FileNotFoundException e) {
            this.getLogger().log(Level.WARNING, "File is not a valid tar.gz : " + dir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private void getPBDFileFromTar(Map<String, String> result, String dirPath) throws MergeException {
        File dir = new File(dirPath);
        if (!dir.exists()) {
            throw new MergeException(KMergeConstants.kNewline + "ERROR: The archive \"" + dirPath + "\" given as input doesn't exist.Please check the input.");
        }
        try {
            ArchiveEntry entry;
            String folderName = this.getArchiveFolderName(dir.toPath());
            Path target = this.getWorkingDirectory().resolve(folderName);
            Path targetDirectives = target.resolve("directives");
            Files.createDirectories(targetDirectives, new FileAttribute[0]);
            File backupFile = this.takeBackup(folderName + "/directives", dir);
            TarArchiveInputStream tar = new TarArchiveInputStream(new GZIPInputStream(new FileInputStream(backupFile)));
            while ((entry = tar.getNextEntry()) != null) {
                if (!entry.getName().endsWith("pbd")) continue;
                Path accTarget = target.resolve(entry.getName());
                Files.deleteIfExists(accTarget);
                Files.copy(tar, accTarget, new CopyOption[0]);
                result.put(folderName, targetDirectives.toString());
            }
            tar.close();
        }
        catch (FileNotFoundException e) {
            this.getLogger().log(Level.WARNING, "File is not a valid tar.gz : " + dir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void updateInTar(Map<String, File> fileEntries, File tarName) throws MergeException {
        try {
            TarArchiveEntry entry;
            File tmpFile = File.createTempFile("tmp", null);
            TarArchiveInputStream tarInputStream = new TarArchiveInputStream(new GZIPInputStream(new FileInputStream(tarName)));
            TarArchiveOutputStream tarOutputStream = new TarArchiveOutputStream(new GZIPOutputStream(new FileOutputStream(tmpFile)));
            while ((entry = tarInputStream.getNextTarEntry()) != null) {
                if (fileEntries.containsKey(entry.getName())) {
                    TarArchiveEntry newEntry = new TarArchiveEntry(entry.getName());
                    File file = fileEntries.get(entry.getName());
                    newEntry.setSize(file.length());
                    tarOutputStream.putArchiveEntry(newEntry);
                    FileInputStream fs = new FileInputStream(file);
                    IOUtils.copy(fs, (OutputStream)tarOutputStream);
                    tarOutputStream.closeArchiveEntry();
                    fs.close();
                    continue;
                }
                tarOutputStream.putArchiveEntry(entry);
                IOUtils.copy(tarInputStream, (OutputStream)tarOutputStream);
                tarOutputStream.closeArchiveEntry();
            }
            tarInputStream.close();
            tarOutputStream.close();
            String targetTar = tarName.toString();
            targetTar = targetTar.substring(0, targetTar.length() - 4);
            Files.move(tmpFile.toPath(), new File(targetTar).toPath(), StandardCopyOption.REPLACE_EXISTING);
            this.getLogger().info("Patched " + targetTar);
        }
        catch (FileNotFoundException e) {
            this.getLogger().log(Level.WARNING, "File is not a valid tar.gz : " + tarName);
        }
        catch (IOException e) {
            this.getLogger().log(Level.WARNING, "Unable to take backup of " + tarName);
            throw new MergeException("Unable to take backup of " + tarName, e);
        }
    }
}

