/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.upgrade.merge;

import com.wily.introscope.agent.upgrade.merge.AMergeBase;
import com.wily.introscope.agent.upgrade.merge.IMergeable;
import com.wily.introscope.agent.upgrade.merge.IRulesEngine;
import com.wily.introscope.agent.upgrade.merge.exceptions.MergeException;
import com.wily.introscope.agent.upgrade.merge.rules.RulesEngine;
import com.wily.introscope.agent.upgrade.merge.util.UpgradeUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

public class MergeConfigurations
extends AMergeBase {
    public MergeConfigurations() {
        super(MergeConfigurations.class.getName());
    }

    protected void doMerge(String updateDir, String configDir, String mergeRules, boolean fromMergeUtility) throws MergeException {
        String ext;
        RulesEngine engine = new RulesEngine(mergeRules);
        Map<String, String> updateFiles = this.getConfigFiles(updateDir);
        Map<String, String> customerFiles = this.getConfigFiles(configDir);
        HashMap<String, String> customerFilesAfterDelete = new HashMap<String, String>();
        customerFilesAfterDelete.putAll(customerFiles);
        for (String customerFile : customerFiles.keySet()) {
            ext = UpgradeUtil.getFileExtension(customerFile);
            if (!("profile".equalsIgnoreCase(ext) && engine.isDelete(IRulesEngine.MergeableType.PROFILE, customerFile) || "pbl".equalsIgnoreCase(ext) && engine.isDelete(IRulesEngine.MergeableType.PBL, customerFile)) && (!"pbd".equalsIgnoreCase(ext) || !engine.isDelete(IRulesEngine.MergeableType.PBD, customerFile))) continue;
            File custFile = new File(customerFiles.get(customerFile));
            custFile.delete();
            customerFilesAfterDelete.remove(customerFile);
            this.getLogger().info("Deleted " + customerFile + " successfully.");
        }
        customerFiles = customerFilesAfterDelete;
        for (String updateFile : updateFiles.keySet()) {
            if (!customerFiles.containsKey(updateFile)) continue;
            ext = UpgradeUtil.getFileExtension(updateFile);
            String destDir = System.getProperty("user.dir") + File.separator + "mergedoutput";
            if (fromMergeUtility) {
                new File(destDir).mkdir();
            }
            try {
                if (this.shouldOverwrite(updateFile, ext, engine)) {
                    BufferedReader overWriteReader = new BufferedReader(new FileReader(updateFiles.get(updateFile)));
                    IMergeable ovreWrittenConfig = this.readConfig(overWriteReader, ext);
                    if (fromMergeUtility) {
                        this.write(ovreWrittenConfig, destDir + File.separator + updateFile);
                    } else {
                        this.write(ovreWrittenConfig, customerFiles.get(updateFile));
                    }
                    this.getLogger().info("Overwritten " + updateFile + " successfully.");
                    overWriteReader.close();
                    continue;
                }
                if (!this.shouldMerge(updateFile, ext, engine)) continue;
                IMergeable mergedConfig = null;
                BufferedReader rightReader = new BufferedReader(new FileReader(updateFiles.get(updateFile)));
                IMergeable updateConfig = this.readConfig(rightReader, ext);
                rightReader.close();
                BufferedReader leftReader = new BufferedReader(new FileReader(customerFiles.get(updateFile)));
                IMergeable customerConfig = this.readConfig(leftReader, ext);
                leftReader.close();
                mergedConfig = customerConfig.merge(updateConfig, engine);
                if (fromMergeUtility) {
                    this.write(mergedConfig, destDir + File.separator + updateFile);
                } else {
                    this.write(mergedConfig, customerFiles.get(updateFile));
                }
                this.getLogger().info("Merged " + updateFile + " successfully.");
            }
            catch (IOException e) {
                String msg = MessageFormat.format("Failed to merge {0} because {1}.", updateFile, "\n" + e.getMessage());
                throw new MergeException(msg);
            }
        }
        customerFiles.clear();
        updateFiles.clear();
        customerFilesAfterDelete.clear();
    }
}

