/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.upgrade.merge.pbd;

import java.io.File;
import java.util.HashSet;
import java.util.Set;

public class DirState {
    private String path;
    private Set<String> pblFiles = new HashSet<String>();
    private Set<String> pbdFiles = new HashSet<String>();

    public DirState(String path) {
        this.path = path;
        File directory = new File(path);
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isFile()) continue;
                String name = file.getName();
                if (name.endsWith(".pbl")) {
                    this.pblFiles.add(name);
                    continue;
                }
                if (!name.endsWith(".pbd")) continue;
                this.pbdFiles.add(name);
            }
        }
    }

    public boolean hasPBD(String file) {
        return this.pbdFiles.contains(file);
    }

    public boolean hasPBL(String file) {
        return this.pblFiles.contains(file);
    }

    public String getFullPath(String file) {
        return new File(this.path, file).getPath();
    }

    public Set<String> getPBLFiles() {
        return this.pblFiles;
    }

    public Set<String> getPBDFiles() {
        return this.pbdFiles;
    }
}

