/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.upgrade.merge.profile;

import com.wily.introscope.agent.upgrade.merge.IMergeable;
import com.wily.introscope.agent.upgrade.merge.IMetadataEntry;
import com.wily.introscope.agent.upgrade.merge.IRulesEngine;
import com.wily.introscope.agent.upgrade.merge.LineV2;
import com.wily.introscope.agent.upgrade.merge.diff.ProfileFileMergeDiff;
import com.wily.introscope.agent.upgrade.merge.profile.CommentV2;
import com.wily.introscope.agent.upgrade.merge.profile.Key;
import com.wily.introscope.agent.upgrade.merge.profile.PropertyV2;
import com.wily.introscope.agent.upgrade.merge.profile.Value;
import com.wily.introscope.agent.upgrade.merge.util.KMergeConstants;
import com.wily.introscope.agent.upgrade.merge.util.UpgradeUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.UUID;

public class ProfileV2
implements IMergeable<ProfileV2> {
    public static final String COPIED_AS_IS_FROM_OLD_INSTALLATION = "### Below property is copied as is from old installation ###";
    HashMap<String, LineV2> lines = new LinkedHashMap<String, LineV2>();
    private ProfileFileMergeDiff fProfileFileMergeDiff = new ProfileFileMergeDiff();

    public ProfileFileMergeDiff getProfileDiffObject() {
        return this.fProfileFileMergeDiff;
    }

    @Override
    public ProfileV2 merge(ProfileV2 other) {
        return null;
    }

    @Override
    public ProfileV2 merge(ProfileV2 old, IRulesEngine engine) {
        ProfileV2 profile = new ProfileV2();
        this.handleRenamedKeys(old, engine);
        int count = 0;
        for (String key : this.lines.keySet()) {
            LineV2 line = this.lines.get(key);
            ++count;
            if (line instanceof PropertyV2) {
                String keyToFind;
                PropertyV2 propertyInNewFile = (PropertyV2)line;
                if (engine.isEntryDelete(IRulesEngine.MergeableType.PROFILE, propertyInNewFile.fKey)) {
                    old.lines.remove(propertyInNewFile.fKey.getKey());
                }
                if (old.lines.containsKey(keyToFind = propertyInNewFile.fKey.getKey())) {
                    IRulesEngine.PreferenceType type = engine.getPreferredType(IRulesEngine.MergeableType.PROFILE, propertyInNewFile.fKey);
                    LineV2 oldline = old.lines.get(keyToFind);
                    PropertyV2 oldProperty = (PropertyV2)oldline;
                    boolean isRenamed = oldProperty.fKey.isKeyRenamed();
                    if (type == IRulesEngine.PreferenceType.CURRENT) {
                        this.handleCommonKey(propertyInNewFile, oldProperty, profile, ++count, isRenamed);
                        continue;
                    }
                    if (type != IRulesEngine.PreferenceType.UPGRADE) continue;
                    this.handleCommonKey(oldProperty, propertyInNewFile, profile, ++count, isRenamed);
                    continue;
                }
                profile.add(propertyInNewFile.fKey.getKey(), line);
                continue;
            }
            if (!(line instanceof CommentV2)) continue;
            profile.add(String.valueOf(count), line);
        }
        for (LineV2 line : old.lines.values()) {
            if (!(line instanceof PropertyV2)) continue;
            PropertyV2 prop = (PropertyV2)line;
            if (this.lines.containsKey(prop.fKey.getKey()) || profile.lines.containsKey(prop.fKey.getKey())) continue;
            CommentV2 carryForwardComment = new CommentV2(COPIED_AS_IS_FROM_OLD_INSTALLATION, ++count);
            profile.add(String.valueOf(count), new CommentV2("", ++count));
            profile.add(String.valueOf(count), carryForwardComment);
            profile.add(prop.fKey.getKey(), line);
            UUID keyId = profile.getProfileDiffObject().generatePropertyId();
            profile.getProfileDiffObject().setNewProperty(keyId, prop.fKey.getKey(), prop.fValue);
        }
        return profile;
    }

    private void handleCommonKey(PropertyV2 old, PropertyV2 preferred, ProfileV2 profile, int index, boolean isRenamed) {
        Value oldValue = old.fValue;
        if (oldValue != null && !oldValue.equals(preferred.fValue)) {
            old.lineContent = "#oldProperty: " + old.lineContent;
            old.fValue.setCommented();
            profile.add(String.valueOf(index), old);
            if (isRenamed) {
                preferred.lineContent = old.fKey.getKey() + "=" + preferred.fValue.getValue();
            }
            profile.add(preferred.fKey.getKey(), preferred);
            UUID keyId = profile.getProfileDiffObject().generatePropertyId();
            profile.getProfileDiffObject().setOldProperty(keyId, preferred.fKey.getKey(), oldValue);
            profile.getProfileDiffObject().setNewProperty(keyId, preferred.fKey.getKey(), preferred.fValue);
        } else {
            profile.add(preferred.fKey.getKey(), preferred);
        }
    }

    @Override
    public void write(Writer writer) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        for (LineV2 line : this.lines.values()) {
            stringBuilder.append(line.lineContent).append(KMergeConstants.kNewline);
        }
        writer.write(stringBuilder.toString());
        writer.flush();
    }

    private void add(String key, LineV2 line) {
        this.lines.put(key, line);
    }

    public static ProfileV2 read(BufferedReader reader, boolean shouldReadComments) throws IOException {
        ProfileV2 profile = new ProfileV2();
        String line = null;
        int count = 0;
        while ((line = reader.readLine()) != null) {
            ++count;
            if (line.trim().startsWith("#") || UpgradeUtil.isBlank(line)) {
                if (!shouldReadComments || line.trim().startsWith("#oldProperty: ")) continue;
                profile.add(String.valueOf(count), new CommentV2(line, count));
                continue;
            }
            String[] tokens = line.trim().split("=", 2);
            Value value = new Value(tokens[1], false, null, count);
            profile.add(tokens[0], new PropertyV2(new Key(tokens[0]), value, count, line));
        }
        return profile;
    }

    private void handleRenamedKeys(ProfileV2 oldProfile, IRulesEngine engine) {
        Set<IMetadataEntry> renamedKeys = engine.getAllRenamedEntries(IRulesEngine.MergeableType.PROFILE);
        if (renamedKeys != null && !renamedKeys.isEmpty()) {
            for (IMetadataEntry key : renamedKeys) {
                LineV2 toPushAgain;
                Key renamedKey;
                if (this.lines.containsKey(key.getKey())) {
                    renamedKey = engine.getRenamedEntry(IRulesEngine.MergeableType.PROFILE, key);
                    toPushAgain = this.lines.get(key.getKey());
                    ((PropertyV2)toPushAgain).fKey = renamedKey;
                    this.lines.put(key.getKey(), toPushAgain);
                }
                if (!oldProfile.lines.containsKey(key.getKey())) continue;
                renamedKey = engine.getRenamedEntry(IRulesEngine.MergeableType.PROFILE, key);
                toPushAgain = oldProfile.lines.get(key.getKey());
                ((PropertyV2)toPushAgain).fKey = renamedKey;
                oldProfile.lines.remove(key.getKey());
                oldProfile.lines.put(renamedKey.getKey(), toPushAgain);
            }
        }
    }
}

