/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.upgrade.merge.rules;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.wily.introscope.agent.upgrade.merge.IRulesEngine;
import com.wily.introscope.agent.upgrade.merge.exceptions.MergeException;
import com.wily.introscope.agent.upgrade.merge.rules.ARule;
import com.wily.introscope.agent.upgrade.merge.rules.ARuleDTO;
import com.wily.introscope.agent.upgrade.merge.rules.DeleteEntryRule;
import com.wily.introscope.agent.upgrade.merge.rules.DeleteFileRule;
import com.wily.introscope.agent.upgrade.merge.rules.NoMergeFileRule;
import com.wily.introscope.agent.upgrade.merge.rules.OverwriteFileRule;
import com.wily.introscope.agent.upgrade.merge.rules.PreferredEntryRule;
import com.wily.introscope.agent.upgrade.merge.rules.RenamedEntryRule;
import com.wily.introscope.agent.upgrade.merge.rules.RulePreferredEntryDTO;
import com.wily.introscope.agent.upgrade.merge.rules.RuleRenamedEntryDTO;
import com.wily.introscope.agent.upgrade.merge.rules.Rules;
import com.wily.introscope.agent.upgrade.merge.rules.RulesDTO;
import com.wily.introscope.agent.upgrade.merge.util.UpgradeUtil;
import java.io.File;
import java.io.FileReader;
import java.lang.reflect.Type;

public class RulesParser {
    private Rules fRules = new Rules();

    public RulesParser() {
    }

    public RulesParser(String rulesFile) throws MergeException {
        this.fRules = new Rules();
        if (rulesFile != null) {
            File file = new File(rulesFile);
            if (!file.exists()) {
                throw new MergeException("ERROR: The rule file \"" + rulesFile + "\" doesn't exist.");
            }
            this.parse(rulesFile);
        }
    }

    public Rules getRules() {
        return this.fRules;
    }

    protected void parse(String rulesFile) {
        String ext = UpgradeUtil.getFileExtension(rulesFile);
        if ("json".equalsIgnoreCase(ext)) {
            this.parseAsJson(rulesFile);
        }
    }

    private void parseAsJson(String rulesFile) {
        Gson gson = new GsonBuilder().create();
        try (JsonReader reader = new JsonReader(new FileReader(rulesFile));){
            ARule rul;
            RulesDTO rules = (RulesDTO)gson.fromJson(reader, (Type)((Object)RulesDTO.class));
            for (ARuleDTO aRuleDTO : rules.deleteEntryRules) {
                rul = new DeleteEntryRule(IRulesEngine.MergeableType.valueOf(aRuleDTO.type), aRuleDTO.name);
                this.fRules.addDeleteEntryRule((DeleteEntryRule)rul);
            }
            for (RulePreferredEntryDTO rulePreferredEntryDTO : rules.preferredEntryRules) {
                rul = new PreferredEntryRule(IRulesEngine.MergeableType.valueOf(rulePreferredEntryDTO.type), rulePreferredEntryDTO.name, IRulesEngine.PreferenceType.valueOf(rulePreferredEntryDTO.preference));
                this.fRules.addPreferredEntryRule((PreferredEntryRule)rul);
            }
            for (RuleRenamedEntryDTO ruleRenamedEntryDTO : rules.renamedEntryRules) {
                rul = new RenamedEntryRule(IRulesEngine.MergeableType.valueOf(ruleRenamedEntryDTO.type), ruleRenamedEntryDTO.name, ruleRenamedEntryDTO.renamed);
                this.fRules.addRenameEntryRule((RenamedEntryRule)rul);
            }
            for (ARuleDTO aRuleDTO : rules.deleteFileRules) {
                rul = new DeleteFileRule(IRulesEngine.MergeableType.valueOf(aRuleDTO.type), aRuleDTO.name);
                this.fRules.addDeleteFileRule((DeleteFileRule)rul);
            }
            for (ARuleDTO aRuleDTO : rules.overwriteFileRules) {
                rul = new OverwriteFileRule(IRulesEngine.MergeableType.valueOf(aRuleDTO.type), aRuleDTO.name);
                this.fRules.addOverwriteFileRule((OverwriteFileRule)rul);
            }
            for (ARuleDTO aRuleDTO : rules.noMergeFileRules) {
                rul = new NoMergeFileRule(IRulesEngine.MergeableType.valueOf(aRuleDTO.type), aRuleDTO.name);
                this.fRules.addNoMergeFileRule((NoMergeFileRule)rul);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

