/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.connection;

import com.wily.introscope.agent.connection.IAgentCommand;
import com.wily.introscope.agent.connection.IServerConnectionNotification;
import com.wily.introscope.agent.connection.IsengardServerConnectionManager;
import com.wily.introscope.agent.connection.TimesliceAgentCommand;
import com.wily.introscope.agent.connection.TransactionAgentCommand;
import com.wily.introscope.agent.sustainability.SustainabilityService;
import com.wily.introscope.spec.server.beans.agent.IAgentBridgeService;
import com.wily.util.adt.BlockingQueue;
import com.wily.util.clock.MasterClock;
import com.wily.util.feedback.DelegatingFeedbackChannel;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.PositiveIntegerConfigurationProperty;
import com.wily.util.text.IStringLocalizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

class ReportingQueue
implements IServerConnectionNotification {
    private static Module sModule = new Module("ReportingQueue");
    private static final String kTimeName = "introscope.agent.reportingqueue.size.minutes";
    private static final String kSizeName = "introscope.agent.reportingqueue.size";
    private static final String kMaxMemName = "introscope.agent.reportingqueue.memory.max";
    private static final int kTimeDefault = 3;
    private static final int kSizeDefault = 10000;
    private static final int kMaxMemDefault = 1024;
    private final BlockingQueue fQueue;
    private final AtomicBoolean fIsWaitingForInitialTimeSlice = new AtomicBoolean(false);
    private final AtomicBoolean fEnqueuingCommands = new AtomicBoolean(false);
    private final IModuleFeedbackChannel fFeedback;
    private int fSizeLimit;
    private int fTimeLimit;
    private final AtomicLong fSizeInBytes = new AtomicLong(0L);
    private int fMaxMetricLimit;
    private final AtomicLong fSizeInMetricValues = new AtomicLong(0L);
    private final AtomicLong fSizeInTraces = new AtomicLong(0L);
    private final AtomicBoolean fIsBufferingWhileOffline = new AtomicBoolean(true);
    private final AtomicBoolean connectionUp = new AtomicBoolean(false);
    private SustainabilityService sustainability;

    public ReportingQueue(ConfigurationManager manager, IStringLocalizer localizer, IModuleFeedbackChannel feedback) {
        this.fFeedback = new DelegatingFeedbackChannel(feedback, sModule);
        this.fQueue = new BlockingQueue(sModule.getName(), this.fFeedback);
        PositiveIntegerConfigurationProperty timeProperty = new PositiveIntegerConfigurationProperty(kTimeName, 3, this.fFeedback, sModule, localizer){

            @Override
            public void set(Object value) {
                ReportingQueue.this.fTimeLimit = (Integer)value;
                if (ReportingQueue.this.fTimeLimit == 0) {
                    IsengardServerConnectionManager.turnOffSendHistoricalData();
                    ReportingQueue.this.turnOffBufferingWhileOffline();
                    ReportingQueue.this.fFeedback.info(sModule, "Reporting Queue time limit set 0. There will be no metric buffering when EM connection is down.");
                }
            }
        };
        manager.add(timeProperty, true);
        PositiveIntegerConfigurationProperty sizeProperty = new PositiveIntegerConfigurationProperty(kSizeName, 10000, this.fFeedback, sModule, localizer){

            @Override
            public void set(Object value) {
                ReportingQueue.this.fSizeLimit = (Integer)value;
                ReportingQueue.this.fQueue.setLimit(ReportingQueue.this.fSizeLimit);
            }
        };
        manager.add(sizeProperty, true);
        PositiveIntegerConfigurationProperty maxMemProperty = new PositiveIntegerConfigurationProperty(kMaxMemName, 1024, this.fFeedback, sModule, localizer){

            @Override
            public void set(Object value) {
                ReportingQueue.this.fMaxMetricLimit = (Integer)value * 1024 / 70;
            }
        };
        manager.add(maxMemProperty, true);
        this.setEnqueuingStartingWithInitialTimeslice();
        this.fQueue.setLimit(this.fSizeLimit);
        this.fQueue.setDebuggingFeature("com.wily.util.adt.LimitingQueue.log.drops", null, 1);
    }

    private boolean isSustainabilityEnabled() {
        if (this.sustainability == null) {
            this.sustainability = SustainabilityService.getSustainabilityServiceInstance();
            if (this.sustainability == null) {
                return false;
            }
        }
        return this.sustainability.isSustainabilityMetricsEnabled();
    }

    private boolean checkQueueTimeLimit() {
        long oldestElementTime = 0L;
        IAgentCommand head = (IAgentCommand)this.fQueue.peek();
        if (head instanceof TimesliceAgentCommand) {
            oldestElementTime = ((TimesliceAgentCommand)head).getTimestamp();
        } else if (head instanceof TransactionAgentCommand) {
            oldestElementTime = ((TransactionAgentCommand)head).getTimestamp();
        } else {
            if (head != null) {
                try {
                    this.fQueue.dequeue();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return true;
        }
        if (oldestElementTime > 0L) {
            long now = System.currentTimeMillis();
            long age = now - oldestElementTime;
            long limitInMillis = this.fTimeLimit * 60000;
            if (this.fFeedback.isDebugEnabled(sModule)) {
                this.fFeedback.debug(sModule, "Queue age is " + age);
            }
            if (age > limitInMillis) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(IAgentCommand command, IAgentBridgeService agentBridge) {
        if (this.shouldDropData(command)) {
            return false;
        }
        BlockingQueue blockingQueue = this.fQueue;
        synchronized (blockingQueue) {
            boolean result = this.fQueue.enqueue(command);
            if (!result) {
                this.handleQueueFull("Reporting Queue has reached size limit " + this.fSizeLimit);
            } else {
                if (!this.checkQueueTimeLimit()) {
                    this.handleQueueFull("Reporting Queue has reached time limit " + this.fTimeLimit);
                }
                String commandType = "";
                if (command instanceof TimesliceAgentCommand) {
                    commandType = "M";
                    TimesliceAgentCommand c = (TimesliceAgentCommand)command;
                    long metrics = this.fSizeInMetricValues.addAndGet(c.getSizeInMetrics());
                    if (this.fMaxMetricLimit > 0 && this.fQueue.size() > 4 && metrics > (long)this.fMaxMetricLimit) {
                        this.handleQueueFull("Reporting Queue has reached max metric limit " + this.fMaxMetricLimit);
                        result = false;
                    }
                    if (this.fFeedback.isDebugEnabled(sModule) || this.isSustainabilityEnabled()) {
                        this.fSizeInBytes.addAndGet(c.getSizeInBytes());
                    }
                } else if (command instanceof TransactionAgentCommand) {
                    commandType = "T";
                    TransactionAgentCommand c = (TransactionAgentCommand)command;
                    this.fSizeInTraces.addAndGet(c.getSize());
                }
                if (this.isSustainabilityEnabled()) {
                    this.sustainability.reportIntegerFluctuatingCounterSustainabilityMetric("ReportingQueue:Length", this.fQueue.size());
                    this.sustainability.reportLongFluctuatingCounterSustainabilityMetric("ReportingQueue:Number of Metric Values", this.fSizeInMetricValues.get());
                    this.sustainability.reportLongFluctuatingCounterSustainabilityMetric("ReportingQueue:Size in Bytes", this.fSizeInBytes.get());
                    this.sustainability.reportLongFluctuatingCounterSustainabilityMetric("ReportingQueue:Number of Traces", this.fSizeInTraces.get());
                }
                if (this.fFeedback.isDebugEnabled(sModule)) {
                    this.fFeedback.debug(sModule, commandType + " -> Reporting Queue length is " + this.fQueue.size() + ", and size is " + this.fSizeInMetricValues + " metrics or " + this.fSizeInBytes + " bytes and " + this.fSizeInTraces + " traces.");
                }
            }
            return result;
        }
    }

    private void handleQueueFull(String msg) {
        this.fFeedback.info(sModule, msg);
        if (!this.connectionUp.get()) {
            this.setEnqueuingCommands(false);
        }
        this.clear();
        this.setEnqueuingStartingWithInitialTimeslice();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IAgentCommand getNextAgentCommand() throws Exception {
        BlockingQueue blockingQueue = this.fQueue;
        synchronized (blockingQueue) {
            IAgentCommand command;
            try {
                command = (IAgentCommand)this.fQueue.interruptableDequeue(1000L);
            }
            catch (Exception e) {
                if (this.fQueue.size() == 0) {
                    this.fSizeInBytes.set(0L);
                    this.fSizeInMetricValues.set(0L);
                }
                return null;
            }
            String commandType = "";
            if (command instanceof TimesliceAgentCommand) {
                commandType = "M";
                TimesliceAgentCommand c = (TimesliceAgentCommand)command;
                this.fSizeInMetricValues.addAndGet(-c.getSizeInMetrics());
                if (this.fFeedback.isDebugEnabled(sModule) || this.isSustainabilityEnabled()) {
                    this.fSizeInBytes.addAndGet(-c.getSizeInBytes());
                    long timeStamp = c.getTimestamp();
                    if (timeStamp > 0L) {
                        long lag = MasterClock.currentTimeMillis() - timeStamp;
                        this.sustainability.reportLongAverageSustainabilityMetric("ReportingQueue:Metric Lag Time (ms)", lag);
                        this.fFeedback.debug(sModule, "Time lag is " + lag);
                    }
                }
            } else if (command instanceof TransactionAgentCommand) {
                commandType = "T";
                TransactionAgentCommand c = (TransactionAgentCommand)command;
                this.fSizeInTraces.addAndGet(-c.getSize());
            }
            if (this.fFeedback.isDebugEnabled(sModule)) {
                this.fFeedback.debug(sModule, commandType + " <- Reporting Queue length is " + this.fQueue.size() + ", and size is " + this.fSizeInMetricValues + " metrics or " + this.fSizeInBytes + " bytes and " + this.fSizeInTraces + " traces.");
            }
            return command;
        }
    }

    public boolean handleNextAgentCommand() throws Exception {
        IAgentCommand command = this.getNextAgentCommand();
        if (command != null) {
            long startTime = System.nanoTime();
            command.handleAgentCommand();
            int ms = (int)((System.nanoTime() - startTime) / 1000000L);
            if (this.isSustainabilityEnabled()) {
                this.sustainability.reportIntegerAverageSustainabilityMetric("ReportingQueue:Command Send Time (ms)", ms);
            }
            return true;
        }
        return false;
    }

    public void clear() {
        this.fQueue.removeAllElements();
        this.fSizeInBytes.set(0L);
        this.fSizeInMetricValues.set(0L);
    }

    @Override
    public void connectionUp() {
        if (!this.fIsBufferingWhileOffline.get()) {
            this.clear();
            this.setEnqueuingStartingWithInitialTimeslice();
            this.setEnqueuingCommands(true);
        }
        this.connectionUp.set(true);
        this.setEnqueuingCommands(true);
    }

    public void sendingMetricFromPlatform() {
        this.setFoundInitialTimeslice();
    }

    @Override
    public void connectionDown() {
        if (!this.fIsBufferingWhileOffline.get()) {
            this.setEnqueuingCommands(false);
            this.clear();
        }
        this.connectionUp.set(false);
    }

    private boolean shouldDropData(IAgentCommand command) {
        boolean dropData = false;
        if (!this.isEnqueuingCommands()) {
            this.getFeedbackChannel().trace("dropping data.");
            dropData = true;
        } else if (this.isWaitingForInitialTimeSlice()) {
            if (!this.isInitialTimeslice(command)) {
                this.getFeedbackChannel().trace("dropping data: not an initial timeslice");
                dropData = true;
            } else {
                this.setFoundInitialTimeslice();
                this.clear();
                dropData = false;
            }
        }
        return dropData;
    }

    private boolean isInitialTimeslice(IAgentCommand command) {
        return command instanceof TimesliceAgentCommand && ((TimesliceAgentCommand)command).isFirstTimeslice();
    }

    private IModuleFeedbackChannel getFeedbackChannel() {
        return this.fFeedback;
    }

    public boolean isEnqueuingCommands() {
        return this.fEnqueuingCommands.get();
    }

    private void setEnqueuingStartingWithInitialTimeslice() {
        this.fIsWaitingForInitialTimeSlice.set(true);
    }

    public boolean isWaitingForInitialTimeSlice() {
        return this.fIsWaitingForInitialTimeSlice.get();
    }

    private void setFoundInitialTimeslice() {
        this.fIsWaitingForInitialTimeSlice.set(false);
    }

    private void setEnqueuingCommands(boolean enqueuingCommands) {
        this.fEnqueuingCommands.set(enqueuingCommands);
    }

    public void turnOnBufferingWhileOffline() {
        this.fFeedback.info(sModule, "Turning on metric buffering when EM connection is down or slow.");
        this.fIsBufferingWhileOffline.set(true);
    }

    public void turnOffBufferingWhileOffline() {
        this.fFeedback.info(sModule, "Turning off metric buffering when EM connection is down or slow.");
        this.fIsBufferingWhileOffline.set(false);
        this.clear();
    }

    public boolean isBufferingWhileOffline() {
        return this.fIsBufferingWhileOffline.get();
    }
}

