/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.filter.sampling;

import com.wily.introscope.agent.filter.sampling.IStatisticalHeap;
import com.wily.introscope.agent.filter.sampling.StatisticalElement;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;

final class StatisticalHeap {
    private static final StatisticalElement[] NO_ELEMENTS = new StatisticalElement[0];
    private static final IStatisticalHeap EMPTY = new IStatisticalHeap(){

        @Override
        public StatisticalElement[] toArray() {
            return NO_ELEMENTS;
        }

        @Override
        public StatisticalElement insert(StatisticalElement element) {
            return element;
        }
    };

    StatisticalHeap() {
    }

    static final IStatisticalHeap create(int capacity) {
        if (capacity <= 0) {
            return EMPTY;
        }
        if (capacity == 1) {
            return new SingleElementHeap();
        }
        return new PriorityQueueHeap(capacity);
    }

    static final class PriorityQueueHeap
    extends PriorityQueue<StatisticalElement>
    implements IStatisticalHeap {
        private static final long serialVersionUID = 8686067490548928875L;
        private final int capacity;
        private final Map<String, StatisticalElement> deduping;

        PriorityQueueHeap(int capacity) {
            super(capacity, StatisticalElement.COMPARATOR);
            this.capacity = capacity;
            this.deduping = new HashMap<String, StatisticalElement>(capacity);
        }

        @Override
        public synchronized StatisticalElement insert(StatisticalElement element) {
            if (this.size() < this.capacity) {
                StatisticalElement duplicateOf = this.deduping.get(element.id);
                if (duplicateOf == null) {
                    this.add(element);
                    this.deduping.put(element.id, element);
                    return null;
                }
                if (element.value <= duplicateOf.value) {
                    return element;
                }
                this.remove(duplicateOf);
                this.deduping.put(element.id, element);
                this.add(element);
                return duplicateOf;
            }
            if (element.value <= ((StatisticalElement)this.peek()).value) {
                return element;
            }
            StatisticalElement duplicateOf = this.deduping.get(element.id);
            if (duplicateOf == null) {
                StatisticalElement discarded = (StatisticalElement)this.poll();
                this.deduping.remove(discarded.id);
                this.add(element);
                this.deduping.put(element.id, element);
                return discarded;
            }
            if (element.value <= duplicateOf.value) {
                return element;
            }
            this.remove(duplicateOf);
            this.deduping.put(element.id, element);
            this.add(element);
            return duplicateOf;
        }

        @Override
        public synchronized StatisticalElement[] toArray() {
            return super.toArray(new StatisticalElement[this.size()]);
        }
    }

    static final class SingleElementHeap
    implements IStatisticalHeap {
        private StatisticalElement small;

        SingleElementHeap() {
        }

        @Override
        public synchronized StatisticalElement insert(StatisticalElement element) {
            if (this.small == null) {
                this.small = element;
                return null;
            }
            if (element.value <= this.small.value) {
                return element;
            }
            StatisticalElement discarded = this.small;
            this.small = element;
            return discarded;
        }

        @Override
        public synchronized StatisticalElement[] toArray() {
            if (this.small == null) {
                return NO_ELEMENTS;
            }
            return new StatisticalElement[]{this.small};
        }
    }
}

