/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.feedback;

import com.wily.util.ConfigurationWatcher;
import com.wily.util.IConfigurationListener;
import com.wily.util.adt.IAgedMap;
import com.wily.util.adt.IConcurrentMapFactory;
import com.wily.util.feedback.AsynchFeedbackChannel;
import com.wily.util.feedback.DelegatingFeedbackChannel;
import com.wily.util.feedback.IApplicationFeedbackChannel;
import com.wily.util.feedback.IAsynchFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.feedback.SeverityLevel;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.resource.IResource;
import java.util.Properties;

public final class CachingDelegatingFeedbackChannel
extends DelegatingFeedbackChannel
implements IApplicationFeedbackChannel,
IAsynchFeedbackChannel {
    private IAgedMap fLogDebugEnabledMap;
    private IAgedMap fLogVerboseEnabledMap;
    private IAgedMap fLogTraceEnabledMap;
    private IAgedMap fLogInfoEnabledMap;
    private IAgedMap fLogWarnEnabledMap;
    private IAgedMap fLogErrorEnabledMap;
    private final CheckLevel debugCheckLevel = new CheckLevel(){

        @Override
        public boolean getLevelFromUnderlyingLayer(Module module) {
            return CachingDelegatingFeedbackChannel.this.isDebugEnabled1(module);
        }
    };
    private final CheckLevel traceCheckLevel = new CheckLevel(){

        @Override
        public boolean getLevelFromUnderlyingLayer(Module module) {
            return CachingDelegatingFeedbackChannel.this.isTraceEnabled1(module);
        }
    };
    private final CheckLevel verboseCheckLevel = new CheckLevel(){

        @Override
        public boolean getLevelFromUnderlyingLayer(Module module) {
            return CachingDelegatingFeedbackChannel.this.isVerboseEnabled1(module);
        }
    };
    private final CheckLevel warnCheckLevel = new CheckLevel(){

        @Override
        public boolean getLevelFromUnderlyingLayer(Module module) {
            return CachingDelegatingFeedbackChannel.this.isWarningEnabled1(module);
        }
    };
    private final CheckLevel infoCheckLevel = new CheckLevel(){

        @Override
        public boolean getLevelFromUnderlyingLayer(Module module) {
            return CachingDelegatingFeedbackChannel.this.isInfoEnabled1(module);
        }
    };
    private final CheckLevel errorCheckLevel = new CheckLevel(){

        @Override
        public boolean getLevelFromUnderlyingLayer(Module module) {
            return CachingDelegatingFeedbackChannel.this.isErrorEnabled1(module);
        }
    };

    public CachingDelegatingFeedbackChannel(IApplicationFeedbackChannel delegate, Module module) {
        super(delegate, module);
    }

    public void setMapFactory(IConcurrentMapFactory factory) {
        this.fLogDebugEnabledMap = factory.getConcurrentAgingMap("FeedbackChannelDebugCache");
        this.fLogVerboseEnabledMap = factory.getConcurrentAgingMap("FeedbackChannelVerboseCache");
        this.fLogTraceEnabledMap = factory.getConcurrentAgingMap("FeedbackChannelTraceCache");
        this.fLogInfoEnabledMap = factory.getConcurrentAgingMap("FeedbackChannelInfoCache");
        this.fLogWarnEnabledMap = factory.getConcurrentAgingMap("FeedbackChannelErrorCache");
        this.fLogErrorEnabledMap = factory.getConcurrentAgingMap("FeedbackChannelWarnCache");
    }

    public boolean isDebugEnabled1(Module module) {
        return super.isDebugEnabled(module);
    }

    public boolean isErrorEnabled1(Module module) {
        return super.isErrorEnabled(module);
    }

    public boolean isInfoEnabled1(Module module) {
        return super.isInfoEnabled(module);
    }

    public boolean isTraceEnabled1(Module module) {
        return super.isTraceEnabled(module);
    }

    public boolean isVerboseEnabled1(Module module) {
        return super.isVerboseEnabled(module);
    }

    public boolean isWarningEnabled1(Module module) {
        return super.isWarningEnabled(module);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isDebugEnabled(this.fModule);
    }

    @Override
    public boolean isDebugEnabled(Module module) {
        return this.debugCheckLevel.isEnabled(module, this.fLogDebugEnabledMap);
    }

    @Override
    public boolean isErrorEnabled(Module module) {
        return this.errorCheckLevel.isEnabled(module, this.fLogErrorEnabledMap);
    }

    @Override
    public boolean isInfoEnabled(Module module) {
        return this.infoCheckLevel.isEnabled(module, this.fLogInfoEnabledMap);
    }

    @Override
    public boolean isLogEnabled(SeverityLevel severity, Module module) {
        return super.isLogEnabled(severity, module);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isTraceEnabled(this.fModule);
    }

    @Override
    public boolean isTraceEnabled(Module module) {
        return this.traceCheckLevel.isEnabled(module, this.fLogTraceEnabledMap);
    }

    @Override
    public boolean isVerboseEnabled() {
        return this.isVerboseEnabled(this.fModule);
    }

    @Override
    public boolean isVerboseEnabled(Module module) {
        return this.verboseCheckLevel.isEnabled(module, this.fLogVerboseEnabledMap);
    }

    @Override
    public boolean isWarningEnabled(Module module) {
        return this.warnCheckLevel.isEnabled(module, this.fLogWarnEnabledMap);
    }

    @Override
    public void setRootVerbose() {
        ((IApplicationFeedbackChannel)this.fDelegate).setRootVerbose();
    }

    @Override
    public boolean containsLoggingConfiguration(Properties properties) {
        return ((IApplicationFeedbackChannel)this.fDelegate).containsLoggingConfiguration(properties);
    }

    @Override
    public void setConfiguration(Properties properties) {
        ((IApplicationFeedbackChannel)this.fDelegate).setConfiguration(properties);
    }

    @Override
    public void addAsyncLoggingToHeartbeat(IntervalHeartbeat commonHeartbeat) {
        if (this.fDelegate != null && this.fDelegate instanceof IAsynchFeedbackChannel) {
            ((IAsynchFeedbackChannel)this.fDelegate).addAsyncLoggingToHeartbeat(commonHeartbeat);
        } else {
            this.warn(this.fModule, "Cannot initialize log hearthbeat because the log implementation is not asynchronous");
        }
    }

    public void removeAsyncLoggingFromHeartbeat() {
        if (this.fDelegate != null && this.fDelegate instanceof AsynchFeedbackChannel) {
            ((AsynchFeedbackChannel)this.fDelegate).removeAsyncLoggingFromHeartbeat();
        } else {
            this.warn(this.fModule, "Cannot de-initialize log hearthbeat because the log implementation is not asynchronous");
        }
    }

    public void setShouldBuffer(boolean shouldBuffer) {
        if (this.fDelegate != null && this.fDelegate instanceof AsynchFeedbackChannel) {
            ((AsynchFeedbackChannel)this.fDelegate).setShouldBuffer(shouldBuffer);
        } else {
            this.warn(this.fModule, "Cannot set buffer policy because the log implementation is not asynchronous");
        }
    }

    public void flush() {
        if (this.fDelegate != null && this.fDelegate instanceof AsynchFeedbackChannel) {
            ((AsynchFeedbackChannel)this.fDelegate).flush();
        } else {
            this.warn(this.fModule, "Cannot flush because the log implementation is not asynchronous");
        }
    }

    @Override
    public void setConfiguration(ConfigurationWatcher configurationWatcher, IResource profileResource) {
        if (this.fDelegate != null && this.fDelegate instanceof IAsynchFeedbackChannel) {
            ((IAsynchFeedbackChannel)this.fDelegate).setConfiguration(configurationWatcher, profileResource);
        } else {
            this.warn(this.fModule, "Cannot set configuration for heartbeat because the log implementation is not asynchronous");
        }
    }

    @Override
    public final void setConfiguration(ConfigurationWatcher watcher, IResource configurationResource, IConfigurationListener listener) {
        if (this.fDelegate != null && this.fDelegate instanceof IAsynchFeedbackChannel) {
            ((IAsynchFeedbackChannel)this.fDelegate).setConfiguration(watcher, configurationResource, listener);
        } else {
            this.warn(this.fModule, "Cannot set configuration for heartbeat because the log implementation is not asynchronous");
        }
    }

    public static abstract class CheckLevel {
        public abstract boolean getLevelFromUnderlyingLayer(Module var1);

        public boolean isEnabled(Module key, IAgedMap map) {
            Object resultFromMap;
            if (map != null && (resultFromMap = map.getAged(key)) != null) {
                return (Boolean)resultFromMap;
            }
            boolean valueFromUnderlyingValue = this.getLevelFromUnderlyingLayer(key);
            if (map != null) {
                map.addAged(key, valueFromUnderlyingValue ? Boolean.TRUE : Boolean.FALSE);
            }
            return valueFromUnderlyingValue;
        }
    }
}

