/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.sqlagent;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.sqlagent.StatementToSQLMappingTracer;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ISharedMetricHolder;
import com.wily.introscope.agent.trace.hc2.ASingleMetricTracerFactory;
import com.wily.util.adt.IAgedMap;
import com.wily.util.adt.IConcurrentMapFactory;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;
import java.sql.Statement;

public class ProbeStatementIdToStatementMappingTracer
extends ASingleMetricTracerFactory {
    private static IConcurrentMapFactory factory = null;
    private static IAgedMap idToStatementCache;
    private static IModuleFeedbackChannel feedback;
    private static final Module module;

    public ProbeStatementIdToStatementMappingTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        feedback = this.getAgent().IAgent_getModuleFeedback();
    }

    public final ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public final boolean ITracerFactory_isShutoff() {
        return false;
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        Object key = data.getInvocationReturnValueAsObject();
        Object statement = data.getInvocationObject();
        if (statement == null || !(statement instanceof Statement)) {
            Assertion.wilyAssert((String)"expected a Statement");
            return;
        }
        if (key == null || !(key instanceof String)) {
            Assertion.wilyAssert((String)"expected a string as key");
            return;
        }
        this.putInCache(key, statement);
    }

    private void putInCache(Object key, Object stmtObject) {
        idToStatementCache.addAged(key, stmtObject);
    }

    private static Statement getFromCache(Object key) {
        Object val = idToStatementCache.getAged(key);
        if (val instanceof Statement) {
            return (Statement)val;
        }
        return null;
    }

    protected String getCreationSQLType(Statement statement) {
        return StatementToSQLMappingTracer.getSQLType(statement);
    }

    protected String getCreationSQL(Statement statement, InvocationData data) {
        String sql = (String)data.get("com.wily.introscope.agent.sqlagent.dynamic.query.normalized.sql.cache");
        if (sql == null && (sql = StatementToSQLMappingTracer.getSQL(statement)) != null) {
            data.put("com.wily.introscope.agent.sqlagent.dynamic.query.normalized.sql.cache", (Object)sql);
        }
        return sql;
    }

    public static Statement getStatement(Object statementId) {
        Statement stmt = ProbeStatementIdToStatementMappingTracer.getFromCache(statementId);
        return stmt;
    }

    protected IRepository getRepository(InvocationData data, ISharedMetricHolder holder) {
        return null;
    }

    protected void doOnStartTrace(int tracerIndex, IStackElement data, ASingleMetricTracerFactory.ISingleMetricHolder mh) {
    }

    protected void doOnEndTrace(int tracerIndex, IStackElement data, ASingleMetricTracerFactory.ISingleMetricHolder mh) {
    }

    static {
        module = new Module("ProbeStatementIdToStatementMappingTracer");
        try {
            factory = AgentShim.getAgent().IAgent_getConcurrentMapFactory();
            idToStatementCache = factory.getConcurrentAgingMap("ProbeStatementCache");
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
            // empty catch block
        }
    }
}

