/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.agent.beans.autotracing;

import com.wily.introscope.spec.agent.beans.autotracing.IAutoTracingTrigger;
import com.wily.introscope.spec.metric.AgentMetric;
import java.io.Serializable;

public class AgentMetricThresholdTrigger
implements IAutoTracingTrigger,
Serializable {
    private static final long serialVersionUID = 5481867891373658614L;
    private final AgentMetric.AgentMetricKey fKey;
    private long fElapsedTimeThreshold;

    public AgentMetricThresholdTrigger(AgentMetric metric) {
        this.fKey = new AgentMetric.AgentMetricKey(metric.getAttributeURL(), metric.getAttributeType());
    }

    public AgentMetricThresholdTrigger(AgentMetric metric, long threshold) {
        this.fKey = new AgentMetric.AgentMetricKey(metric.getAttributeURL(), metric.getAttributeType());
        this.fElapsedTimeThreshold = threshold;
    }

    public AgentMetricThresholdTrigger(AgentMetric.AgentMetricKey metricKey, long threshold) {
        this.fKey = metricKey;
        this.fElapsedTimeThreshold = threshold;
    }

    public AgentMetricThresholdTrigger(String url, long threshold) {
        this.fKey = new AgentMetric.AgentMetricKey(url, 15);
        this.fElapsedTimeThreshold = threshold;
    }

    public AgentMetricThresholdTrigger(AgentMetricThresholdTrigger trigger) {
        this.fKey = trigger.fKey;
        this.fElapsedTimeThreshold = trigger.fElapsedTimeThreshold;
    }

    public long getElapsedTimeThreshold() {
        return this.fElapsedTimeThreshold;
    }

    public void setElapsedTimeThreshold(long threshold) {
        this.fElapsedTimeThreshold = threshold;
    }

    public int hashCode() {
        return this.fKey.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AgentMetricThresholdTrigger other = (AgentMetricThresholdTrigger)obj;
        return !(this.fKey == null ? other.fKey != null : !this.fKey.equals(other.fKey));
    }

    public AgentMetric.AgentMetricKey getMetricKey() {
        return this.fKey;
    }

    public String toString() {
        return "AgentMetricThresholdTrigger [fMetric=" + this.fKey + ", fElapsedTimeThreshold=" + this.fElapsedTimeThreshold + "]";
    }
}

