/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.io;

import com.wily.util.io.FastArrayCopy;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class NonSyncBufferedInputStream
extends FilterInputStream {
    private static int kDefaultBufferSize = 32768;
    private byte[] fBuffer;
    private int fCount;
    private int fPosition;

    public NonSyncBufferedInputStream(InputStream input) {
        this(input, kDefaultBufferSize);
    }

    public NonSyncBufferedInputStream(InputStream input, int size) {
        super(input);
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.fBuffer = new byte[size];
        this.fCount = 0;
        this.fPosition = 0;
    }

    private void fill() throws IOException {
        int n = this.in.read(this.fBuffer, 0, this.fBuffer.length);
        if (n > 0) {
            this.fCount = n;
            this.fPosition = 0;
            int len = this.fBuffer.length;
            while (this.fCount < len && this.in.available() > 0) {
                n = this.in.read(this.fBuffer, this.fCount, len - this.fCount);
                if (n <= 0) break;
                this.fCount += n;
            }
        }
    }

    @Override
    public final int read() throws IOException {
        if (this.fPosition == this.fCount) {
            this.fill();
            if (this.fPosition == this.fCount) {
                return -1;
            }
        }
        return this.fBuffer[this.fPosition++] & 0xFF;
    }

    @Override
    public long skip(long n) throws IOException {
        long bytesSkipped = 0L;
        while (n-- > 0L) {
            if (this.read() == -1) break;
            ++bytesSkipped;
        }
        return bytesSkipped;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (off < 0) {
            throw new IndexOutOfBoundsException("off is negative: " + off);
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException("len is negative: " + len);
        }
        int maxPos = off + len;
        if (maxPos > b.length) {
            throw new IndexOutOfBoundsException("len too large: len=" + len + ", buffer length=" + b.length + ", offset=" + off);
        }
        if (this.fPosition == this.fCount) {
            this.fill();
            if (this.fPosition == this.fCount) {
                return -1;
            }
        }
        int pos = off;
        while (pos < maxPos && this.hasAvailable()) {
            if (this.fPosition == this.fCount) {
                this.fill();
                if (this.fPosition == this.fCount) {
                    return -1;
                }
            }
            int availInBuffer = this.fCount - this.fPosition;
            int lenToCopy = 0;
            lenToCopy = availInBuffer > maxPos - pos ? maxPos - pos : availInBuffer;
            FastArrayCopy.copy(this.fBuffer, this.fPosition, b, pos, lenToCopy);
            pos += lenToCopy;
            this.fPosition += lenToCopy;
        }
        return pos - off;
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        int n = 0;
        while (n < len) {
            int count = this.in.read(b, off + n, len - n);
            if (count < 0) {
                throw new EOFException();
            }
            n += count;
        }
    }

    @Override
    public int available() throws IOException {
        return this.fCount - this.fPosition + this.in.available();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void close() throws IOException {
        if (this.in == null) {
            return;
        }
        this.in.close();
        this.in = null;
        this.fBuffer = null;
    }

    public byte[] readAvailable() throws IOException {
        byte[] result = new byte[this.available()];
        this.readFully(result, 0, result.length);
        return result;
    }

    private boolean hasAvailable() throws IOException {
        if (this.fCount > this.fPosition) {
            return true;
        }
        return this.in.available() > 0;
    }

    public Reader getReader(boolean supportDoubleByte) {
        return new ReaderAdapter(supportDoubleByte);
    }

    private class ReaderAdapter
    extends Reader {
        private boolean fSupportDoubleByte;

        public ReaderAdapter(boolean supportDoubleByte) {
            this.fSupportDoubleByte = supportDoubleByte;
        }

        @Override
        public void close() throws IOException {
            NonSyncBufferedInputStream.this.close();
        }

        @Override
        public int read() throws IOException {
            int theChar = 0;
            if (this.fSupportDoubleByte) {
                theChar = NonSyncBufferedInputStream.this.read() << 8;
            }
            return theChar |= NonSyncBufferedInputStream.this.read();
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int numRead = 0;
            while (len-- > 0) {
                int tempc = this.read();
                if (tempc == -1) {
                    if (numRead == 0) {
                        return -1;
                    }
                    return numRead;
                }
                cbuf[off++] = (char)tempc;
                ++numRead;
            }
            return numRead;
        }
    }
}

