/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.apmservices.client.service;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.apmservices.client.api.MetadataServiceAPI;
import com.wily.introscope.agent.apmservices.client.api.NASSServiceAPI;
import com.wily.introscope.agent.apmservices.client.nass.metricbatch.MetricDataService;
import com.wily.introscope.agent.apmservices.client.nass.publisher.MetricPublisher;
import com.wily.introscope.agent.apmservices.client.service.APMServicesClientAPIService;
import com.wily.introscope.agent.apmservices.client.sustainability.SustainabilityMetricReporter;
import com.wily.introscope.agent.apmservices.client.utils.APMServicesConnection;
import com.wily.introscope.spec.metric.AgentMetricData;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.util.List;

public class NASSService
implements NASSServiceAPI {
    private IModuleFeedbackChannel logger;
    private MetadataServiceAPI metadataServiceAPI;
    private String hostProcessName;
    private MetricDataService metricBatchService;
    private MetricPublisher metricPublisher;

    public NASSService(IAgent iAgent, APMServicesConnection connection, MetadataServiceAPI metadataServiceAPI, String extensionName) {
        this.logger = iAgent.IAgent_getModuleFeedback();
        String[] triplet = iAgent.IAgent_getHostProcessAgentTriplet();
        this.hostProcessName = "SuperDomain|" + triplet[0] + "|" + triplet[1] + "|";
        this.metadataServiceAPI = metadataServiceAPI;
        this.logger.info("Host Process name is" + this.hostProcessName);
        this.metricBatchService = new MetricDataService(this.logger, this.hostProcessName);
        this.metricPublisher = new MetricPublisher(connection, this.logger, extensionName);
    }

    public void registerMetricToNass(String agentSource, List<AgentMetricData> agentMetricData, boolean firstTimeSlice) {
        if (agentSource.startsWith("SuperDomain")) {
            this.metadataServiceAPI.registerAgentMetric(agentSource, agentMetricData, firstTimeSlice);
        } else {
            this.metadataServiceAPI.registerAgentMetric(this.hostProcessName + agentSource, agentMetricData, firstTimeSlice);
        }
    }

    public Integer publishBatchMetrics(boolean async, List<AgentMetricData> agentMetricDataList) {
        Integer resultFuture = 0;
        int totalBatches = (int)Math.ceil((double)agentMetricDataList.size() / (double)APMServicesClientAPIService.BATCH_TO_PROCESS.intValue());
        for (int batchToRegister = 0; batchToRegister < totalBatches; ++batchToRegister) {
            int start = batchToRegister * APMServicesClientAPIService.BATCH_TO_PROCESS;
            int end = Math.min(start + APMServicesClientAPIService.BATCH_TO_PROCESS, agentMetricDataList.size());
            List<AgentMetricData> currentBatch = agentMetricDataList.subList(start, end);
            resultFuture = resultFuture + this.metricPublisher.publishMetricRecords(currentBatch, async);
        }
        return resultFuture;
    }

    @Override
    public Integer sendBatchMetric(String agentSource, List<AgentMetricData> agentMetricDataList, boolean firstTimeSlice) {
        long startTime = System.currentTimeMillis();
        this.registerMetricToNass(agentSource, agentMetricDataList, firstTimeSlice);
        Integer result = this.publishBatchMetrics(false, agentMetricDataList);
        long totalTime = System.currentTimeMillis() - startTime;
        SustainabilityMetricReporter.reportLongCounter("Agent Stats|Sustainability|APM Services Client|NASS:Register and Store Metric Average Total Time(ms)", totalTime);
        return result;
    }
}

