/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.errors;

import com.wily.introscope.agent.IAgent;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.heartbeat.IntervalHeartbeat;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class IdenticalErrorsCache
implements ITimestampedRunnable {
    private IAgent agent;
    private int maxErrorLimit;
    private long timePeriodMinute;
    private static Map identicalErrorsMap;
    private final IModuleFeedbackChannel feedbackChannel;
    private IRegisteredBehavior resetIdenticalErrorsCacheBehavior;

    public IdenticalErrorsCache(IAgent a, int maxErrorCount, long period) {
        this.agent = a;
        this.feedbackChannel = this.agent.IAgent_getModuleFeedback();
        this.maxErrorLimit = maxErrorCount;
        this.timePeriodMinute = period / 1000L / 60L;
        identicalErrorsMap = this.agent.IAgent_getConcurrentMapFactory().getConcurrentCappedMap("IdenticalErrorsCache");
        this.resetIdenticalErrorsCacheBehavior = this.agent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)this, "Identical Error Count Cache Clear", true, period, false);
    }

    @Override
    public void ITimestampedRunnable_execute(long nowInMillis) {
        if (identicalErrorsMap != null) {
            identicalErrorsMap.clear();
        }
    }

    public void setMaxErrorLimit(int count) {
        this.maxErrorLimit = count;
    }

    public boolean request(String errorMessage) {
        if (identicalErrorsMap.containsKey(errorMessage)) {
            int nextValue = ((AtomicInteger)identicalErrorsMap.get(errorMessage)).incrementAndGet();
            if (nextValue < this.maxErrorLimit) {
                return true;
            }
            if (nextValue == this.maxErrorLimit) {
                this.feedbackChannel.info("Temporarily no errorsnapshot will be sent for the error (" + errorMessage + "); because more than " + this.maxErrorLimit + " same errors have occurred in " + this.timePeriodMinute + " (min).");
            }
        } else {
            identicalErrorsMap.put(errorMessage, new AtomicInteger(0));
            return true;
        }
        return false;
    }

    public void resetErrorCountCleanPeriod(IntervalHeartbeat clearHeartbeat, long newPeriod) {
        if (this.resetIdenticalErrorsCacheBehavior != null) {
            clearHeartbeat.removeBehavior(this.resetIdenticalErrorsCacheBehavior);
        }
        this.timePeriodMinute = newPeriod / 1000L / 60L;
        if (newPeriod != 0L) {
            this.resetIdenticalErrorsCacheBehavior = clearHeartbeat.addBehavior((ITimestampedRunnable)this, "Identical Error Count Cache Clear", true, newPeriod, true);
        }
    }
}

