/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt;

import java.util.HashMap;
import java.util.Set;

public class NonSyncLRUCache<K, V> {
    private final int fMaxSize;
    private final HashMap<K, ValueWrapper<K, V>> fLookup;
    private HashMap<K, ValueWrapper<K, V>> fSnapshot;
    private ValueWrapper<K, V> fFirst;
    private ValueWrapper<K, V> fLast;

    public NonSyncLRUCache() {
        this(-1);
    }

    public NonSyncLRUCache(int maxSize) {
        if (maxSize < -1) {
            throw new IllegalArgumentException("the cache size must be at least zero (or -1 if no max size)");
        }
        this.fMaxSize = maxSize;
        this.fLookup = new HashMap();
        this.fFirst = null;
        this.fLast = null;
    }

    public void clear() {
        for (ValueWrapper<K, V> kvValueWrapper : this.fLookup.values()) {
            this.objectRemoved(kvValueWrapper);
        }
        this.fLookup.clear();
    }

    public int size() {
        return this.fLookup.size();
    }

    public V get(K key) {
        ValueWrapper<K, V> wrapper = this.fLookup.get(key);
        if (wrapper == null) {
            return null;
        }
        this.updateItem(wrapper);
        return wrapper.fValue;
    }

    protected HashMap<K, ValueWrapper<K, V>> getLookup() {
        return this.fLookup;
    }

    public Set<K> keySnapshot() {
        this.fSnapshot = (HashMap)this.fLookup.clone();
        return this.fSnapshot.keySet();
    }

    public void put(K key, V value) {
        ValueWrapper<K, V> wrapper;
        ValueWrapper<K, V> removed;
        if (this.fMaxSize == 0) {
            return;
        }
        if (this.fMaxSize != -1 && this.size() == this.fMaxSize && (removed = this.removeItem()) != null) {
            this.remove(removed.fKey);
        }
        if ((wrapper = this.fLookup.get(key)) != null) {
            this.removeItem(wrapper);
        }
        wrapper = new ValueWrapper<K, V>(key, value);
        this.fLookup.put(key, wrapper);
        this.addItem(wrapper);
    }

    protected void objectRemoved(Object value) {
    }

    public V remove(K key) {
        ValueWrapper<K, V> wrapper = this.fLookup.remove(key);
        if (wrapper == null) {
            return null;
        }
        this.removeItem(wrapper);
        this.objectRemoved(wrapper.fValue);
        return wrapper.fValue;
    }

    private void addItem(ValueWrapper<K, V> wrapper) {
        if (this.fFirst == null) {
            this.fFirst = wrapper;
            this.fLast = wrapper;
        } else {
            wrapper.fPrev = this.fLast;
            if (this.fLast != null) {
                this.fLast.fNext = wrapper;
            }
            this.fLast = wrapper;
        }
    }

    private void updateItem(ValueWrapper<K, V> wrapper) {
        this.removeItem(wrapper);
        this.addItem(wrapper);
    }

    private ValueWrapper<K, V> removeItem() {
        ValueWrapper<K, V> item = this.fFirst;
        if (item != null) {
            this.removeItem(item);
        }
        return item;
    }

    private void removeItem(ValueWrapper<K, V> wrapper) {
        if (wrapper.fPrev == null) {
            if (wrapper.fNext == null) {
                this.fFirst = null;
                this.fLast = null;
            } else {
                this.fFirst = wrapper.fNext;
                this.fFirst.fPrev = null;
            }
        } else if (wrapper.fNext == null) {
            this.fLast = wrapper.fPrev;
            this.fLast.fNext = null;
        } else {
            wrapper.fNext.fPrev = wrapper.fPrev;
            wrapper.fPrev.fNext = wrapper.fNext;
        }
        wrapper.fPrev = null;
        wrapper.fNext = null;
    }

    protected static class ValueWrapper<K, V> {
        public K fKey;
        public V fValue;
        public ValueWrapper<K, V> fPrev;
        public ValueWrapper<K, V> fNext;

        public ValueWrapper(K key, V value) {
            this.fKey = key;
            this.fValue = value;
            this.fPrev = null;
            this.fNext = null;
        }
    }
}

