/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.classmatcher;

import com.wily.diagnos.cmp.classmatcher.ACachingImmutableClassMatcher;
import com.wily.diagnos.cmp.classmatcher.DGCompoundClassMatcher;
import com.wily.diagnos.cmp.classmatcher.IClassMatcher;
import com.wily.util.CollectionEquivalenceCheckers;
import com.wily.util.HashCodeUtils;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IModeledClass;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class FixedCompoundClassMatcher
extends ACachingImmutableClassMatcher {
    private final IClassMatcher[] fMatchers;

    public FixedCompoundClassMatcher(IClassMatcher[] matchers) {
        this.fMatchers = matchers;
    }

    @Override
    public boolean IClassMatcher_matches(IModeledClass cls) {
        for (int i = 0; i < this.fMatchers.length; ++i) {
            if (!this.fMatchers[i].IClassMatcher_matches(cls)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean IClassMatcher_matches(IModeledClass cls, Map<IClassMatcher, Boolean> resultCache) {
        for (int i = 0; i < this.fMatchers.length; ++i) {
            if (!this.fMatchers[i].IClassMatcher_matches(cls, resultCache)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean IClassMatcher_supportsNameMatching() {
        for (int i = 0; i < this.fMatchers.length; ++i) {
            if (!this.fMatchers[i].IClassMatcher_supportsNameMatching()) continue;
            return true;
        }
        return this.fMatchers.length == 0;
    }

    @Override
    public boolean IClassMatcher_matches(IClassName className) {
        for (int i = 0; i < this.fMatchers.length; ++i) {
            if (!this.fMatchers[i].IClassMatcher_supportsNameMatching() || !this.fMatchers[i].IClassMatcher_matches(className)) continue;
            return true;
        }
        return false;
    }

    public DGCompoundClassMatcher generateMutableMatcher() {
        DGCompoundClassMatcher mutableClassMatcher = new DGCompoundClassMatcher();
        for (int i = 0; i < this.fMatchers.length; ++i) {
            IClassMatcher classMatcher = this.fMatchers[i];
            if (classMatcher instanceof FixedCompoundClassMatcher) {
                mutableClassMatcher.addClassMatcher(((FixedCompoundClassMatcher)classMatcher).generateMutableMatcher());
                continue;
            }
            mutableClassMatcher.addClassMatcher(this.fMatchers[i]);
        }
        return mutableClassMatcher;
    }

    public int hashCode() {
        int result = 17;
        int matcherListResult = 0;
        for (int i = 0; i < this.fMatchers.length; ++i) {
            matcherListResult += this.fMatchers[i].hashCode();
        }
        result = HashCodeUtils.accumulateHashCode((int)result, (int)matcherListResult);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FixedCompoundClassMatcher) {
            FixedCompoundClassMatcher m = (FixedCompoundClassMatcher)obj;
            return CollectionEquivalenceCheckers.listsAreEquivalent(Arrays.asList(this.fMatchers), Arrays.asList(m.fMatchers));
        }
        return false;
    }

    @Override
    public String[] getMatcherKeys() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.fMatchers.length; ++i) {
            String[] matcherKeys = this.fMatchers[i].getMatcherKeys();
            if (matcherKeys != null) {
                for (int j = 0; j < matcherKeys.length; ++j) {
                    result.add(matcherKeys[j]);
                }
                continue;
            }
            return null;
        }
        return result.toArray(new String[0]);
    }
}

